/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.BatchException;
import com.microsoft.azure.storage.BatchSubResponse;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ServiceClient;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.core.BaseRequest;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public abstract class BatchOperation<C extends ServiceClient, P, R>
implements Iterable<Map.Entry<StorageRequest<C, P, R>, P>> {
    private static final String HTTP_LINE_ENDING = "\r\n";
    private static final String HTTP_MIXED_MULTIPART_CONTENT_TYPE = "multipart/mixed";
    private static final String HTTP_MIXED_MULTIPART_DELIMITER_DEFINITION = "boundary=";
    private static final String STORAGE_BATCH_DELIMITER_PREFIX = "batch_";
    private final Map<StorageRequest<C, P, R>, P> subOperations = new LinkedHashMap<StorageRequest<C, P, R>, P>();
    private final UUID batchId = UUID.randomUUID();

    protected final void addSubOperation(StorageRequest<C, P, R> request, P parent) {
        Utility.assertInBounds("subOperationCount", this.subOperations.size(), 0L, 255L);
        this.subOperations.put(request, parent);
    }

    public UUID getBatchId() {
        return this.batchId;
    }

    protected abstract R convertResponse(BatchSubResponse var1);

    protected StorageRequest<C, BatchOperation<C, P, R>, Map<P, R>> batchImpl(C client, final RequestOptions requestOptions) {
        return new StorageRequest<C, BatchOperation<C, P, R>, Map<P, R>>(requestOptions, ((ServiceClient)client).getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(C client, BatchOperation<C, P, R> parentObject, OperationContext context) throws Exception {
                byte[] body = BaseRequest.buildBatchBody(client, parentObject, context);
                this.setSendStream(new ByteArrayInputStream(body));
                this.setLength(Long.valueOf(body.length));
                return BaseRequest.batch(((ServiceClient)client).getEndpoint(), requestOptions, context, null);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, BatchOperation<C, P, R> parentObject, OperationContext context) {
                connection.setRequestProperty("Content-Type", Utility.stringJoin((CharSequence)"; ", BatchOperation.HTTP_MIXED_MULTIPART_CONTENT_TYPE, "boundary=batch_" + parentObject.getBatchId()));
            }

            @Override
            public void signRequest(HttpURLConnection connection, C client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, this.getLength(), context);
            }

            @Override
            public Map<P, R> preProcessResponse(BatchOperation<C, P, R> parentObject, C client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public Map<P, R> postProcessResponse(HttpURLConnection connection, BatchOperation<C, P, R> parentObject, C client, OperationContext context, Map<P, R> storageObject) throws Exception {
                int bytesRead;
                ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
                byte[] readBuffer = new byte[1024];
                while ((bytesRead = connection.getInputStream().read(readBuffer, 0, readBuffer.length)) != -1) {
                    responseBuffer.write(readBuffer, 0, bytesRead);
                }
                responseBuffer.flush();
                List parsedResponses = BatchOperation.this.parseBatchBody(responseBuffer.toByteArray(), connection.getHeaderField("Content-Type").split(BatchOperation.HTTP_MIXED_MULTIPART_DELIMITER_DEFINITION)[1]);
                BatchOperation.this.throwIfUberRequestFails(parsedResponses);
                HashMap successfulResponses = new HashMap();
                HashMap failedResponses = new HashMap();
                BatchOperation.this.sortResponses(parsedResponses, successfulResponses, failedResponses);
                if (!failedResponses.isEmpty()) {
                    throw new BatchException(successfulResponses, failedResponses, context);
                }
                return successfulResponses;
            }
        };
    }

    private P findParent(BatchSubResponse subResponse) {
        int i = 0;
        for (Map.Entry<StorageRequest<C, P, R>, P> op : this.subOperations.entrySet()) {
            if (i == Integer.parseInt(subResponse.getHeaders().get("Content-ID"))) {
                return op.getValue();
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    private void sortResponses(List<BatchSubResponse> responses, Map<P, R> successfulBucket, Map<P, BatchSubResponse> failedBucket) {
        Iterator<BatchSubResponse> it = responses.iterator();
        while (it.hasNext()) {
            BatchSubResponse response = it.next();
            if (response.getStatusCode() / 100 != 2) {
                failedBucket.put(this.findParent(response), response);
                it.remove();
                continue;
            }
            successfulBucket.put(this.findParent(response), this.convertResponse(response));
        }
    }

    private void throwIfUberRequestFails(List<BatchSubResponse> parsedResponses) throws StorageException {
        if (parsedResponses.size() != 1) {
            return;
        }
        BatchSubResponse subResponse = parsedResponses.get(0);
        if (subResponse.getStatusCode() / 100 == 2) {
            return;
        }
        ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream();
        try {
            int bytesRead;
            byte[] readBuffer = new byte[1024];
            while ((bytesRead = subResponse.getBody().read(readBuffer, 0, readBuffer.length)) != -1) {
                responseBuffer.write(readBuffer, 0, bytesRead);
            }
            responseBuffer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new StorageException(subResponse.getStatusMessage(), responseBuffer.toString(), subResponse.getStatusCode(), null, null);
    }

    private List<BatchSubResponse> parseBatchBody(byte[] body, String responseDelimiter) {
        List<byte[]> subResponses = Utility.splitOnPattern(body, ("\r\n--" + responseDelimiter + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8));
        subResponses.set(0, Utility.splitOnPattern(subResponses.get(0), ("--" + responseDelimiter + HTTP_LINE_ENDING).getBytes(StandardCharsets.UTF_8)).get(0));
        subResponses.set(subResponses.size() - 1, Utility.splitOnPattern(subResponses.get(subResponses.size() - 1), ("\r\n--" + responseDelimiter + "--").getBytes(StandardCharsets.UTF_8)).get(0));
        ArrayList<BatchSubResponse> responses = new ArrayList<BatchSubResponse>();
        for (byte[] subResponse : subResponses) {
            responses.add(this.parseResponse(subResponse));
        }
        return responses;
    }

    private BatchSubResponse parseResponse(byte[] response) {
        int parsedStatusCode = 0;
        String parsedStatusMessage = "";
        HashMap<String, String> parsedHeaders = new HashMap<String, String>();
        ByteArrayInputStream body = null;
        int lineStart = 0;
        int numBlankLinesFound = 0;
        byte[] newlinePattern = HTTP_LINE_ENDING.getBytes();
        while (numBlankLinesFound < 2 && lineStart < response.length) {
            int lineEnd = Utility.findPattern(response, newlinePattern, lineStart);
            lineEnd = lineEnd == -1 ? response.length : lineEnd;
            String line = new String(Arrays.copyOfRange(response, lineStart, lineEnd));
            if (line.equals("")) {
                ++numBlankLinesFound;
            } else if (line.startsWith("HTTP")) {
                String[] lineTokens = line.split(" ");
                parsedStatusCode = Integer.parseInt(lineTokens[1]);
                if (lineTokens.length > 2) {
                    StringBuilder builder = new StringBuilder();
                    for (int i = 2; i < lineTokens.length; ++i) {
                        builder.append(lineTokens[i]).append(' ');
                    }
                    builder.deleteCharAt(builder.length() - 1);
                    parsedStatusMessage = builder.toString();
                }
            } else {
                String[] tokens = line.split(":");
                parsedHeaders.put(tokens[0], tokens[1].trim());
            }
            lineStart = lineEnd + newlinePattern.length;
        }
        if (lineStart < response.length) {
            body = new ByteArrayInputStream(response, lineStart, response.length - lineStart);
        }
        BatchSubResponse parsedResponse = new BatchSubResponse();
        parsedResponse.setStatusCode(parsedStatusCode);
        parsedResponse.setStatusMessage(parsedStatusMessage);
        parsedResponse.setHeaders(parsedHeaders);
        parsedResponse.setBody(body);
        return parsedResponse;
    }

    @Override
    public Iterator<Map.Entry<StorageRequest<C, P, R>, P>> iterator() {
        return new Iterator<Map.Entry<StorageRequest<C, P, R>, P>>(){
            final Iterator<Map.Entry<StorageRequest<C, P, R>, P>> baseIt;
            {
                this.baseIt = BatchOperation.this.subOperations.entrySet().iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.baseIt.hasNext();
            }

            @Override
            public Map.Entry<StorageRequest<C, P, R>, P> next() {
                return this.baseIt.next();
            }
        };
    }
}

