/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tika;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tika.TikaData;
import org.apache.hop.pipeline.transforms.tika.TikaMeta;
import org.apache.hop.pipeline.transforms.tika.TikaOutput;
import org.apache.tika.metadata.Metadata;
import org.json.simple.JSONObject;

public class Tika
extends BaseTransform<TikaMeta, TikaData> {
    private static final Class<?> PKG = TikaMeta.class;

    public Tika(TransformMeta transformMeta, TikaMeta meta, TikaData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private void addFileToResultFilesname(FileObject file) {
        if (((TikaMeta)this.meta).isAddingResultFile()) {
            ResultFile resultFile = new ResultFile(0, file, this.getPipelineMeta().getName(), this.getTransformName());
            resultFile.setComment("File was read by a Tika transform");
            this.addResultFile(resultFile);
        }
    }

    private boolean openNextFile() {
        try {
            if (((TikaMeta)this.meta).isFileInField()) {
                ((TikaData)this.data).readRow = this.getRow();
                if (((TikaData)this.data).readRow == null) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"Tika.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    ((TikaData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((TikaData)this.data).outputRowMeta = ((TikaData)this.data).inputRowMeta.clone();
                    ((TikaMeta)this.meta).getFields(((TikaData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((TikaData)this.data).convertRowMeta = ((TikaData)this.data).outputRowMeta.cloneToType(2);
                    if (((TikaMeta)this.meta).isFileInField()) {
                        if (StringUtils.isEmpty((String)((TikaMeta)this.meta).getDynamicFilenameField())) {
                            this.logError(BaseMessages.getString(PKG, (String)"Tika.Log.NoField", (String[])new String[0]));
                            throw new HopException(BaseMessages.getString(PKG, (String)"Tika.Log.NoField", (String[])new String[0]));
                        }
                        if (((TikaData)this.data).indexOfFilenameField < 0) {
                            ((TikaData)this.data).indexOfFilenameField = ((TikaData)this.data).inputRowMeta.indexOfValue(((TikaMeta)this.meta).getDynamicFilenameField());
                            if (((TikaData)this.data).indexOfFilenameField < 0) {
                                this.logError(BaseMessages.getString(PKG, (String)"Tika.Log.ErrorFindingField", (String[])new String[0]) + "[" + ((TikaMeta)this.meta).getDynamicFilenameField() + "]");
                                throw new HopException(BaseMessages.getString(PKG, (String)"Tika.Exception.CouldnotFindField", (String[])new String[]{((TikaMeta)this.meta).getDynamicFilenameField()}));
                            }
                        }
                        ((TikaData)this.data).totalPreviousFields = ((TikaData)this.data).inputRowMeta.size();
                    }
                }
                String fieldvalue = ((TikaData)this.data).inputRowMeta.getString(((TikaData)this.data).readRow, ((TikaData)this.data).indexOfFilenameField);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Tika.Log.Stream", (String[])new String[]{((TikaMeta)this.meta).getDynamicFilenameField(), fieldvalue}));
                }
                try {
                    ((TikaData)this.data).file = HopVfs.getFileObject((String)fieldvalue, (IVariables)this.variables);
                }
                catch (HopFileException e) {
                    throw new HopException((Throwable)e);
                }
                finally {
                    try {
                        if (((TikaData)this.data).file != null) {
                            ((TikaData)this.data).file.close();
                        }
                    }
                    catch (Exception e) {
                        this.logError("Error closing file", e);
                    }
                }
            }
            if (((TikaData)this.data).fileNr >= ((TikaData)this.data).files.nrOfFiles()) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Tika.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            ((TikaData)this.data).file = ((TikaData)this.data).files.getFile(((TikaData)this.data).fileNr);
            ((TikaData)this.data).fileSize = ((TikaData)this.data).file.getContent() != null ? ((TikaData)this.data).file.getContent().getSize() : 0L;
            ++((TikaData)this.data).fileNr;
            if (((TikaMeta)this.meta).isIgnoreEmptyFile() && ((TikaData)this.data).fileSize == 0L) {
                this.logError(BaseMessages.getString(PKG, (String)"Tika.Error.FileSizeZero", (String[])new String[]{String.valueOf(((TikaData)this.data).file.getName())}));
                this.openNextFile();
            } else {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Tika.Log.OpeningFile", (String[])new String[]{((TikaData)this.data).file.toString()}));
                }
                ((TikaData)this.data).filename = HopVfs.getFilename((FileObject)((TikaData)this.data).file);
                if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getShortFileFieldName())) {
                    ((TikaData)this.data).shortFilename = ((TikaData)this.data).file.getName().getBaseName();
                }
                if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getPathFieldName())) {
                    ((TikaData)this.data).path = HopVfs.getFilename((FileObject)((TikaData)this.data).file.getParent());
                }
                if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getHiddenFieldName())) {
                    ((TikaData)this.data).hidden = ((TikaData)this.data).file.isHidden();
                }
                if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getExtensionFieldName())) {
                    ((TikaData)this.data).extension = ((TikaData)this.data).file.getName().getExtension();
                }
                if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getLastModificationTimeFieldName())) {
                    ((TikaData)this.data).lastModificationDateTime = new Date(((TikaData)this.data).file.getContent().getLastModifiedTime());
                }
                if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getUriFieldName())) {
                    ((TikaData)this.data).uriName = ((TikaData)this.data).file.getName().getURI();
                }
                if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getRootUriNameFieldName())) {
                    ((TikaData)this.data).rootUriName = ((TikaData)this.data).file.getName().getRootURI();
                }
                this.getFileContent();
                this.addFileToResultFilesname(((TikaData)this.data).file);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Tika.Log.FileOpened", (String[])new String[]{((TikaData)this.data).file.toString()}));
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"Tika.Log.UnableToOpenFile", (String[])new String[]{"" + ((TikaData)this.data).fileNr, ((TikaData)this.data).file.toString(), e.toString()}), e);
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean processRow() throws HopException {
        try {
            Object[] outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"Tika.Log.ReadRow", (String[])new String[]{((TikaData)this.data).outputRowMeta.getString(outputRowData)}));
            }
            this.putRow(((TikaData)this.data).outputRowMeta, outputRowData);
            if (((TikaMeta)this.meta).getRowLimit() > 0L && ((TikaData)this.data).rowNr > ((TikaMeta)this.meta).getRowLimit()) {
                this.setOutputDone();
                return false;
            }
        }
        catch (HopException e) {
            String errorMessage = "Error encountered : " + e.getMessage();
            if (this.getTransformMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), new Object[0], 1L, errorMessage, ((TikaMeta)this.meta).getFilenameField(), "Tika001");
            }
            this.logError(BaseMessages.getString(PKG, (String)"Tika.ErrorInTransformRunning", (String[])new String[]{e.getMessage()}));
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"Tika.ErrorInTransformRunning", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    private void getFileContent() throws HopException {
        try {
            ((TikaData)this.data).fileContent = this.getTextFileContent(((TikaData)this.data).file.toString(), ((TikaMeta)this.meta).getEncoding());
        }
        catch (OutOfMemoryError o) {
            this.logError(BaseMessages.getString(PKG, (String)"Tika.Error.NotEnoughMemory", (Object[])new Object[]{((TikaData)this.data).file.getName()}));
            throw new HopException((Throwable)o);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public String getTextFileContent(String vfsFilename, String encoding) throws HopException {
        InputStream inputStream = null;
        String retval = null;
        try {
            inputStream = vfsFilename.startsWith("file:") ? new FileInputStream(vfsFilename.substring(5)) : HopVfs.getInputStream((String)vfsFilename, (IVariables)this.variables);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((TikaData)this.data).tikaOutput.parse(inputStream, ((TikaMeta)this.meta).getOutputFormat(), baos);
            retval = baos.toString();
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Tika.Error.GettingFileContent", (String[])new String[]{vfsFilename, e.toString()}), (Throwable)e);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                this.logError("Error closing reader", e);
            }
        }
        return retval;
    }

    private void handleMissingFiles() throws HopException {
        List nonExistantFiles = ((TikaData)this.data).files.getNonExistentFiles();
        if (!nonExistantFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"Tika.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"Tika.Log.RequiredFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"Tika.Log.RequiredFilesMissing", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = ((TikaData)this.data).files.getNonAccessibleFiles();
        if (!nonAccessibleFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"Tika.Log.RequiredFilesTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"Tika.Log.RequiredNotAccessibleFiles", (String[])new String[]{message})});
            throw new HopException(BaseMessages.getString(PKG, (String)"Tika.Log.RequiredNotAccessibleFilesMissing", (String[])new String[]{message}));
        }
    }

    private Object[] buildEmptyRow() {
        return RowDataUtil.allocateRowData((int)((TikaData)this.data).outputRowMeta.size());
    }

    private Object[] getOneRow() throws HopException {
        if (!this.openNextFile()) {
            return null;
        }
        Object[] outputRowData = this.buildEmptyRow();
        try {
            if (((TikaMeta)this.meta).isFileInField()) {
                System.arraycopy(((TikaData)this.data).readRow, 0, outputRowData, 0, ((TikaData)this.data).readRow.length);
            }
            int indexField = ((TikaData)this.data).totalPreviousFields;
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getContentFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).fileContent;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getFileSizeFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).fileSize;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getMetadataFieldName())) {
                outputRowData[indexField++] = this.getMetadataJson(((TikaData)this.data).tikaOutput.getLastMetadata());
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getFilenameField())) {
                outputRowData[indexField++] = ((TikaData)this.data).filename;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getRowNumberField())) {
                outputRowData[indexField++] = ((TikaData)this.data).rowNr;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getShortFileFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).shortFilename;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getExtensionFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).extension;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getPathFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).path;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getHiddenFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).hidden;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getLastModificationTimeFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).lastModificationDateTime;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getUriFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).uriName;
            }
            if (StringUtils.isNotEmpty((String)((TikaMeta)this.meta).getRootUriNameFieldName())) {
                outputRowData[indexField++] = ((TikaData)this.data).rootUriName;
            }
            this.incrementLinesInput();
            ++((TikaData)this.data).rowNr;
        }
        catch (Exception e) {
            throw new HopException("Impossible de charger le fichier", (Throwable)e);
        }
        return outputRowData;
    }

    private String getMetadataJson(Metadata metadata) {
        JSONObject obj = new JSONObject();
        for (String name : metadata.names()) {
            obj.put((Object)name, (Object)metadata.get(name));
        }
        return obj.toJSONString();
    }

    public boolean init() {
        if (super.init()) {
            if (!((TikaMeta)this.meta).isFileInField()) {
                try {
                    ((TikaData)this.data).files = ((TikaMeta)this.meta).getFiles((IVariables)this);
                    this.handleMissingFiles();
                    ((TikaData)this.data).outputRowMeta = new RowMeta();
                    ((TikaMeta)this.meta).getFields(((TikaData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((TikaData)this.data).convertRowMeta = ((TikaData)this.data).outputRowMeta.cloneToType(2);
                }
                catch (Exception e) {
                    this.logError("Error at step initialization: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            try {
                ClassLoader classLoader = ((Object)((Object)((TikaMeta)this.meta))).getClass().getClassLoader();
                ((TikaData)this.data).tikaOutput = new TikaOutput(classLoader, this.getLogChannel(), (IVariables)this);
            }
            catch (Exception e) {
                this.logError("Tika Error", e);
            }
            ((TikaData)this.data).rowNr = 1L;
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((TikaData)this.data).file != null) {
            try {
                ((TikaData)this.data).file.close();
            }
            catch (Exception e) {
                this.logError("Error closing file", e);
            }
        }
        super.dispose();
    }
}

