/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.drools;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.drools.RuleValidationException;
import org.apache.hop.pipeline.transforms.drools.Rules;
import org.apache.hop.pipeline.transforms.drools.RulesAccumulatorData;
import org.apache.hop.pipeline.transforms.drools.RulesAccumulatorMeta;

public class RulesAccumulator
extends BaseTransform<RulesAccumulatorMeta, RulesAccumulatorData> {
    private static final Class<?> PKG = Rules.class;

    public RulesAccumulator(TransformMeta transformMeta, RulesAccumulatorMeta meta, RulesAccumulatorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        return super.init();
    }

    public boolean runtimeInit() throws HopTransformException {
        try {
            ((RulesAccumulatorData)this.data).setOutputRowMeta(this.getInputRowMeta().clone());
            ((RulesAccumulatorMeta)this.meta).setKeepInputFields(false);
            ((RulesAccumulatorMeta)this.meta).getFields(((RulesAccumulatorData)this.data).getOutputRowMeta(), this.getTransformName(), null, null, (IVariables)this, null);
            ((RulesAccumulatorData)this.data).setRuleFilePath(((RulesAccumulatorMeta)this.meta).getRuleFile());
            ((RulesAccumulatorData)this.data).setRuleString(((RulesAccumulatorMeta)this.meta).getRuleDefinition());
            try {
                ((RulesAccumulatorData)this.data).initializeRules();
            }
            catch (RuleValidationException e) {
                for (String message : e.getMessages()) {
                    this.logError(message);
                }
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"RulesData.Error.CompileDRL", (String[])new String[0]));
            }
            ((RulesAccumulatorData)this.data).initializeInput(this.getInputRowMeta());
            return true;
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public boolean processRow() throws HopException {
        try {
            Object[] r = this.getRow();
            if (r == null) {
                ((RulesAccumulatorData)this.data).execute();
                String[] expectedResults = ((RulesAccumulatorMeta)this.meta).getExpectedResultList();
                for (Rules.Row resultRow : ((RulesAccumulatorData)this.data).getResultRows()) {
                    Object[] outputRow = new Object[expectedResults.length];
                    for (String columnName : expectedResults) {
                        outputRow[((RulesAccumulatorData)this.data).getOutputRowMeta().indexOfValue((String)columnName)] = resultRow.getColumn().get(columnName);
                    }
                    this.putRow(((RulesAccumulatorData)this.data).getOutputRowMeta(), outputRow);
                }
                ((RulesAccumulatorData)this.data).shutdown();
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                if (!this.runtimeInit()) {
                    return false;
                }
                this.first = false;
            }
            ((RulesAccumulatorData)this.data).loadRow(r);
            return true;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

