/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.antlr.codegen.CodeGenerator;
import org.antlr.grammar.v3.ANTLRTreePrinter;
import org.antlr.grammar.v3.LeftRecursiveRuleWalker;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.antlr.tool.AttributeScope;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;
import org.antlr.tool.ToolSTGroupFile;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public class LeftRecursiveRuleAnalyzer
extends LeftRecursiveRuleWalker {
    public Grammar g;
    public CodeGenerator generator;
    public String ruleName;
    Map<Integer, Integer> tokenToPrec = new HashMap<Integer, Integer>();
    public LinkedHashMap<Integer, String> binaryAlts = new LinkedHashMap();
    public LinkedHashMap<Integer, String> ternaryAlts = new LinkedHashMap();
    public LinkedHashMap<Integer, String> suffixAlts = new LinkedHashMap();
    public List<String> prefixAlts = new ArrayList<String>();
    public List<String> otherAlts = new ArrayList<String>();
    public GrammarAST retvals;
    public STGroup recRuleTemplates;
    public String language;
    public Map<Integer, ASSOC> altAssociativity = new HashMap<Integer, ASSOC>();

    public LeftRecursiveRuleAnalyzer(TreeNodeStream input, Grammar g, String ruleName) {
        super(input);
        this.g = g;
        this.ruleName = ruleName;
        this.language = (String)g.getOption("language");
        this.generator = new CodeGenerator(g.tool, g, this.language);
        this.generator.loadTemplates(this.language);
        this.loadPrecRuleTemplates();
    }

    public void loadPrecRuleTemplates() {
        this.recRuleTemplates = new ToolSTGroupFile(CodeGenerator.classpathTemplateRootDirectoryName + "/LeftRecursiveRules.stg");
        if (!this.recRuleTemplates.isDefined("recRuleName")) {
            ErrorManager.error(20, "PrecRules");
            return;
        }
    }

    @Override
    public void setReturnValues(GrammarAST t) {
        System.out.println((Object)t);
        this.retvals = t;
    }

    @Override
    public void setTokenPrec(GrammarAST t, int alt) {
        String a;
        int ttype = this.g.getTokenType(t.getText());
        this.tokenToPrec.put(ttype, alt);
        ASSOC assoc = ASSOC.left;
        if (t.terminalOptions != null && (a = (String)t.terminalOptions.get("assoc")) != null) {
            if (a.equals(ASSOC.right.toString())) {
                assoc = ASSOC.right;
            } else {
                ErrorManager.error(168, (Object)"assoc", (Object)assoc);
            }
        }
        if (this.altAssociativity.get(alt) != null && this.altAssociativity.get(alt) != assoc) {
            ErrorManager.error(169, alt);
        }
        this.altAssociativity.put(alt, assoc);
    }

    @Override
    public void binaryAlt(GrammarAST altTree, GrammarAST rewriteTree, int alt) {
        altTree = GrammarAST.dupTree(altTree);
        rewriteTree = GrammarAST.dupTree(rewriteTree);
        this.stripSynPred(altTree);
        this.stripLeftRecursion(altTree);
        int nextPrec = this.nextPrecedence(alt);
        ST refST = this.recRuleTemplates.getInstanceOf("recRuleRef");
        refST.add("ruleName", (Object)this.ruleName);
        refST.add("arg", (Object)nextPrec);
        altTree = this.replaceRuleRefs(altTree, refST.render());
        String altText = this.text(altTree);
        altText = altText.trim();
        altText = altText + "{}";
        ST nameST = this.recRuleTemplates.getInstanceOf("recRuleName");
        nameST.add("ruleName", (Object)this.ruleName);
        rewriteTree = this.replaceRuleRefs(rewriteTree, "$" + nameST.render());
        String rewriteText = this.text(rewriteTree);
        this.binaryAlts.put(alt, altText + (rewriteText != null ? " " + rewriteText : ""));
    }

    @Override
    public void ternaryAlt(GrammarAST altTree, GrammarAST rewriteTree, int alt) {
        altTree = GrammarAST.dupTree(altTree);
        rewriteTree = GrammarAST.dupTree(rewriteTree);
        this.stripSynPred(altTree);
        this.stripLeftRecursion(altTree);
        int nextPrec = this.nextPrecedence(alt);
        ST refST = this.recRuleTemplates.getInstanceOf("recRuleRef");
        refST.add("ruleName", (Object)this.ruleName);
        refST.add("arg", (Object)nextPrec);
        altTree = this.replaceLastRuleRef(altTree, refST.render());
        String altText = this.text(altTree);
        altText = altText.trim();
        altText = altText + "{}";
        ST nameST = this.recRuleTemplates.getInstanceOf("recRuleName");
        nameST.add("ruleName", (Object)this.ruleName);
        rewriteTree = this.replaceRuleRefs(rewriteTree, "$" + nameST.render());
        String rewriteText = this.text(rewriteTree);
        this.ternaryAlts.put(alt, altText + (rewriteText != null ? " " + rewriteText : ""));
    }

    @Override
    public void prefixAlt(GrammarAST altTree, GrammarAST rewriteTree, int alt) {
        altTree = GrammarAST.dupTree(altTree);
        rewriteTree = GrammarAST.dupTree(rewriteTree);
        this.stripSynPred(altTree);
        int nextPrec = this.precedence(alt);
        ST refST = this.recRuleTemplates.getInstanceOf("recRuleRef");
        refST.add("ruleName", (Object)this.ruleName);
        refST.add("arg", (Object)nextPrec);
        altTree = this.replaceRuleRefs(altTree, refST.render());
        String altText = this.text(altTree);
        altText = altText.trim();
        altText = altText + "{}";
        ST nameST = this.recRuleTemplates.getInstanceOf("recRuleName");
        nameST.add("ruleName", (Object)this.ruleName);
        rewriteTree = this.replaceRuleRefs(rewriteTree, nameST.render());
        String rewriteText = this.text(rewriteTree);
        this.prefixAlts.add(altText + (rewriteText != null ? " " + rewriteText : ""));
    }

    @Override
    public void suffixAlt(GrammarAST altTree, GrammarAST rewriteTree, int alt) {
        altTree = GrammarAST.dupTree(altTree);
        rewriteTree = GrammarAST.dupTree(rewriteTree);
        this.stripSynPred(altTree);
        this.stripLeftRecursion(altTree);
        ST nameST = this.recRuleTemplates.getInstanceOf("recRuleName");
        nameST.add("ruleName", (Object)this.ruleName);
        rewriteTree = this.replaceRuleRefs(rewriteTree, "$" + nameST.render());
        String rewriteText = this.text(rewriteTree);
        String altText = this.text(altTree);
        altText = altText.trim();
        this.suffixAlts.put(alt, altText + (rewriteText != null ? " " + rewriteText : ""));
    }

    @Override
    public void otherAlt(GrammarAST altTree, GrammarAST rewriteTree, int alt) {
        altTree = GrammarAST.dupTree(altTree);
        rewriteTree = GrammarAST.dupTree(rewriteTree);
        this.stripSynPred(altTree);
        this.stripLeftRecursion(altTree);
        String altText = this.text(altTree);
        String rewriteText = this.text(rewriteTree);
        this.otherAlts.add(altText + (rewriteText != null ? " " + rewriteText : ""));
    }

    public String getArtificialPrecStartRule() {
        ST ruleST = this.recRuleTemplates.getInstanceOf("recRuleStart");
        ruleST.add("ruleName", (Object)this.ruleName);
        ruleST.add("minPrec", (Object)0);
        ruleST.add("userRetvals", (Object)this.retvals);
        this.fillRetValAssignments(ruleST, "recRuleName");
        System.out.println("start: " + ruleST);
        return ruleST.render();
    }

    public String getArtificialOpPrecRule() {
        ST ruleST = this.recRuleTemplates.getInstanceOf("recRule");
        ruleST.add("ruleName", (Object)this.ruleName);
        ruleST.add("buildAST", (Object)this.grammar.buildAST());
        ST argDefST = this.generator.getTemplates().getInstanceOf("recRuleDefArg");
        ruleST.add("precArgDef", (Object)argDefST);
        ST ruleArgST = this.generator.getTemplates().getInstanceOf("recRuleArg");
        ruleST.add("argName", (Object)ruleArgST);
        ST setResultST = this.generator.getTemplates().getInstanceOf("recRuleSetResultAction");
        ruleST.add("setResultAction", (Object)setResultST);
        ruleST.add("userRetvals", (Object)this.retvals);
        this.fillRetValAssignments(ruleST, "recPrimaryName");
        LinkedHashMap<Integer, String> opPrecRuleAlts = new LinkedHashMap<Integer, String>();
        opPrecRuleAlts.putAll(this.binaryAlts);
        opPrecRuleAlts.putAll(this.ternaryAlts);
        opPrecRuleAlts.putAll(this.suffixAlts);
        for (Map.Entry entry : opPrecRuleAlts.entrySet()) {
            int alt = (Integer)entry.getKey();
            String altText = (String)entry.getValue();
            ST altST = this.recRuleTemplates.getInstanceOf("recRuleAlt");
            ST predST = this.generator.getTemplates().getInstanceOf("recRuleAltPredicate");
            predST.add("opPrec", (Object)this.precedence(alt));
            predST.add("ruleName", (Object)this.ruleName);
            altST.add("pred", (Object)predST);
            altST.add("alt", (Object)altText);
            ruleST.add("alts", (Object)altST);
        }
        System.out.println(ruleST);
        return ruleST.render();
    }

    public String getArtificialPrimaryRule() {
        ST ruleST = this.recRuleTemplates.getInstanceOf("recPrimaryRule");
        ruleST.add("ruleName", (Object)this.ruleName);
        ruleST.add("alts", this.prefixAlts);
        ruleST.add("alts", this.otherAlts);
        ruleST.add("userRetvals", (Object)this.retvals);
        System.out.println(ruleST);
        return ruleST.render();
    }

    public GrammarAST replaceRuleRefs(GrammarAST t, String name) {
        if (t == null) {
            return null;
        }
        for (GrammarAST rref : t.findAllType(80)) {
            if (!rref.getText().equals(this.ruleName)) continue;
            rref.setText(name);
        }
        return t;
    }

    public static boolean hasImmediateRecursiveRuleRefs(GrammarAST t, String ruleName) {
        if (t == null) {
            return false;
        }
        for (GrammarAST rref : t.findAllType(80)) {
            if (!rref.getText().equals(ruleName)) continue;
            return true;
        }
        return false;
    }

    public GrammarAST replaceLastRuleRef(GrammarAST t, String name) {
        if (t == null) {
            return null;
        }
        GrammarAST last = null;
        Iterator<GrammarAST> iterator = t.findAllType(80).iterator();
        while (iterator.hasNext()) {
            GrammarAST rref;
            last = rref = iterator.next();
        }
        if (last != null && last.getText().equals(this.ruleName)) {
            last.setText(name);
        }
        return t;
    }

    public void stripSynPred(GrammarAST altAST) {
        GrammarAST t = (GrammarAST)altAST.getChild(0);
        if (t.getType() == 14 || t.getType() == 89 || t.getType() == 90) {
            altAST.deleteChild(0);
        }
    }

    public void stripLeftRecursion(GrammarAST altAST) {
        GrammarAST rref = (GrammarAST)altAST.getChild(0);
        if (rref.getType() == 80 && rref.getText().equals(this.ruleName)) {
            altAST.deleteChild(0);
            GrammarAST newFirstChild = (GrammarAST)altAST.getChild(0);
            altAST.setTokenStartIndex(newFirstChild.getTokenStartIndex());
        }
    }

    public String text(GrammarAST t) {
        if (t == null) {
            return null;
        }
        try {
            return new ANTLRTreePrinter((TreeNodeStream)new CommonTreeNodeStream((Object)t)).toString(this.grammar, true);
        }
        catch (Exception e) {
            ErrorManager.error(15, e);
            return null;
        }
    }

    public int precedence(int alt) {
        return this.numAlts - alt + 1;
    }

    public int nextPrecedence(int alt) {
        int p = this.precedence(alt);
        if (this.altAssociativity.get(alt) == ASSOC.left) {
            ++p;
        }
        return p;
    }

    public void fillRetValAssignments(ST ruleST, String srcName) {
        if (this.retvals == null) {
            return;
        }
        for (String name : this.getNamesFromArgAction(this.retvals.token)) {
            ST setRetValST = this.generator.getTemplates().getInstanceOf("recRuleSetReturnAction");
            ST ruleNameST = this.recRuleTemplates.getInstanceOf(srcName);
            ruleNameST.add("ruleName", (Object)this.ruleName);
            setRetValST.add("src", (Object)ruleNameST);
            setRetValST.add("name", (Object)name);
            ruleST.add("userRetvalAssignments", (Object)setRetValST);
        }
    }

    public Collection<String> getNamesFromArgAction(Token t) {
        AttributeScope returnScope = this.grammar.createReturnScope("", t);
        returnScope.addAttributes(t.getText(), 44);
        return returnScope.attributes.keySet();
    }

    public String toString() {
        return "PrecRuleOperatorCollector{binaryAlts=" + this.binaryAlts + ", rec=" + this.tokenToPrec + ", ternaryAlts=" + this.ternaryAlts + ", suffixAlts=" + this.suffixAlts + ", prefixAlts=" + this.prefixAlts + ", otherAlts=" + this.otherAlts + '}';
    }

    public static enum ASSOC {
        left,
        right;

    }
}

