/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.jdbc.MetadataAPIHelper;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.logger.RedshiftLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class MetadataAPIPostProcessing
extends MetadataAPIHelper {
    protected final RedshiftConnectionImpl connection;

    public MetadataAPIPostProcessing(RedshiftConnectionImpl connection) {
        super(connection);
        this.connection = connection;
    }

    protected ResultSet getCatalogsPostProcessing(ResultSet serverRs) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getCatalogsPostProcessing", new Object[0]);
        }
        ArrayList<Tuple> final_data = new ArrayList<Tuple>();
        while (serverRs.next()) {
            byte[][] tuple = this.getEmptyTuple(this.GET_CATALOGS_COLS, this.GET_CATALOGS_COLS.length);
            tuple[MetadataAPIHelper.GetCatalogs_Metadata.TABLE_CAT.getIndex()] = this.encodeStr(serverRs.getString("database_name"));
            final_data.add(new Tuple(tuple));
        }
        return this.createRs(this.GET_CATALOGS_COLS, final_data);
    }

    protected ResultSet getSchemasPostProcessing(List<ResultSet> serverRs, boolean retEmpty) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getSchemasPostProcessing", new Object[0]);
        }
        if (retEmpty) {
            return this.createEmptyRs(this.GET_SCHEMAS_COLS, this.GET_SCHEMAS_COLS.length);
        }
        ArrayList<Tuple> final_data = new ArrayList<Tuple>();
        for (ResultSet rs : serverRs) {
            while (rs.next()) {
                byte[][] tuple = this.getEmptyTuple(this.GET_SCHEMAS_COLS, this.GET_SCHEMAS_COLS.length);
                tuple[MetadataAPIHelper.GetSchemas_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr(rs.getString("schema_name"));
                tuple[MetadataAPIHelper.GetSchemas_Metadata.TABLE_CATALOG.getIndex()] = this.encodeStr(rs.getString("database_name"));
                final_data.add(new Tuple(tuple));
            }
        }
        return this.createRs(this.GET_SCHEMAS_COLS, final_data);
    }

    protected ResultSet getTablesPostProcessing(List<ResultSet> serverRs, boolean retEmpty, String[] types) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getTablesPostProcessing", new Object[0]);
        }
        if (retEmpty) {
            return this.createEmptyRs(this.GET_TABLES_COLS, this.GET_TABLES_COLS.length);
        }
        ArrayList<Tuple> final_data = new ArrayList<Tuple>();
        HashSet<String> typeSet = null;
        if (types != null) {
            typeSet = new HashSet<String>(Arrays.asList(types));
        }
        for (ResultSet rs : serverRs) {
            while (rs.next()) {
                if (types != null && !typeSet.contains(rs.getString("table_type"))) continue;
                byte[][] tuple = this.getEmptyTuple(this.GET_TABLES_COLS, this.GET_TABLES_COLS.length);
                tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_CAT.getIndex()] = this.encodeStr(rs.getString("database_name"));
                tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr(rs.getString("schema_name"));
                tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_NAME.getIndex()] = this.encodeStr(rs.getString("table_name"));
                tuple[MetadataAPIHelper.GetTables_Metadata.TABLE_TYPE.getIndex()] = this.encodeStr(rs.getString("table_type"));
                tuple[MetadataAPIHelper.GetTables_Metadata.REMARKS.getIndex()] = this.encodeStr(rs.getString("remarks"));
                final_data.add(new Tuple(tuple));
            }
        }
        return this.createRs(this.GET_TABLES_COLS, final_data);
    }

    protected ResultSet getColumnsPostProcessing(List<ResultSet> serverRs, boolean retEmpty) throws SQLException {
        if (RedshiftLogger.isEnable()) {
            this.connection.getLogger().logDebug("Calling getColumnsPostProcessing", new Object[0]);
        }
        if (retEmpty) {
            return this.createEmptyRs(this.GET_COLUMNS_COLS, this.GET_COLUMNS_COLS.length);
        }
        ArrayList<Tuple> final_data = new ArrayList<Tuple>();
        for (ResultSet rs : serverRs) {
            while (rs.next()) {
                String rsType;
                String dataType = rs.getString("data_type");
                int precisions = 0;
                boolean dateTimeCustomizePrecision = false;
                if (dataType.matches("(time|timetz|timestamp|timestamptz)\\(\\d+\\).*") || dataType.matches("interval.*.\\(\\d+\\)")) {
                    rsType = this.getRSType(dataType.replaceAll("\\(\\d+\\)", "").replaceFirst("\\s++$", ""));
                    precisions = Integer.parseInt(dataType.replaceAll(".*\\(([0-9]+)\\).*", "$1"));
                    dateTimeCustomizePrecision = true;
                } else {
                    rsType = this.getRSType(dataType);
                }
                String sqlType = this.getSQLType(rsType);
                String autoIncrement = this.getAutoIncrement(rs.getString("column_default"));
                byte[][] tuple = this.getEmptyTuple(this.GET_COLUMNS_COLS, this.GET_COLUMNS_COLS.length);
                tuple[MetadataAPIHelper.GetColumns_Metadata.TABLE_CAT.getIndex()] = this.encodeStr(rs.getString("database_name"));
                tuple[MetadataAPIHelper.GetColumns_Metadata.TABLE_SCHEM.getIndex()] = this.encodeStr(rs.getString("schema_name"));
                tuple[MetadataAPIHelper.GetColumns_Metadata.TABLE_NAME.getIndex()] = this.encodeStr(rs.getString("table_name"));
                tuple[MetadataAPIHelper.GetColumns_Metadata.COLUMN_NAME.getIndex()] = this.encodeStr(rs.getString("column_name"));
                tuple[MetadataAPIHelper.GetColumns_Metadata.DATA_TYPE.getIndex()] = this.encodeStr(sqlType);
                tuple[MetadataAPIHelper.GetColumns_Metadata.TYPE_NAME.getIndex()] = this.encodeStr(rsType);
                tuple[MetadataAPIHelper.GetColumns_Metadata.COLUMN_SIZE.getIndex()] = this.encodeStr(this.getColumnSize(rsType, rs.getString("character_maximum_length"), rs.getString("numeric_precision")));
                tuple[MetadataAPIHelper.GetColumns_Metadata.BUFFER_LENGTH.getIndex()] = null;
                tuple[MetadataAPIHelper.GetColumns_Metadata.DECIMAL_DIGITS.getIndex()] = this.encodeStr(this.getDecimalDigit(rsType, rs.getString("numeric_scale"), precisions, dateTimeCustomizePrecision));
                tuple[MetadataAPIHelper.GetColumns_Metadata.NUM_PREC_RADIX.getIndex()] = this.encodeStr(this.getNumPrefixRadix(rs.getString("data_type")));
                tuple[MetadataAPIHelper.GetColumns_Metadata.NULLABLE.getIndex()] = this.encodeStr(this.getNullable(rs.getString("is_nullable")));
                tuple[MetadataAPIHelper.GetColumns_Metadata.REMARKS.getIndex()] = this.encodeStr(rs.getString("remarks"));
                tuple[MetadataAPIHelper.GetColumns_Metadata.COLUMN_DEF.getIndex()] = this.encodeStr(rs.getString("column_default"));
                tuple[MetadataAPIHelper.GetColumns_Metadata.SQL_DATA_TYPE.getIndex()] = this.encodeStr(sqlType);
                tuple[MetadataAPIHelper.GetColumns_Metadata.SQL_DATETIME_SUB.getIndex()] = null;
                tuple[MetadataAPIHelper.GetColumns_Metadata.CHAR_OCTET_LENGTH.getIndex()] = this.encodeStr(this.getColumnSize(rsType, rs.getString("character_maximum_length"), rs.getString("numeric_precision")));
                tuple[MetadataAPIHelper.GetColumns_Metadata.ORDINAL_POSITION.getIndex()] = this.encodeStr(rs.getString("ordinal_position"));
                tuple[MetadataAPIHelper.GetColumns_Metadata.IS_NULLABLE.getIndex()] = this.encodeStr(rs.getString("is_nullable"));
                tuple[MetadataAPIHelper.GetColumns_Metadata.SCOPE_CATALOG.getIndex()] = null;
                tuple[MetadataAPIHelper.GetColumns_Metadata.SCOPE_SCHEMA.getIndex()] = null;
                tuple[MetadataAPIHelper.GetColumns_Metadata.SCOPE_TABLE.getIndex()] = null;
                tuple[MetadataAPIHelper.GetColumns_Metadata.SOURCE_DATA_TYPE.getIndex()] = null;
                tuple[MetadataAPIHelper.GetColumns_Metadata.IS_AUTOINCREMENT.getIndex()] = this.encodeStr(autoIncrement);
                tuple[MetadataAPIHelper.GetColumns_Metadata.IS_GENERATEDCOLUMN.getIndex()] = this.encodeStr(autoIncrement);
                final_data.add(new Tuple(tuple));
            }
        }
        return this.createRs(this.GET_COLUMNS_COLS, final_data);
    }
}

