/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceinput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnectionUtils;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInput;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputData;
import org.apache.hop.pipeline.transforms.salesforceinput.SalesforceInputField;
import org.w3c.dom.Node;

@Transform(id="SalesforceInput", name="i18n::SalesforceInput.TypeLongDesc.SalesforceInput", description="i18n::SalesforceInput.TypeTooltipDesc.SalesforceInput", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", image="SFI.svg", keywords={"i18n::SalesforceInputMeta.keyword"}, documentationUrl="/pipeline/transforms/salesforceinput.html")
@InjectionSupported(localizationPrefix="SalesforceInputMeta.Injection.", groups={"FIELDS"})
public class SalesforceInputMeta
extends SalesforceTransformMeta<SalesforceInput, SalesforceInputData> {
    public static final String CONST_FIELDS = "fields";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Class<?> PKG = SalesforceInputMeta.class;
    @Injection(name="INCLUDE_SQL_IN_OUTPUT")
    private boolean includeSQL;
    @Injection(name="SQL_FIELDNAME")
    private String sqlField;
    @Injection(name="INCLUDE_TIMESTAMP_IN_OUTPUT")
    private boolean includeTimestamp;
    @Injection(name="TIMESTAMP_FIELDNAME")
    private String timestampField;
    @Injection(name="INCLUDE_URL_IN_OUTPUT")
    private boolean includeTargetURL;
    @Injection(name="URL_FIELDNAME")
    private String targetURLField;
    @Injection(name="INCLUDE_MODULE_IN_OUTPUT")
    private boolean includeModule;
    @Injection(name="MODULE_FIELDNAME")
    private String moduleField;
    @Injection(name="INCLUDE_DELETION_DATE_IN_OUTPUT")
    private boolean includeDeletionDate;
    @Injection(name="DELETION_DATE_FIELDNAME")
    private String deletionDateField;
    @Injection(name="INCLUDE_ROWNUM_IN_OUTPUT")
    private boolean includeRowNumber;
    @Injection(name="ROWNUM_FIELDNAME")
    private String rowNumberField;
    @Injection(name="QUERY_CONDITION")
    private String condition;
    @Injection(name="LIMIT")
    private String rowLimit;
    @InjectionDeep
    private SalesforceInputField[] inputFields;
    @Injection(name="USE_SPECIFIED_QUERY")
    private boolean specifyQuery;
    @Injection(name="SPECIFY_QUERY")
    private String query;
    private int nrFields;
    @Injection(name="END_DATE")
    private String readTo;
    @Injection(name="START_DATE")
    private String readFrom;
    private int recordsFilter;
    @Injection(name="QUERY_ALL")
    private boolean queryAll;

    public SalesforceInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(SalesforceInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isSpecifyQuery() {
        return this.specifyQuery;
    }

    public void setSpecifyQuery(boolean specifyQuery) {
        this.specifyQuery = specifyQuery;
    }

    public boolean isQueryAll() {
        return this.queryAll;
    }

    public void setQueryAll(boolean queryAll) {
        this.queryAll = queryAll;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setTargetURLField(String targetURLField) {
        this.targetURLField = targetURLField;
    }

    public void setSQLField(String sqlField) {
        this.sqlField = sqlField;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField;
    }

    public void setModuleField(String moduleField) {
        this.moduleField = moduleField;
    }

    public int getRecordsFilter() {
        return this.recordsFilter;
    }

    public void setRecordsFilter(int recordsFilter) {
        this.recordsFilter = recordsFilter;
    }

    @Injection(name="RETRIEVE")
    public void setRecordsFilterDesc(String recordsFilterDesc) {
        this.recordsFilter = SalesforceConnectionUtils.getRecordsFilterByDesc(recordsFilterDesc);
    }

    public boolean includeTargetURL() {
        return this.includeTargetURL;
    }

    public boolean includeSQL() {
        return this.includeSQL;
    }

    public void setIncludeSQL(boolean includeSQL) {
        this.includeSQL = includeSQL;
    }

    public boolean includeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    public boolean includeModule() {
        return this.includeModule;
    }

    public void setIncludeTargetURL(boolean includeTargetURL) {
        this.includeTargetURL = includeTargetURL;
    }

    public void setIncludeModule(boolean includeModule) {
        this.includeModule = includeModule;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean includeDeletionDate() {
        return this.includeDeletionDate;
    }

    public void setIncludeDeletionDate(boolean includeDeletionDate) {
        this.includeDeletionDate = includeDeletionDate;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public String getDeletionDateField() {
        return this.deletionDateField;
    }

    public void setDeletionDateField(String value) {
        this.deletionDateField = value;
    }

    public String getTargetURLField() {
        return this.targetURLField;
    }

    public String getReadFrom() {
        return this.readFrom;
    }

    public void setReadFrom(String readFrom) {
        this.readFrom = readFrom;
    }

    public String getReadTo() {
        return this.readTo;
    }

    public void setReadTo(String readTo) {
        this.readTo = readTo;
    }

    public String getSQLField() {
        return this.sqlField;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public String getModuleField() {
        return this.moduleField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        super.loadXml(transformNode, metadataProvider);
        this.readData(transformNode);
    }

    @Override
    public Object clone() {
        SalesforceInputMeta retval = (SalesforceInputMeta)((Object)super.clone());
        int nrFields = this.inputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (SalesforceInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXml() {
        StringBuilder retval = new StringBuilder(super.getXml());
        retval.append("    ").append(XmlHandler.addTagValue((String)"condition", (String)this.getCondition()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"specifyQuery", (boolean)this.isSpecifyQuery()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"query", (String)this.getQuery()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_targeturl", (boolean)this.includeTargetURL()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"targeturl_field", (String)this.getTargetURLField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_module", (boolean)this.includeModule()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"module_field", (String)this.getModuleField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_rownum", (boolean)this.includeRowNumber()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_deletion_date", (boolean)this.includeDeletionDate()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"deletion_date_field", (String)this.getDeletionDateField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.getRowNumberField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_sql", (boolean)this.includeSQL()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"sql_field", (String)this.getSQLField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"include_Timestamp", (boolean)this.includeTimestamp()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"timestamp_field", (String)this.getTimestampField()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"read_from", (String)this.getReadFrom()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"read_to", (String)this.getReadTo()));
        retval.append("    ").append(XmlHandler.addTagValue((String)"records_filter", (String)SalesforceConnectionUtils.getRecordsFilterCode(this.getRecordsFilter())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"queryAll", (boolean)this.isQueryAll()));
        retval.append("    ").append(XmlHandler.openTag((String)CONST_FIELDS)).append(Const.CR);
        for (SalesforceInputField field : this.inputFields) {
            retval.append(field.getXml());
        }
        retval.append("    ").append(XmlHandler.closeTag((String)CONST_FIELDS)).append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (String)this.getRowLimit()));
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.setCondition(XmlHandler.getTagValue((Node)transformNode, (String)"condition"));
            this.setQuery(XmlHandler.getTagValue((Node)transformNode, (String)"query"));
            this.setSpecifyQuery("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"specifyQuery")));
            this.setIncludeTargetURL("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_targeturl")));
            this.setTargetURLField(XmlHandler.getTagValue((Node)transformNode, (String)"targeturl_field"));
            this.setIncludeModule("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_module")));
            this.setModuleField(XmlHandler.getTagValue((Node)transformNode, (String)"module_field"));
            this.setIncludeRowNumber("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_rownum")));
            this.setIncludeDeletionDate("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_deletion_date")));
            this.setRowNumberField(XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field"));
            this.setDeletionDateField(XmlHandler.getTagValue((Node)transformNode, (String)"deletion_date_field"));
            this.setIncludeSQL("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_sql")));
            this.setSQLField(XmlHandler.getTagValue((Node)transformNode, (String)"sql_field"));
            this.setIncludeTimestamp("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"include_Timestamp")));
            this.setTimestampField(XmlHandler.getTagValue((Node)transformNode, (String)"timestamp_field"));
            this.setReadFrom(XmlHandler.getTagValue((Node)transformNode, (String)"read_from"));
            this.setReadTo(XmlHandler.getTagValue((Node)transformNode, (String)"read_to"));
            this.setRecordsFilter(SalesforceConnectionUtils.getRecordsFilterByCode(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"records_filter"), (String)"")));
            this.setQueryAll("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"queryAll")));
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)CONST_FIELDS);
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                SalesforceInputField field;
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new SalesforceInputField(fnode);
            }
            this.setRowLimit(XmlHandler.getTagValue((Node)transformNode, (String)"limit"));
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrFields) {
        this.setInputFields(new SalesforceInputField[nrFields]);
    }

    public int getNrFields() {
        return this.nrFields;
    }

    @Override
    public void setDefault() {
        super.setDefault();
        this.setIncludeDeletionDate(false);
        this.setQueryAll(false);
        this.setReadFrom("");
        this.setReadTo("");
        this.nrFields = 0;
        this.setSpecifyQuery(false);
        this.setQuery("");
        this.setCondition("");
        this.setIncludeTargetURL(false);
        this.setTargetURLField("");
        this.setIncludeModule(false);
        this.setModuleField("");
        this.setIncludeRowNumber(false);
        this.setRowNumberField("");
        this.setDeletionDateField("");
        this.setIncludeSQL(false);
        this.setSQLField("");
        this.setIncludeTimestamp(false);
        this.setTimestampField("");
        this.allocate(0);
        this.setRowLimit("0");
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            SalesforceInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                IValueMeta v2 = ValueMetaFactory.createValueMeta((String)variables.resolve(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setOrigin(name);
                v2.setConversionMask(field.getFormat());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.includeTargetURL && !Utils.isEmpty((CharSequence)this.targetURLField)) {
            v = new ValueMetaString(variables.resolve(this.targetURLField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeModule && !Utils.isEmpty((CharSequence)this.moduleField)) {
            v = new ValueMetaString(variables.resolve(this.moduleField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeSQL && !Utils.isEmpty((CharSequence)this.sqlField)) {
            v = new ValueMetaString(variables.resolve(this.sqlField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeTimestamp && !Utils.isEmpty((CharSequence)this.timestampField)) {
            v = new ValueMetaDate(variables.resolve(this.timestampField));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeRowNumber && !Utils.isEmpty((CharSequence)this.rowNumberField)) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeDeletionDate && !Utils.isEmpty((CharSequence)this.deletionDateField)) {
            v = new ValueMetaDate(variables.resolve(this.deletionDateField));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    @Override
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        super.check(remarks, pipelineMeta, transformMeta, prev, input, output, info, variables, metadataProvider);
        CheckResult cr = input != null && input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = this.getInputFields().length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.FieldsOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (this.includeTargetURL() && Utils.isEmpty((CharSequence)this.getTargetURLField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoTargetURLField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeSQL() && Utils.isEmpty((CharSequence)this.getSQLField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoSQLField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeModule() && Utils.isEmpty((CharSequence)this.moduleField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoModuleField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeTimestamp() && Utils.isEmpty((CharSequence)this.getTimestampField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoTimestampField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeRowNumber() && Utils.isEmpty((CharSequence)this.getRowNumberField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoRowNumberField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.includeDeletionDate() && Utils.isEmpty((CharSequence)this.getDeletionDateField())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoDeletionDateField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }
}

