/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.theta.BitPacking;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.DirectCompactCompressedSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.WrappedCompactCompressedSketch;
import org.apache.datasketches.theta.WrappedCompactSketch;

public abstract class CompactThetaSketch
extends ThetaSketch {
    public static CompactThetaSketch heapify(MemorySegment srcSeg) {
        return CompactThetaSketch.heapify(srcSeg, 9001L);
    }

    public static CompactThetaSketch heapify(MemorySegment srcSeg, long expectedSeed) {
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        Family family = Family.idToFamily(familyID);
        if (family != Family.COMPACT) {
            throw new SketchesArgumentException("Corrupted: " + String.valueOf((Object)family) + " is not Compact!");
        }
        if (serVer == 4) {
            return CompactThetaSketch.heapifyV4(srcSeg, expectedSeed);
        }
        if (serVer == 3) {
            boolean empty;
            int flags = PreambleUtil.extractFlags(srcSeg);
            boolean srcOrdered = (flags & 0x10) != 0;
            boolean bl = empty = (flags & 4) != 0;
            if (!empty) {
                PreambleUtil.checkSegmentSeedHash(srcSeg, expectedSeed);
            }
            return CompactOperations.segmentToCompact(srcSeg, srcOrdered, null);
        }
        throw new SketchesArgumentException("Corrupted: Serialization Version " + serVer + " not recognized.");
    }

    public static CompactThetaSketch wrap(MemorySegment srcSeg) {
        return CompactThetaSketch.wrap(srcSeg, 9001L);
    }

    public static CompactThetaSketch wrap(MemorySegment srcSeg, long expectedSeed) {
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        Family family = Family.idToFamily(familyID);
        if (family != Family.COMPACT) {
            throw new SketchesArgumentException("Corrupted: " + String.valueOf((Object)family) + " is not Compact!");
        }
        short seedHash = Util.computeSeedHash(expectedSeed);
        if (serVer == 3) {
            boolean readOnly;
            boolean compactFlag;
            if (PreambleUtil.isEmptyFlag(srcSeg)) {
                return EmptyCompactSketch.getHeapInstance(srcSeg);
            }
            if (SingleItemSketch.checkForSingleItem(srcSeg)) {
                return SingleItemSketch.heapify(srcSeg, seedHash);
            }
            int flags = PreambleUtil.extractFlags(srcSeg);
            boolean bl = compactFlag = (flags & 8) > 0;
            if (!compactFlag) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have compact flag set");
            }
            boolean bl2 = readOnly = (flags & 2) > 0;
            if (!readOnly) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have Read-Only flag set");
            }
            return DirectCompactSketch.wrapInstance(srcSeg, seedHash);
        }
        if (serVer == 4) {
            return DirectCompactCompressedSketch.wrapInstance(srcSeg, seedHash);
        }
        throw new SketchesArgumentException("Corrupted: Serialization Version " + serVer + " not recognized.");
    }

    public static CompactThetaSketch wrap(byte[] bytes) {
        return CompactThetaSketch.wrap(bytes, 9001L);
    }

    public static CompactThetaSketch wrap(byte[] bytes, long expectedSeed) {
        byte serVer = bytes[1];
        byte familyId = bytes[2];
        Family family = Family.idToFamily(familyId);
        if (family != Family.COMPACT) {
            throw new SketchesArgumentException("Corrupted: " + String.valueOf((Object)family) + " is not Compact!");
        }
        short seedHash = Util.computeSeedHash(expectedSeed);
        if (serVer == 3) {
            boolean readOnly;
            boolean compactFlag;
            byte flags = bytes[5];
            if ((flags & 4) > 0) {
                return EmptyCompactSketch.getHeapInstance(MemorySegment.ofArray(bytes));
            }
            byte preLongs = bytes[0];
            if (SingleItemSketch.checkForSingleItem(preLongs, serVer, familyId, flags)) {
                return SingleItemSketch.heapify(MemorySegment.ofArray(bytes), seedHash);
            }
            boolean bl = compactFlag = (flags & 8) > 0;
            if (!compactFlag) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have compact flag set");
            }
            boolean bl2 = readOnly = (flags & 2) > 0;
            if (!readOnly) {
                throw new SketchesArgumentException("Corrupted: COMPACT family sketch image must have Read-Only flag set");
            }
            return WrappedCompactSketch.wrapInstance(bytes, seedHash);
        }
        if (serVer == 4) {
            return WrappedCompactCompressedSketch.wrapInstance(bytes, seedHash);
        }
        throw new SketchesArgumentException("Corrupted: Serialization Version " + serVer + " not recognized.");
    }

    @Override
    public abstract CompactThetaSketch compact(boolean var1, MemorySegment var2);

    @Override
    public int getCompactBytes() {
        return this.getCurrentBytes();
    }

    @Override
    int getCurrentDataLongs() {
        return this.getRetainedEntries(true);
    }

    @Override
    public Family getFamily() {
        return Family.COMPACT;
    }

    @Override
    public boolean hasMemorySegment() {
        return this instanceof DirectCompactSketch && ((DirectCompactSketch)this).hasMemorySegment();
    }

    @Override
    public boolean isCompact() {
        return true;
    }

    @Override
    public boolean isOffHeap() {
        return this instanceof DirectCompactSketch && ((DirectCompactSketch)this).isOffHeap();
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return this instanceof DirectCompactSketch && ((DirectCompactSketch)this).isSameResource(that);
    }

    @Override
    public double getEstimate() {
        return ThetaSketch.estimate(this.getThetaLong(), this.getRetainedEntries());
    }

    public byte[] toByteArrayCompressed() {
        if (!this.isOrdered() || this.getRetainedEntries() == 0 || this.getRetainedEntries() == 1 && !this.isEstimationMode()) {
            return this.toByteArray();
        }
        return this.toByteArrayV4();
    }

    private int computeMinLeadingZeros() {
        long previous = 0L;
        long ored = 0L;
        HashIterator it = this.iterator();
        while (it.next()) {
            long delta = it.get() - previous;
            ored |= delta;
            previous = it.get();
        }
        return Long.numberOfLeadingZeros(ored);
    }

    private byte[] toByteArrayV4() {
        int preambleLongs = this.isEstimationMode() ? 2 : 1;
        int entryBits = 64 - this.computeMinLeadingZeros();
        int compressedBits = entryBits * this.getRetainedEntries();
        int numEntriesBytes = PreambleUtil.wholeBytesToHoldBits(32 - Integer.numberOfLeadingZeros(this.getRetainedEntries()));
        int sizeBytes = preambleLongs * 8 + numEntriesBytes + PreambleUtil.wholeBytesToHoldBits(compressedBits);
        byte[] bytes = new byte[sizeBytes];
        MemorySegment wseg = MemorySegment.ofArray(bytes);
        int offsetBytes = 0;
        wseg.set(ValueLayout.JAVA_BYTE, (long)offsetBytes++, (byte)preambleLongs);
        wseg.set(ValueLayout.JAVA_BYTE, (long)offsetBytes++, (byte)4);
        wseg.set(ValueLayout.JAVA_BYTE, (long)offsetBytes++, (byte)Family.COMPACT.getID());
        wseg.set(ValueLayout.JAVA_BYTE, (long)offsetBytes++, (byte)entryBits);
        wseg.set(ValueLayout.JAVA_BYTE, (long)offsetBytes++, (byte)numEntriesBytes);
        wseg.set(ValueLayout.JAVA_BYTE, (long)offsetBytes++, (byte)26);
        wseg.set(ValueLayout.JAVA_SHORT_UNALIGNED, (long)offsetBytes, this.getSeedHash());
        offsetBytes += 2;
        if (this.isEstimationMode()) {
            wseg.set(ValueLayout.JAVA_LONG_UNALIGNED, (long)offsetBytes, this.getThetaLong());
            offsetBytes += 8;
        }
        int numEntries = this.getRetainedEntries();
        for (int i = 0; i < numEntriesBytes; ++i) {
            wseg.set(ValueLayout.JAVA_BYTE, (long)offsetBytes++, (byte)(numEntries & 0xFF));
            numEntries >>>= 8;
        }
        long previous = 0L;
        long[] deltas = new long[8];
        HashIterator it = this.iterator();
        int i = 0;
        while (i + 7 < this.getRetainedEntries()) {
            for (int j = 0; j < 8; ++j) {
                it.next();
                deltas[j] = it.get() - previous;
                previous = it.get();
            }
            BitPacking.packBitsBlock8(deltas, 0, bytes, offsetBytes, entryBits);
            offsetBytes += entryBits;
            i += 8;
        }
        int offsetBits = 0;
        while (i < this.getRetainedEntries()) {
            it.next();
            long delta = it.get() - previous;
            previous = it.get();
            BitPacking.packBits(delta, entryBits, bytes, offsetBytes, offsetBits);
            offsetBytes += offsetBits + entryBits >>> 3;
            offsetBits = offsetBits + entryBits & 7;
            ++i;
        }
        return bytes;
    }

    private static CompactThetaSketch heapifyV4(MemorySegment srcSeg, long seed) {
        int preLongs = ThetaSketch.getPreambleLongs(srcSeg);
        int entryBits = PreambleUtil.extractEntryBitsV4(srcSeg);
        int numEntriesBytes = PreambleUtil.extractNumEntriesBytesV4(srcSeg);
        short seedHash = (short)PreambleUtil.extractSeedHash(srcSeg);
        PreambleUtil.checkSegmentSeedHash(srcSeg, seed);
        int offsetBytes = 8;
        long theta = Long.MAX_VALUE;
        if (preLongs > 1) {
            theta = PreambleUtil.extractThetaLongV4(srcSeg);
            offsetBytes += 8;
        }
        int numEntries = 0;
        for (int i = 0; i < numEntriesBytes; ++i) {
            numEntries |= Byte.toUnsignedInt(srcSeg.get(ValueLayout.JAVA_BYTE, (long)offsetBytes++)) << (i << 3);
        }
        long[] entries = new long[numEntries];
        byte[] bytes = new byte[entryBits];
        int i = 0;
        while (i + 7 < numEntries) {
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_BYTE, offsetBytes, bytes, 0, entryBits);
            BitPacking.unpackBitsBlock8(entries, i, bytes, 0, entryBits);
            offsetBytes += entryBits;
            i += 8;
        }
        if (i < numEntries) {
            MemorySegment.copy(srcSeg, ValueLayout.JAVA_BYTE, offsetBytes, bytes, 0, PreambleUtil.wholeBytesToHoldBits((numEntries - i) * entryBits));
            int offsetBits = 0;
            offsetBytes = 0;
            while (i < numEntries) {
                BitPacking.unpackBits(entries, i, entryBits, bytes, offsetBytes, offsetBits);
                offsetBytes += offsetBits + entryBits >>> 3;
                offsetBits = offsetBits + entryBits & 7;
                ++i;
            }
        }
        long previous = 0L;
        for (i = 0; i < numEntries; ++i) {
            int n = i;
            entries[n] = entries[n] + previous;
            previous = entries[i];
        }
        return new HeapCompactSketch(entries, false, seedHash, numEntries, theta, true);
    }
}

