/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.request.Lifetime;
import org.apache.cxf.sts.request.Participants;
import org.apache.cxf.sts.token.provider.ConditionsProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderUtils;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.wss4j.common.saml.bean.AudienceRestrictionBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;

public class DefaultConditionsProvider
implements ConditionsProvider {
    public static final long DEFAULT_MAX_LIFETIME = 43200L;
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultConditionsProvider.class);
    private long lifetime = 1800L;
    private long maxLifetime = 43200L;
    private boolean failLifetimeExceedance = true;
    private boolean acceptClientLifetime;
    private long futureTimeToLive = 60L;

    public long getFutureTimeToLive() {
        return this.futureTimeToLive;
    }

    public void setFutureTimeToLive(long futureTimeToLive) {
        this.futureTimeToLive = futureTimeToLive;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public long getLifetime() {
        return this.lifetime;
    }

    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public boolean isAcceptClientLifetime() {
        return this.acceptClientLifetime;
    }

    public void setAcceptClientLifetime(boolean acceptClientLifetime) {
        this.acceptClientLifetime = acceptClientLifetime;
    }

    public boolean isFailLifetimeExceedance() {
        return this.failLifetimeExceedance;
    }

    public void setFailLifetimeExceedance(boolean failLifetimeExceedance) {
        this.failLifetimeExceedance = failLifetimeExceedance;
    }

    @Override
    public ConditionsBean getConditions(TokenProviderParameters providerParameters) {
        ConditionsBean conditions = new ConditionsBean();
        Lifetime tokenLifetime = providerParameters.getTokenRequirements().getLifetime();
        if (this.lifetime > 0L) {
            if (this.acceptClientLifetime && tokenLifetime != null && (tokenLifetime.getCreated() != null || tokenLifetime.getExpires() != null)) {
                Instant creationTime = this.parsedInstantOrDefault(tokenLifetime.getCreated(), Instant.now());
                Instant expirationTime = this.parsedInstantOrDefault(tokenLifetime.getExpires(), creationTime.plusSeconds(this.lifetime));
                Instant validCreation = Instant.now();
                if (this.futureTimeToLive > 0L) {
                    validCreation = validCreation.plusSeconds(this.futureTimeToLive);
                }
                if (creationTime.isAfter(validCreation)) {
                    LOG.fine("The Created Time is too far in the future");
                    throw new STSException("The Created Time is too far in the future", STSException.INVALID_TIME);
                }
                long requestedLifetime = Duration.between(creationTime, expirationTime).getSeconds();
                if (requestedLifetime > this.getMaxLifetime()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Requested lifetime [").append(requestedLifetime);
                    sb.append(" sec] exceed configured maximum lifetime [").append(this.getMaxLifetime());
                    sb.append(" sec]");
                    LOG.warning(sb.toString());
                    if (this.isFailLifetimeExceedance()) {
                        throw new STSException("Requested lifetime exceeds maximum lifetime", STSException.INVALID_TIME);
                    }
                    expirationTime = creationTime.plusSeconds(this.getMaxLifetime());
                }
                conditions.setNotAfter(expirationTime);
                conditions.setNotBefore(creationTime);
            } else {
                conditions.setTokenPeriodSeconds(this.lifetime);
            }
        } else {
            conditions.setTokenPeriodMinutes(5);
        }
        List<AudienceRestrictionBean> audienceRestrictions = this.createAudienceRestrictions(providerParameters);
        if (audienceRestrictions != null && !audienceRestrictions.isEmpty()) {
            conditions.setAudienceRestrictions(audienceRestrictions);
        }
        return conditions;
    }

    private Instant parsedInstantOrDefault(String dateTime, Instant defaultInstant) {
        if (dateTime == null || dateTime.isEmpty()) {
            return defaultInstant;
        }
        try {
            return ZonedDateTime.parse(dateTime).toInstant();
        }
        catch (DateTimeParseException ex) {
            LOG.fine("Error in parsing Timestamp Created or Expiration Strings");
            throw new STSException("Error in parsing Timestamp Created or Expiration Strings", STSException.INVALID_TIME);
        }
    }

    protected List<AudienceRestrictionBean> createAudienceRestrictions(TokenProviderParameters providerParameters) {
        Participants participants;
        ArrayList<AudienceRestrictionBean> audienceRestrictions = new ArrayList<AudienceRestrictionBean>();
        String appliesToAddress = providerParameters.getAppliesToAddress();
        if (appliesToAddress != null) {
            AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
            audienceRestriction.setAudienceURIs(Collections.singletonList(appliesToAddress));
            audienceRestrictions.add(audienceRestriction);
        }
        if ((participants = providerParameters.getTokenRequirements().getParticipants()) != null) {
            String address = this.extractAddressFromParticipantsEPR(participants.getPrimaryParticipant());
            if (address != null) {
                AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
                audienceRestriction.setAudienceURIs(Collections.singletonList(address));
                audienceRestrictions.add(audienceRestriction);
            }
            if (participants.getParticipants() != null) {
                for (Object participant : participants.getParticipants()) {
                    if (participant == null || (address = this.extractAddressFromParticipantsEPR(participant)) == null) continue;
                    AudienceRestrictionBean audienceRestriction = new AudienceRestrictionBean();
                    audienceRestriction.setAudienceURIs(Collections.singletonList(address));
                    audienceRestrictions.add(audienceRestriction);
                }
            }
        }
        return audienceRestrictions;
    }

    protected String extractAddressFromParticipantsEPR(Object participants) {
        return TokenProviderUtils.extractAddressFromParticipantsEPR(participants);
    }
}

