/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.ml.distance;

import org.apache.commons.math4.core.jdkmath.JdkMath;
import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.ml.distance.DistanceMeasure;

public class CanberraDistance
implements DistanceMeasure {
    @Override
    public double compute(double[] a, double[] b) {
        MathArrays.checkEqualLength((double[])a, (double[])b);
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double num = JdkMath.abs((double)(a[i] - b[i]));
            double denom = JdkMath.abs((double)a[i]) + JdkMath.abs((double)b[i]);
            sum += num == 0.0 && denom == 0.0 ? 0.0 : num / denom;
        }
        return sum;
    }
}

