/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.attributes.internal;

import com.vladsch.flexmark.ast.AnchorRefTarget;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.util.AnchorRefTargetBlockVisitor;
import com.vladsch.flexmark.ext.attributes.AttributeImplicitName;
import com.vladsch.flexmark.ext.attributes.AttributeNode;
import com.vladsch.flexmark.ext.attributes.AttributeValueQuotes;
import com.vladsch.flexmark.ext.attributes.AttributesDelimiter;
import com.vladsch.flexmark.ext.attributes.AttributesExtension;
import com.vladsch.flexmark.ext.attributes.AttributesNode;
import com.vladsch.flexmark.ext.attributes.internal.AttributesFormatOptions;
import com.vladsch.flexmark.ext.attributes.internal.NodeAttributeRepository;
import com.vladsch.flexmark.formatter.ExplicitAttributeIdProvider;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.formatter.FormattingPhase;
import com.vladsch.flexmark.formatter.MarkdownWriter;
import com.vladsch.flexmark.formatter.MergeContext;
import com.vladsch.flexmark.formatter.NodeFormatter;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.formatter.NodeFormatterFactory;
import com.vladsch.flexmark.formatter.NodeFormattingHandler;
import com.vladsch.flexmark.formatter.PhasedNodeFormatter;
import com.vladsch.flexmark.formatter.RenderPurpose;
import com.vladsch.flexmark.html.renderer.HtmlIdGenerator;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.html.MutableAttributes;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.PrefixedSubSequence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesNodeFormatter
implements PhasedNodeFormatter,
ExplicitAttributeIdProvider {
    public static final DataKey<Map<String, String>> ATTRIBUTE_TRANSLATION_MAP = new DataKey("ATTRIBUTE_TRANSLATION_MAP", HashMap::new);
    public static final DataKey<Map<String, String>> ATTRIBUTE_TRANSLATED_MAP = new DataKey("ATTRIBUTE_TRANSLATED_MAP", HashMap::new);
    public static final DataKey<Map<String, String>> ATTRIBUTE_ORIGINAL_ID_MAP = new DataKey("ATTRIBUTE_ORIGINAL_ID_MAP", HashMap::new);
    public static final DataKey<Set<Node>> PROCESSED_ATTRIBUTES = new DataKey("PROCESSED_ATTRIBUTES", HashSet::new);
    public static final DataKey<Map<String, String>> ATTRIBUTE_UNIQUIFICATION_ID_MAP = Formatter.ATTRIBUTE_UNIQUIFICATION_ID_MAP;
    public static final DataKey<Map<String, String>> ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP = new DataKey("ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP", HashMap::new);
    public static final DataKey<Integer> ATTRIBUTE_TRANSLATION_ID = new DataKey("ATTRIBUTE_TRANSLATION_ID", (Object)0);
    private Map<String, String> attributeTranslationMap;
    private Map<String, String> attributeTranslatedMap;
    private Map<String, String> attributeOriginalIdMap;
    private Map<String, String> attributeUniquificationIdMap;
    private int attributeOriginalId;
    private final AttributesFormatOptions formatOptions;

    public AttributesNodeFormatter(DataHolder options) {
        this.formatOptions = new AttributesFormatOptions(options);
    }

    @Nullable
    public Set<Class<?>> getNodeClasses() {
        return null;
    }

    @Nullable
    public Set<FormattingPhase> getFormattingPhases() {
        return Collections.singleton(FormattingPhase.COLLECT);
    }

    public void addExplicitId(@NotNull Node node, @Nullable String id, @NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown) {
        String uniqueId;
        if (id != null && node instanceof Heading && context.getRenderPurpose() == RenderPurpose.TRANSLATED && this.hasNoIdAttribute(node) && this.attributeUniquificationIdMap != null && !(uniqueId = this.attributeUniquificationIdMap.getOrDefault(id, id)).equals(id)) {
            markdown.append((CharSequence)" {.");
            markdown.append((CharSequence)uniqueId);
            markdown.append((CharSequence)"}");
        }
    }

    boolean hasNoIdAttribute(Node node) {
        boolean haveIdAttribute = false;
        for (Node child : node.getChildren()) {
            if (!(child instanceof AttributesNode)) continue;
            for (Node attr : child.getChildren()) {
                if (!(attr instanceof AttributeNode) || !((AttributeNode)attr).isId()) continue;
                haveIdAttribute = true;
                break;
            }
            if (!haveIdAttribute) continue;
            break;
        }
        return !haveIdAttribute;
    }

    public void renderDocument(@NotNull NodeFormatterContext context, @NotNull MarkdownWriter markdown, @NotNull Document document, @NotNull FormattingPhase phase) {
        if (context.isTransformingText()) {
            context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_ID, (Object)0);
            this.attributeOriginalId = 0;
            if (phase == FormattingPhase.COLLECT) {
                context.getDocument().remove(PROCESSED_ATTRIBUTES);
                if (context.getRenderPurpose() == RenderPurpose.TRANSLATION_SPANS) {
                    context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_MAP, new HashMap());
                    context.getTranslationStore().set(ATTRIBUTE_TRANSLATED_MAP, new HashMap());
                    context.getTranslationStore().set(ATTRIBUTE_ORIGINAL_ID_MAP, new HashMap());
                    MergeContext mergeContext = context.getMergeContext();
                    if (mergeContext != null) {
                        final HashSet mergedUniquified = new HashSet();
                        mergeContext.forEachPrecedingDocument(document, (docContext, doc, index) -> {
                            NodeAttributeRepository attributes = (NodeAttributeRepository)AttributesExtension.NODE_ATTRIBUTES.get((DataHolder)doc);
                            final Map idUniquificationMap = (Map)ATTRIBUTE_UNIQUIFICATION_ID_MAP.get((DataHolder)docContext.getTranslationStore());
                            for (List list : attributes.values()) {
                                for (AttributesNode attributesNode : list) {
                                    for (Node childNode : attributesNode.getChildren()) {
                                        String key;
                                        String newKey;
                                        AttributeNode attributeNode;
                                        if (!(childNode instanceof AttributeNode) || !(attributeNode = (AttributeNode)childNode).isId() || mergedUniquified.contains(newKey = idUniquificationMap.getOrDefault(key = attributeNode.getValue().toString(), key))) continue;
                                        mergedUniquified.add(newKey);
                                    }
                                }
                            }
                            final HtmlIdGenerator generator = context.getIdGenerator();
                            if (generator != null) {
                                new AnchorRefTargetBlockVisitor(){

                                    protected void visit(AnchorRefTarget refTarget) {
                                        Node node = (Node)refTarget;
                                        if (AttributesNodeFormatter.this.hasNoIdAttribute(node)) {
                                            String newKey;
                                            String key = generator.getId(node);
                                            if (key == null) {
                                                String text = refTarget.getAnchorRefText();
                                                key = generator.getId((CharSequence)text);
                                                refTarget.setAnchorRefId(key);
                                            }
                                            if (key != null && !mergedUniquified.contains(newKey = idUniquificationMap.getOrDefault(key, key))) {
                                                mergedUniquified.add(newKey);
                                            }
                                        }
                                    }
                                }.visit((Node)document);
                            }
                        });
                        NodeAttributeRepository attributes = (NodeAttributeRepository)AttributesExtension.NODE_ATTRIBUTES.get((DataHolder)document);
                        Map categoryUniquificationMap = (Map)ATTRIBUTE_UNIQUIFICATION_CATEGORY_MAP.get((DataHolder)context.getTranslationStore());
                        final HashMap<String, String> idMap = new HashMap<String, String>();
                        for (List list : attributes.values()) {
                            for (AttributesNode attributesNode : list) {
                                for (Node childNode : attributesNode.getChildren()) {
                                    String key;
                                    AttributeNode attributeNode;
                                    if (!(childNode instanceof AttributeNode) || !(attributeNode = (AttributeNode)childNode).isId()) continue;
                                    BasedSequence valueChars = attributeNode.getValue();
                                    String useKey = key = valueChars.toString();
                                    int pos = valueChars.indexOf(':');
                                    if (pos != -1) {
                                        String category = valueChars.subSequence(0, pos).toString();
                                        String id = ((BasedSequence)valueChars.subSequence(pos + 1)).toString();
                                        String uniqueCategory = category;
                                        uniqueCategory = categoryUniquificationMap.getOrDefault(category, category);
                                        useKey = String.format("%s:%s", uniqueCategory, id);
                                    }
                                    int i = 0;
                                    String newKey = useKey;
                                    while (mergedUniquified.contains(newKey)) {
                                        newKey = String.format("%s%d", useKey, ++i);
                                    }
                                    if (i <= 0 && newKey.equals(key)) continue;
                                    idMap.put(key, newKey);
                                }
                            }
                        }
                        final HtmlIdGenerator generator = context.getIdGenerator();
                        if (generator != null) {
                            new AnchorRefTargetBlockVisitor(){

                                protected void visit(AnchorRefTarget refTarget) {
                                    Node node = (Node)refTarget;
                                    if (AttributesNodeFormatter.this.hasNoIdAttribute(node)) {
                                        String key = generator.getId(node);
                                        if (key == null) {
                                            String text = refTarget.getAnchorRefText();
                                            key = generator.getId((CharSequence)text);
                                            refTarget.setAnchorRefId(key);
                                        }
                                        if (key != null) {
                                            int i = 0;
                                            String newKey = key;
                                            while (mergedUniquified.contains(newKey)) {
                                                newKey = String.format("%s%d", key, ++i);
                                            }
                                            if (i > 0 || !newKey.equals(key)) {
                                                idMap.put(key, newKey);
                                            }
                                        }
                                    }
                                }
                            }.visit((Node)document);
                        }
                        if (!idMap.isEmpty()) {
                            context.getTranslationStore().set(ATTRIBUTE_UNIQUIFICATION_ID_MAP, idMap);
                        }
                    }
                }
            }
        }
        this.attributeUniquificationIdMap = (Map)ATTRIBUTE_UNIQUIFICATION_ID_MAP.get((DataHolder)context.getTranslationStore());
        this.attributeTranslationMap = (Map)ATTRIBUTE_TRANSLATION_MAP.get((DataHolder)context.getTranslationStore());
        this.attributeTranslatedMap = (Map)ATTRIBUTE_TRANSLATED_MAP.get((DataHolder)context.getTranslationStore());
        this.attributeOriginalIdMap = (Map)ATTRIBUTE_ORIGINAL_ID_MAP.get((DataHolder)context.getTranslationStore());
    }

    @Nullable
    public Set<NodeFormattingHandler<?>> getNodeFormattingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeFormattingHandler(AttributesNode.class, this::render));
        set.add(new NodeFormattingHandler(AttributesDelimiter.class, this::render));
        return set;
    }

    public static String getEncodedIdAttribute(String category, String categoryId, NodeFormatterContext context, MarkdownWriter markdown) {
        Map idUniquificationMap;
        Map attributeTranslationMap = (Map)ATTRIBUTE_TRANSLATION_MAP.get((DataHolder)context.getTranslationStore());
        Map attributeTranslatedMap = (Map)ATTRIBUTE_TRANSLATED_MAP.get((DataHolder)context.getTranslationStore());
        String id = AttributesNodeFormatter.getEncodedIdAttribute(category, categoryId, context, markdown, attributeTranslationMap, attributeTranslatedMap);
        if (context.getRenderPurpose() == RenderPurpose.TRANSLATED && !(idUniquificationMap = (Map)ATTRIBUTE_UNIQUIFICATION_ID_MAP.get((DataHolder)context.getTranslationStore())).isEmpty()) {
            return idUniquificationMap.getOrDefault(id, id);
        }
        return id;
    }

    private static String getEncodedIdAttribute(String category, String categoryId, NodeFormatterContext context, MarkdownWriter markdown, Map<String, String> attributeTranslationMap, Map<String, String> attributeTranslatedMap) {
        String encodedCategory = category;
        String encodedId = categoryId;
        int placeholderId = (Integer)ATTRIBUTE_TRANSLATION_ID.get((DataHolder)context.getTranslationStore());
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: {
                if (!attributeTranslationMap.containsKey(category)) {
                    encodedCategory = String.format(context.getFormatterOptions().translationIdFormat, ++placeholderId);
                    attributeTranslationMap.put(category, encodedCategory);
                    attributeTranslatedMap.put(encodedCategory, category);
                } else {
                    encodedCategory = attributeTranslationMap.get(category);
                }
                if (categoryId != null && !attributeTranslationMap.containsKey(categoryId)) {
                    encodedId = String.format(context.getFormatterOptions().translationIdFormat, ++placeholderId);
                    attributeTranslationMap.put(categoryId, encodedId);
                    attributeTranslatedMap.put(encodedId, categoryId);
                    break;
                }
                encodedId = attributeTranslationMap.get(categoryId);
                break;
            }
            case TRANSLATED_SPANS: {
                break;
            }
            case TRANSLATED: {
                encodedCategory = attributeTranslatedMap.get(category);
                if (categoryId == null) break;
                encodedId = attributeTranslatedMap.get(categoryId);
                break;
            }
        }
        context.getTranslationStore().set(ATTRIBUTE_TRANSLATION_ID, (Object)placeholderId);
        if (encodedId == null) {
            return encodedCategory;
        }
        return encodedCategory + ":" + encodedId;
    }

    private String getEncodedOriginalId(String attribute, NodeFormatterContext context) {
        switch (context.getRenderPurpose()) {
            case TRANSLATION_SPANS: {
                String encodedAttribute = "#" + String.format(context.getFormatterOptions().translationIdFormat, ++this.attributeOriginalId);
                this.attributeOriginalIdMap.put(encodedAttribute, attribute);
                return encodedAttribute;
            }
            case TRANSLATED_SPANS: {
                return "#" + String.format(context.getFormatterOptions().translationIdFormat, ++this.attributeOriginalId);
            }
            case TRANSLATED: {
                ++this.attributeOriginalId;
                String id = this.attributeOriginalIdMap.get(attribute);
                if (this.attributeUniquificationIdMap != null) {
                    return this.attributeUniquificationIdMap.getOrDefault(id, id);
                }
                return id;
            }
        }
        return attribute;
    }

    void render(AttributesNode node, NodeFormatterContext context, MarkdownWriter markdown) {
        block54: {
            Collection childNodes;
            block53: {
                Node previous = node.getPrevious();
                if (!(previous == null || previous.getChars().isContinuedBy(node.getChars()) || previous.getChars().endsWith((CharSequence)" ") || node.getChars().startsWith((CharSequence)" "))) {
                    markdown.append(' ');
                }
                if (!context.isTransformingText()) break block53;
                markdown.append((CharSequence)node.getOpeningMarker());
                boolean firstChild = true;
                for (Node child : node.getChildren()) {
                    AttributeNode attributeNode = (AttributeNode)child;
                    if (!firstChild) {
                        markdown.append(' ');
                    }
                    if (attributeNode.isId()) {
                        BasedSequence valueChars = attributeNode.getValue();
                        int pos = valueChars.indexOf(':');
                        if (pos == -1) {
                            Object encodedOriginal = this.getEncodedOriginalId(attributeNode.getChars().toString(), context);
                            if (context.getRenderPurpose() == RenderPurpose.TRANSLATED && !this.attributeUniquificationIdMap.isEmpty()) {
                                String idOnly = ((String)encodedOriginal).substring(1);
                                encodedOriginal = "#" + this.attributeUniquificationIdMap.getOrDefault(idOnly, idOnly);
                            }
                            markdown.append((CharSequence)encodedOriginal);
                        } else {
                            String category = valueChars.subSequence(0, pos).toString();
                            String id = ((BasedSequence)valueChars.subSequence(pos + 1)).toString();
                            String encoded = AttributesNodeFormatter.getEncodedIdAttribute(category, id, context, markdown, this.attributeTranslationMap, this.attributeTranslatedMap);
                            switch (context.getRenderPurpose()) {
                                case TRANSLATION_SPANS: 
                                case TRANSLATED_SPANS: {
                                    String encodedAttribute = "#" + encoded;
                                    this.attributeOriginalIdMap.put(encodedAttribute, attributeNode.getChars().toString());
                                    ((MarkdownWriter)markdown.append('#')).append((CharSequence)encoded);
                                    break;
                                }
                                case TRANSLATED: {
                                    Object encodedOriginal = this.attributeOriginalIdMap.get("#" + valueChars.toString());
                                    if (this.attributeUniquificationIdMap != null && !this.attributeUniquificationIdMap.isEmpty()) {
                                        String idOnly = ((String)encodedOriginal).substring(1);
                                        encodedOriginal = "#" + this.attributeUniquificationIdMap.getOrDefault(idOnly, idOnly);
                                    }
                                    markdown.append((CharSequence)(encodedOriginal == null ? attributeNode.getChars().toString() : encodedOriginal));
                                    break;
                                }
                                default: {
                                    markdown.append((CharSequence)attributeNode.getChars());
                                }
                            }
                        }
                    } else {
                        markdown.appendNonTranslating((CharSequence)".", (CharSequence)attributeNode.getChars());
                    }
                    firstChild = false;
                }
                markdown.append((CharSequence)node.getClosingMarker());
                break block54;
            }
            Set processedNodes = (Set)PROCESSED_ATTRIBUTES.get((DataHolder)context.getDocument());
            if (processedNodes.contains((Object)node)) {
                return;
            }
            BasedSequence chars = node.getChars();
            BasedSequence openMarker = node.getOpeningMarker();
            BasedSequence closeMarker = node.getClosingMarker();
            BasedSequence spaceAfterOpenMarker = chars.safeBaseCharAt(openMarker.getEndOffset()) == ' ' ? chars.baseSubSequence(openMarker.getEndOffset(), openMarker.getEndOffset() + 1) : BasedSequence.NULL;
            BasedSequence spaceBeforeCloseMarker = chars.safeBaseCharAt(closeMarker.getStartOffset() - 1) == ' ' ? chars.baseSubSequence(closeMarker.getStartOffset() - 1, closeMarker.getStartOffset()) : BasedSequence.NULL;
            switch (this.formatOptions.attributesSpaces) {
                case AS_IS: {
                    break;
                }
                case ADD: {
                    spaceAfterOpenMarker = BasedSequence.SPACE;
                    spaceBeforeCloseMarker = BasedSequence.SPACE;
                    break;
                }
                case REMOVE: {
                    spaceAfterOpenMarker = BasedSequence.NULL;
                    spaceBeforeCloseMarker = BasedSequence.NULL;
                }
            }
            markdown.append((CharSequence)node.getOpeningMarker());
            markdown.append((CharSequence)spaceAfterOpenMarker);
            AttributeValueQuotes valueQuotes = this.formatOptions.attributeValueQuotes;
            boolean firstChild = true;
            LinkedHashMap<String, AttributeNode> attributeNodes = new LinkedHashMap<String, AttributeNode>();
            if (this.formatOptions.attributesCombineConsecutive) {
                NodeAttributeRepository nodeAttributeRepository = (NodeAttributeRepository)AttributesExtension.NODE_ATTRIBUTES.get((DataHolder)context.getDocument());
                for (Map.Entry<Node, ArrayList<AttributesNode>> entry : nodeAttributeRepository.entrySet()) {
                    if (!entry.getValue().contains((Object)node)) continue;
                    for (AttributesNode attributesNode : entry.getValue()) {
                        processedNodes.add(attributesNode);
                        for (Node child : attributesNode.getChildren()) {
                            AttributeNode attributeNode = (AttributeNode)child;
                            attributeNodes.put(attributeNode.getName().toString(), AttributesNodeFormatter.combineAttributes(attributeNodes, attributeNode));
                        }
                    }
                }
            }
            if (attributeNodes.isEmpty()) {
                for (Node child : node.getChildren()) {
                    AttributeNode attributeNode = (AttributeNode)child;
                    attributeNodes.put(attributeNode.getName().toString(), AttributesNodeFormatter.combineAttributes(attributeNodes, attributeNode));
                }
            }
            if (this.formatOptions.attributesSort) {
                ArrayList entries = new ArrayList(attributeNodes.entrySet());
                entries.sort((o1, o2) -> {
                    if (((AttributeNode)((Object)((Object)((Object)o1.getValue())))).isId()) {
                        return -1;
                    }
                    if (((AttributeNode)((Object)((Object)((Object)o2.getValue())))).isId()) {
                        return 1;
                    }
                    if (((AttributeNode)((Object)((Object)((Object)o1.getValue())))).isClass()) {
                        return -1;
                    }
                    if (((AttributeNode)((Object)((Object)((Object)o2.getValue())))).isClass()) {
                        return 1;
                    }
                    return ((AttributeNode)((Object)((Object)((Object)o1.getValue())))).getName().compareTo((Object)((AttributeNode)((Object)((Object)((Object)o2.getValue())))).getName());
                });
                ArrayList nodes = new ArrayList(entries.size());
                for (Map.Entry entry : entries) {
                    nodes.add((AttributeNode)((Object)entry.getValue()));
                }
                childNodes = nodes;
            } else {
                childNodes = attributeNodes.values();
            }
            for (Node child : childNodes) {
                String quote;
                BasedSequence spaceAfterSep;
                BasedSequence spaceBeforeSep;
                BasedSequence sep;
                BasedSequence value;
                BasedSequence name;
                block56: {
                    String needQuote;
                    AttributeNode attributeNode;
                    block55: {
                        attributeNode = (AttributeNode)child;
                        if (!firstChild) {
                            markdown.append(' ');
                        }
                        BasedSequence basedSequence = attributeNode.getChars();
                        name = attributeNode.getName();
                        value = attributeNode.getValue();
                        sep = attributeNode.getAttributeSeparator();
                        spaceBeforeSep = basedSequence.safeBaseCharAt(sep.getStartOffset() - 1) == ' ' ? basedSequence.baseSubSequence(sep.getStartOffset() - 1, sep.getStartOffset()) : BasedSequence.NULL;
                        spaceAfterSep = basedSequence.safeBaseCharAt(sep.getEndOffset()) == ' ' ? basedSequence.baseSubSequence(sep.getEndOffset(), sep.getEndOffset() + 1) : BasedSequence.NULL;
                        switch (this.formatOptions.attributeEqualSpace) {
                            case AS_IS: {
                                break;
                            }
                            case ADD: {
                                spaceBeforeSep = BasedSequence.SPACE;
                                spaceAfterSep = BasedSequence.SPACE;
                                break;
                            }
                            case REMOVE: {
                                spaceBeforeSep = BasedSequence.NULL;
                                spaceAfterSep = BasedSequence.NULL;
                            }
                        }
                        quote = attributeNode.isImplicitName() ? "" : valueQuotes.quotesFor((CharSequence)value, (CharSequence)attributeNode.getOpeningMarker());
                        needQuote = AttributeValueQuotes.NO_QUOTES_DOUBLE_PREFERRED.quotesFor((CharSequence)value, "");
                        if (!attributeNode.isId()) break block55;
                        switch (needQuote.isEmpty() ? this.formatOptions.attributeIdFormat : AttributeImplicitName.EXPLICIT_PREFERRED) {
                            case AS_IS: {
                                break block56;
                            }
                            case IMPLICIT_PREFERRED: {
                                if (!attributeNode.isImplicitName()) {
                                    name = PrefixedSubSequence.prefixOf((CharSequence)"#", (BasedSequence)name.getEmptyPrefix());
                                    sep = BasedSequence.NULL;
                                    quote = "";
                                }
                                break block56;
                            }
                            case EXPLICIT_PREFERRED: {
                                if (attributeNode.isImplicitName()) {
                                    name = PrefixedSubSequence.prefixOf((CharSequence)"id", (BasedSequence)name.getEmptyPrefix());
                                    sep = PrefixedSubSequence.prefixOf((CharSequence)"=", (BasedSequence)name.getEmptySuffix());
                                    if (quote.isEmpty() && (quote = valueQuotes.quotesFor((CharSequence)value, (CharSequence)attributeNode.getOpeningMarker())).isEmpty()) {
                                        quote = needQuote;
                                    }
                                }
                                break block56;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected value: " + this.formatOptions.attributeIdFormat);
                            }
                        }
                    }
                    if (attributeNode.isClass()) {
                        switch (needQuote.isEmpty() ? this.formatOptions.attributeClassFormat : AttributeImplicitName.EXPLICIT_PREFERRED) {
                            case AS_IS: {
                                break;
                            }
                            case IMPLICIT_PREFERRED: {
                                if (attributeNode.isImplicitName()) break;
                                name = PrefixedSubSequence.prefixOf((CharSequence)".", (BasedSequence)name.getEmptyPrefix());
                                sep = BasedSequence.NULL;
                                quote = "";
                                break;
                            }
                            case EXPLICIT_PREFERRED: {
                                if (!attributeNode.isImplicitName()) break;
                                name = PrefixedSubSequence.prefixOf((CharSequence)"class", (BasedSequence)name.getEmptyPrefix());
                                sep = PrefixedSubSequence.prefixOf((CharSequence)"=", (BasedSequence)name.getEmptySuffix());
                                if (!quote.isEmpty() || !(quote = valueQuotes.quotesFor((CharSequence)value, (CharSequence)attributeNode.getOpeningMarker())).isEmpty()) break;
                                quote = needQuote;
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected value: " + this.formatOptions.attributeIdFormat);
                            }
                        }
                    }
                }
                markdown.append((CharSequence)name);
                if (!sep.isEmpty()) {
                    ((MarkdownWriter)((MarkdownWriter)markdown.append((CharSequence)spaceBeforeSep)).append((CharSequence)sep)).append((CharSequence)spaceAfterSep);
                }
                if (!quote.isEmpty()) {
                    String replaceQuote = quote.equals("'") ? "&apos;" : (quote.equals("\"") ? "&quot;" : "");
                    markdown.append((CharSequence)quote);
                    markdown.append((CharSequence)value.replace((CharSequence)quote, (CharSequence)replaceQuote));
                    markdown.append((CharSequence)quote);
                } else {
                    markdown.append((CharSequence)value);
                }
                firstChild = false;
            }
            markdown.append((CharSequence)spaceBeforeCloseMarker);
            markdown.append((CharSequence)node.getClosingMarker());
        }
        Node next = node.getNext();
        if (!(next == null || next instanceof AttributesNode || node.getChars().isContinuedBy(next.getChars()) || node.getChars().endsWith((CharSequence)" ") || next.getChars().startsWith((CharSequence)" "))) {
            markdown.append(' ');
        }
    }

    static AttributeNode combineAttributes(LinkedHashMap<String, AttributeNode> attributeNodes, AttributeNode attributeNode) {
        if (attributeNode.isId()) {
            attributeNodes.remove("id");
            attributeNodes.remove("#");
            return attributeNode;
        }
        if (attributeNode.isClass()) {
            AttributeNode newNode = attributeNode;
            AttributeNode removed1 = (AttributeNode)((Object)attributeNodes.remove("class"));
            AttributeNode removed2 = (AttributeNode)((Object)attributeNodes.remove("."));
            if (removed1 != null || removed2 != null) {
                MutableAttributes attributes = new MutableAttributes();
                if (removed1 != null) {
                    attributes.addValue((CharSequence)"class", (CharSequence)removed1.getValue());
                }
                if (removed2 != null) {
                    attributes.addValue((CharSequence)"class", (CharSequence)removed2.getValue());
                }
                String value = attributes.getValue((CharSequence)"class");
                if (!attributeNode.getValue().equals(value)) {
                    PrefixedSubSequence newValue = PrefixedSubSequence.prefixOf((CharSequence)(value + " "), (BasedSequence)attributeNode.getValue());
                    newNode = new AttributeNode(attributeNode.getName(), attributeNode.getAttributeSeparator(), attributeNode.getOpeningMarker(), (BasedSequence)newValue, attributeNode.getClosingMarker());
                }
            }
            return newNode;
        }
        if (attributeNode.getName().equals("style")) {
            AttributeNode newNode = attributeNode;
            AttributeNode removed1 = (AttributeNode)((Object)attributeNodes.remove("style"));
            if (removed1 != null) {
                MutableAttributes attributes = new MutableAttributes();
                attributes.addValue((CharSequence)"style", (CharSequence)removed1.getValue());
                String value = attributes.getValue((CharSequence)"style");
                if (!attributeNode.getValue().equals(value)) {
                    PrefixedSubSequence newValue = PrefixedSubSequence.prefixOf((CharSequence)(value + ";"), (BasedSequence)attributeNode.getValue());
                    newNode = new AttributeNode(attributeNode.getName(), attributeNode.getAttributeSeparator(), attributeNode.getOpeningMarker(), (BasedSequence)newValue, attributeNode.getClosingMarker());
                }
            }
            return newNode;
        }
        return attributeNode;
    }

    public static class Factory
    implements NodeFormatterFactory {
        @NotNull
        public NodeFormatter create(@NotNull DataHolder options) {
            return new AttributesNodeFormatter(options);
        }
    }
}

