/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.CompressedObject;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.xref.CompressedObjectReference;

public class ObjectStream
extends PDFStream {
    private static final PDFName OBJ_STM = new PDFName("ObjStm");
    private List<CompressedObject> objects = new ArrayList<CompressedObject>();
    private int firstObjectOffset;

    ObjectStream() {
        super(false);
    }

    ObjectStream(ObjectStream previous) {
        this();
        this.put("Extends", previous);
    }

    CompressedObjectReference addObject(CompressedObject obj) {
        if (obj == null) {
            throw new NullPointerException("obj must not be null");
        }
        CompressedObjectReference reference = new CompressedObjectReference(obj.getObjectNumber(), this.getObjectNumber(), this.objects.size());
        this.objects.add(obj);
        return reference;
    }

    @Override
    protected void outputRawStreamData(OutputStream out) throws IOException {
        int currentOffset = 0;
        StringBuilder offsetsPart = new StringBuilder();
        ByteArrayOutputStream streamContent = new ByteArrayOutputStream();
        for (CompressedObject object : this.objects) {
            offsetsPart.append(object.getObjectNumber()).append(' ').append(currentOffset).append('\n');
            currentOffset += object.output(streamContent);
        }
        byte[] offsets = PDFDocument.encode(offsetsPart.toString());
        this.firstObjectOffset = offsets.length;
        out.write(offsets);
        streamContent.writeTo(out);
    }

    @Override
    protected void populateStreamDict(Object lengthEntry) {
        this.put("Type", OBJ_STM);
        this.put("N", this.objects.size());
        this.put("First", this.firstObjectOffset);
        super.populateStreamDict(lengthEntry);
    }
}

