/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.format;

import com.vladsch.flexmark.util.format.TableCell;
import com.vladsch.flexmark.util.format.TableRow;
import com.vladsch.flexmark.util.format.TableSectionType;
import java.util.ArrayList;

public class TableSection {
    public final TableSectionType sectionType;
    public final ArrayList<TableRow> rows = new ArrayList();
    protected int row;
    protected int column;

    public TableSection(TableSectionType sectionType) {
        this.sectionType = sectionType;
        this.row = 0;
        this.column = 0;
    }

    public ArrayList<TableRow> getRows() {
        return this.rows;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public void nextRow() {
        ++this.row;
        this.column = 0;
    }

    public void setCell(int row, int column, TableCell cell) {
        this.expandTo(row).set(column, cell);
    }

    public void normalize() {
        for (TableRow row : this.rows) {
            row.normalize();
        }
    }

    public TableRow expandTo(int row) {
        return this.expandTo(row, null);
    }

    public TableRow expandTo(int row, TableCell cell) {
        while (row >= this.rows.size()) {
            TableRow tableRow = this.defaultRow();
            this.rows.add(tableRow);
        }
        return this.rows.get(row);
    }

    public TableRow expandTo(int row, int column) {
        return this.expandTo(row, column, null);
    }

    public TableRow expandTo(int row, int column, TableCell cell) {
        while (row >= this.rows.size()) {
            TableRow tableRow = this.defaultRow();
            tableRow.expandTo(column, cell);
            this.rows.add(tableRow);
        }
        return this.rows.get(row).expandTo(column);
    }

    public TableRow defaultRow() {
        return new TableRow();
    }

    public TableCell defaultCell() {
        return TableCell.NULL;
    }

    public TableRow get(int row) {
        return this.expandTo(row, null);
    }

    public int getMaxColumns() {
        int columns = 0;
        for (TableRow row : this.rows) {
            int spans = row.getSpannedColumns();
            if (columns >= spans) continue;
            columns = spans;
        }
        return columns;
    }

    public int getMinColumns() {
        int columns = 0;
        for (TableRow row : this.rows) {
            int spans = row.getSpannedColumns();
            if (columns <= spans && columns != 0) continue;
            columns = spans;
        }
        return columns;
    }

    private CharSequence dumpRows() {
        StringBuilder sb = new StringBuilder();
        for (TableRow row : this.rows) {
            sb.append("  ").append(row.toString()).append("\n");
        }
        return sb;
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1) + "[sectionType=" + this.sectionType + ", rows=[\n" + this.dumpRows() + "]";
    }
}

