/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.common.CommonDependenciesContainer;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.AbstractMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.CommonAnalysisKt;
import org.jetbrains.kotlin.cli.metadata.CommonAnalysisResult;
import org.jetbrains.kotlin.cli.metadata.K1LegacyMetadataSerializerKt;
import org.jetbrains.kotlin.cli.metadata.MetadataSerializerExtension;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsBinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.KotlinSerializerExtensionBase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\n\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/K1LegacyMetadataSerializer;", "Lorg/jetbrains/kotlin/cli/metadata/AbstractMetadataSerializer;", "Lorg/jetbrains/kotlin/cli/metadata/CommonAnalysisResult;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "dependOnOldBuiltIns", "", "definedMetadataVersion", "Lorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;ZLorg/jetbrains/kotlin/metadata/builtins/BuiltInsBinaryVersion;)V", "totalSize", "", "getTotalSize", "()I", "setTotalSize", "(I)V", "totalFiles", "getTotalFiles", "setTotalFiles", "analyze", "serialize", "Lorg/jetbrains/kotlin/cli/metadata/AbstractMetadataSerializer$OutputInfo;", "analysisResult", "destDir", "Ljava/io/File;", "createSerializerExtension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "PackageSerializer", "cli"})
@SourceDebugExtension(value={"SMAP\nK1LegacyMetadataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K1LegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/K1LegacyMetadataSerializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,194:1\n382#2,7:195\n*S KotlinDebug\n*F\n+ 1 K1LegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/K1LegacyMetadataSerializer\n*L\n102#1:195,7\n*E\n"})
public class K1LegacyMetadataSerializer
extends AbstractMetadataSerializer<CommonAnalysisResult> {
    private final boolean dependOnOldBuiltIns;
    private int totalSize;
    private int totalFiles;

    public K1LegacyMetadataSerializer(@NotNull CompilerConfiguration configuration2, @NotNull KotlinCoreEnvironment environment, boolean dependOnOldBuiltIns, @Nullable BuiltInsBinaryVersion definedMetadataVersion) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(configuration2, environment, definedMetadataVersion);
        this.dependOnOldBuiltIns = dependOnOldBuiltIns;
    }

    public /* synthetic */ K1LegacyMetadataSerializer(CompilerConfiguration compilerConfiguration, KotlinCoreEnvironment kotlinCoreEnvironment, boolean bl, BuiltInsBinaryVersion builtInsBinaryVersion, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            builtInsBinaryVersion = null;
        }
        this(compilerConfiguration, kotlinCoreEnvironment, bl, builtInsBinaryVersion);
    }

    protected final int getTotalSize() {
        return this.totalSize;
    }

    protected final void setTotalSize(int n2) {
        this.totalSize = n2;
    }

    protected final int getTotalFiles() {
        return this.totalFiles;
    }

    protected final void setTotalFiles(int n2) {
        this.totalFiles = n2;
    }

    @Override
    @Nullable
    protected CommonAnalysisResult analyze() {
        return CommonAnalysisKt.runCommonAnalysisForSerialization(this.getEnvironment(), this.dependOnOldBuiltIns, (Function0<? extends CommonDependenciesContainer>)((Function0)K1LegacyMetadataSerializer::analyze$lambda$0));
    }

    @Override
    @NotNull
    protected AbstractMetadataSerializer.OutputInfo serialize(@NotNull CommonAnalysisResult analysisResult, @NotNull File destDir) {
        JvmModuleProtoBuf.Module.Builder builder;
        Intrinsics.checkNotNullParameter((Object)analysisResult, (String)"analysisResult");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.getEnvironment().getConfiguration());
        List<KtFile> files2 = this.getEnvironment().getSourceFiles();
        Project project = this.getEnvironment().getProject();
        ModuleDescriptor module2 = analysisResult.component1();
        BindingContext bindingContext = analysisResult.component2();
        HashMap packageTable = new HashMap();
        for (KtFile file : files2) {
            Object object;
            FqName packageFqName = file.getPackageFqName();
            ArrayList<DeclarationDescriptor> members = new ArrayList<DeclarationDescriptor>();
            for (KtDeclaration declaration : file.getDeclarations()) {
                declaration.accept(new KtVisitorVoid(members, bindingContext, destDir, packageFqName, this, languageVersionSettings, project){
                    final /* synthetic */ ArrayList<DeclarationDescriptor> $members;
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ File $destDir;
                    final /* synthetic */ FqName $packageFqName;
                    final /* synthetic */ K1LegacyMetadataSerializer this$0;
                    final /* synthetic */ LanguageVersionSettings $languageVersionSettings;
                    final /* synthetic */ Project $project;
                    {
                        this.$members = $members;
                        this.$bindingContext = $bindingContext;
                        this.$destDir = $destDir;
                        this.$packageFqName = $packageFqName;
                        this.this$0 = $receiver;
                        this.$languageVersionSettings = $languageVersionSettings;
                        this.$project = $project;
                    }

                    public void visitNamedFunction(KtNamedFunction function2) {
                        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)this.$bindingContext.get(BindingContext.FUNCTION, function2);
                        if (simpleFunctionDescriptor == null) {
                            throw new IllegalStateException(("No descriptor found for function " + function2.getFqName()).toString());
                        }
                        this.$members.add(simpleFunctionDescriptor);
                    }

                    public void visitProperty(KtProperty property2) {
                        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                        VariableDescriptor variableDescriptor = (VariableDescriptor)this.$bindingContext.get(BindingContext.VARIABLE, property2);
                        if (variableDescriptor == null) {
                            throw new IllegalStateException(("No descriptor found for property " + property2.getFqName()).toString());
                        }
                        this.$members.add(variableDescriptor);
                    }

                    public void visitTypeAlias(KtTypeAlias typeAlias) {
                        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
                        TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)this.$bindingContext.get(BindingContext.TYPE_ALIAS, typeAlias);
                        if (typeAliasDescriptor == null) {
                            throw new IllegalStateException(("No descriptor found for type alias " + typeAlias.getFqName()).toString());
                        }
                        this.$members.add(typeAliasDescriptor);
                    }

                    public void visitClassOrObject(KtClassOrObject classOrObject) {
                        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
                        ClassDescriptor classDescriptor = (ClassDescriptor)this.$bindingContext.get(BindingContext.CLASS, classOrObject);
                        if (classDescriptor == null) {
                            throw new IllegalStateException(("No descriptor found for class " + classOrObject.getFqName()).toString());
                        }
                        ClassDescriptor classDescriptor2 = classDescriptor;
                        Name name2 = classDescriptor2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                        File destFile = new File(this.$destDir, K1LegacyMetadataSerializerKt.getClassFilePath(new ClassId(this.$packageFqName, name2)));
                        new PackageSerializer(this.this$0, CollectionsKt.listOf((Object)classDescriptor2), CollectionsKt.emptyList(), this.$packageFqName, destFile, this.$languageVersionSettings, this.$project).run();
                    }
                });
            }
            if (!(!((Collection)members).isEmpty())) continue;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            File destFile = new File(destDir, K1LegacyMetadataSerializerKt.getPackageFilePath(packageFqName, string));
            new PackageSerializer(this, CollectionsKt.emptyList(), (Collection<? extends DeclarationDescriptor>)members, packageFqName, destFile, languageVersionSettings, project).run();
            Map $this$getOrPut$iv = packageTable;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(packageFqName);
            if (value$iv == null) {
                boolean bl = false;
                PackageParts answer$iv = new PackageParts(packageFqName.asString());
                $this$getOrPut$iv.put(packageFqName, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((PackageParts)object).addMetadataPart(FilesKt.getNameWithoutExtension((File)destFile));
        }
        File kotlinModuleFile = new File(destDir, JvmCodegenUtil.getMappingFileName(JvmCodegenUtil.getModuleName(module2)));
        JvmModuleProtoBuf.Module.Builder $this$serialize_u24lambda_u242 = builder = JvmModuleProtoBuf.Module.newBuilder();
        boolean bl = false;
        for (Object v2 : packageTable.values()) {
            Intrinsics.checkNotNullExpressionValue(v2, (String)"next(...)");
            PackageParts table = (PackageParts)v2;
            Intrinsics.checkNotNull((Object)$this$serialize_u24lambda_u242);
            table.addTo($this$serialize_u24lambda_u242);
        }
        JvmModuleProtoBuf.Module module3 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"build(...)");
        byte[] packageTableBytes = ModuleMappingKt.serializeToByteArray(module3, MetadataVersion.INSTANCE, 0);
        kotlinModuleFile.getParentFile().mkdirs();
        FilesKt.writeBytes((File)kotlinModuleFile, (byte[])packageTableBytes);
        return new AbstractMetadataSerializer.OutputInfo(this.totalSize, this.totalFiles);
    }

    @NotNull
    protected KotlinSerializerExtensionBase createSerializerExtension() {
        return new MetadataSerializerExtension(this.getMetadataVersion());
    }

    private static final CommonDependenciesContainer analyze$lambda$0() {
        return null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u0017\u001a\u00020\u00162\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001e\u0010\u001a\u001a\u00020\u00162\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/K1LegacyMetadataSerializer$PackageSerializer;", "", "classes", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "members", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "destFile", "Ljava/io/File;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/cli/metadata/K1LegacyMetadataSerializer;Ljava/util/Collection;Ljava/util/Collection;Lorg/jetbrains/kotlin/name/FqName;Ljava/io/File;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/openapi/project/Project;)V", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment$Builder;", "kotlin.jvm.PlatformType", "extension", "Lorg/jetbrains/kotlin/serialization/KotlinSerializerExtensionBase;", "run", "", "serializeClasses", "parentSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "serializeMembers", "serializer", "serializeStringTable", "serializeBuiltInsFile", "write", "stream", "Ljava/io/ByteArrayOutputStream;", "cli"})
    @SourceDebugExtension(value={"SMAP\nK1LegacyMetadataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K1LegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/K1LegacyMetadataSerializer$PackageSerializer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n13493#2,2:195\n1#3:197\n*S KotlinDebug\n*F\n+ 1 K1LegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/K1LegacyMetadataSerializer$PackageSerializer\n*L\n172#1:195,2\n*E\n"})
    protected final class PackageSerializer {
        @NotNull
        private final Collection<DeclarationDescriptor> classes;
        @NotNull
        private final Collection<DeclarationDescriptor> members;
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final File destFile;
        @NotNull
        private final LanguageVersionSettings languageVersionSettings;
        @Nullable
        private final Project project;
        private final ProtoBuf.PackageFragment.Builder proto;
        @NotNull
        private final KotlinSerializerExtensionBase extension;
        final /* synthetic */ K1LegacyMetadataSerializer this$0;

        public PackageSerializer(@NotNull K1LegacyMetadataSerializer this$0, @NotNull Collection<? extends DeclarationDescriptor> classes, @NotNull Collection<? extends DeclarationDescriptor> members, @NotNull FqName packageFqName, @NotNull File destFile, @Nullable LanguageVersionSettings languageVersionSettings, Project project) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter(members, (String)"members");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            this.this$0 = this$0;
            this.classes = classes;
            this.members = members;
            this.packageFqName = packageFqName;
            this.destFile = destFile;
            this.languageVersionSettings = languageVersionSettings;
            this.project = project;
            this.proto = ProtoBuf.PackageFragment.newBuilder();
            this.extension = this.this$0.createSerializerExtension();
        }

        public /* synthetic */ PackageSerializer(K1LegacyMetadataSerializer k1LegacyMetadataSerializer, Collection collection, Collection collection2, FqName fqName, File file, LanguageVersionSettings languageVersionSettings, Project project, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x20) != 0) {
                project = null;
            }
            this(k1LegacyMetadataSerializer, collection, collection2, fqName, file, languageVersionSettings, project);
        }

        public final void run() {
            DescriptorSerializer serializer = DescriptorSerializer.Companion.createTopLevel(this.extension, this.languageVersionSettings, this.project);
            this.serializeClasses(this.classes, serializer, this.project);
            this.serializeMembers(this.members, serializer);
            this.serializeStringTable();
            this.serializeBuiltInsFile();
        }

        private final void serializeClasses(Collection<? extends DeclarationDescriptor> classes, DescriptorSerializer parentSerializer, Project project) {
            for (DeclarationDescriptor declarationDescriptor : DescriptorSerializer.Companion.sort(classes)) {
                if (!(declarationDescriptor instanceof ClassDescriptor) || ((ClassDescriptor)declarationDescriptor).getKind() == ClassKind.ENUM_ENTRY) continue;
                DescriptorSerializer serializer = DescriptorSerializer.Companion.create((ClassDescriptor)declarationDescriptor, this.extension, parentSerializer, this.languageVersionSettings, project);
                this.serializeClasses(ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)declarationDescriptor).getUnsubstitutedInnerClassesScope(), DescriptorKindFilter.CLASSIFIERS, null, 2, null), serializer, project);
                this.proto.addClass_(serializer.classProto((ClassDescriptor)declarationDescriptor).build());
            }
        }

        private final void serializeMembers(Collection<? extends DeclarationDescriptor> members, DescriptorSerializer serializer) {
            this.proto.setPackage(serializer.packagePartProto(this.packageFqName, members).build());
        }

        private final void serializeStringTable() {
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = this.extension.getStringTable().buildProto();
            ProtoBuf.StringTable strings2 = (ProtoBuf.StringTable)pair.component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)pair.component2();
            this.proto.setStrings(strings2);
            this.proto.setQualifiedNames(qualifiedNames);
        }

        private final void serializeBuiltInsFile() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream $this$serializeBuiltInsFile_u24lambda_u241 = new DataOutputStream(stream);
            boolean bl = false;
            int[] version2 = this.extension.getMetadataVersion().toArray();
            $this$serializeBuiltInsFile_u24lambda_u241.writeInt(version2.length);
            int[] $this$forEach$iv = version2;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int element$iv;
                int it = element$iv = $this$forEach$iv[i2];
                boolean bl2 = false;
                $this$serializeBuiltInsFile_u24lambda_u241.writeInt(it);
            }
            this.proto.build().writeTo(stream);
            this.write(stream);
        }

        private final void write(ByteArrayOutputStream stream) {
            this.this$0.setTotalSize(this.this$0.getTotalSize() + stream.size());
            int n2 = this.this$0.getTotalFiles();
            this.this$0.setTotalFiles(n2 + 1);
            int n3 = n2 = !this.destFile.isDirectory() ? 1 : 0;
            if (_Assertions.ENABLED && n2 == 0) {
                boolean bl = false;
                String string = "Cannot write because output destination is a directory: " + this.destFile;
                throw new AssertionError((Object)string);
            }
            this.destFile.getParentFile().mkdirs();
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            FilesKt.writeBytes((File)this.destFile, (byte[])byArray);
        }
    }
}

