/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.evaluator.checks;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.declarative.dsl.evaluation.InterpretationStepFeature;
import org.gradle.declarative.dsl.schema.SchemaFunction;
import org.gradle.declarative.dsl.schema.SchemaMemberFunction;
import org.gradle.internal.declarativedsl.analysis.AssignmentRecord;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.ResolutionTrace;
import org.gradle.internal.declarativedsl.dom.DeclarativeDocument;
import org.gradle.internal.declarativedsl.dom.data.NodeDataContainer;
import org.gradle.internal.declarativedsl.dom.fromLanguageTree.LanguageTreeMappingContainer;
import org.gradle.internal.declarativedsl.dom.resolution.DocumentWithResolution;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentCheck;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentCheckFailure;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentCheckFailureLocation;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentCheckFailureReason;
import org.gradle.internal.declarativedsl.evaluator.checks.DocumentLowLevelResolutionCheck;
import org.gradle.internal.declarativedsl.language.AssignmentLikeStatement;
import org.gradle.internal.declarativedsl.language.Expr;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J@\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112(\u0010\u0012\u001a$\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck;", "Lorg/gradle/internal/declarativedsl/evaluator/checks/DocumentCheck;", "Lorg/gradle/internal/declarativedsl/evaluator/checks/DocumentLowLevelResolutionCheck;", "<init>", "()V", "feature", "Lorg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck$AccessOnCurrentReceiverCheckFeature;", "getFeature", "()Lorg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck$AccessOnCurrentReceiverCheckFeature;", "checkKey", "", "getCheckKey", "()Ljava/lang/String;", "detectFailures", "", "Lorg/gradle/internal/declarativedsl/evaluator/checks/DocumentCheckFailure;", "documentWithResolution", "Lorg/gradle/internal/declarativedsl/dom/resolution/DocumentWithResolution;", "isAnalyzedNode", "Lorg/gradle/internal/declarativedsl/dom/data/NodeDataContainer;", "", "Lorg/gradle/internal/declarativedsl/dom/data/NodeData;", "detectFailuresInLowLevelResolution", "document", "Lorg/gradle/internal/declarativedsl/dom/DeclarativeDocument;", "languageTreeMappingContainer", "Lorg/gradle/internal/declarativedsl/dom/fromLanguageTree/LanguageTreeMappingContainer;", "resolutionTrace", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionTrace;", "AccessOnCurrentReceiverCheckFeature", "CheckContext", "declarative-dsl-evaluator"})
@SourceDebugExtension(value={"SMAP\nAccessOnCurrentReceiverCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessOnCurrentReceiverCheck.kt\norg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1869#2,2:133\n*S KotlinDebug\n*F\n+ 1 AccessOnCurrentReceiverCheck.kt\norg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck\n*L\n50#1:133,2\n*E\n"})
public final class AccessOnCurrentReceiverCheck
implements DocumentCheck,
DocumentLowLevelResolutionCheck {
    @NotNull
    public static final AccessOnCurrentReceiverCheck INSTANCE = new AccessOnCurrentReceiverCheck();
    @NotNull
    private static final AccessOnCurrentReceiverCheckFeature feature = new AccessOnCurrentReceiverCheckFeature();

    private AccessOnCurrentReceiverCheck() {
    }

    @NotNull
    public final AccessOnCurrentReceiverCheckFeature getFeature() {
        return feature;
    }

    @Override
    @NotNull
    public String getCheckKey() {
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    public List<DocumentCheckFailure> detectFailures(@NotNull DocumentWithResolution documentWithResolution, @NotNull NodeDataContainer<Boolean, Boolean, Boolean, Boolean> isAnalyzedNode) {
        Intrinsics.checkNotNullParameter((Object)documentWithResolution, (String)"documentWithResolution");
        Intrinsics.checkNotNullParameter(isAnalyzedNode, (String)"isAnalyzedNode");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<DocumentCheckFailure> detectFailuresInLowLevelResolution(@NotNull DeclarativeDocument document, @NotNull LanguageTreeMappingContainer languageTreeMappingContainer, @NotNull ResolutionTrace resolutionTrace) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)languageTreeMappingContainer, (String)"languageTreeMappingContainer");
        Intrinsics.checkNotNullParameter((Object)resolutionTrace, (String)"resolutionTrace");
        CheckContext $this$detectFailuresInLowLevelResolution_u24lambda_u240 = new CheckContext(resolutionTrace, languageTreeMappingContainer);
        boolean bl = false;
        Iterable $this$forEach$iv = document.getContent();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarativeDocument.Node p0 = (DeclarativeDocument.Node)element$iv;
            boolean bl2 = false;
            $this$detectFailuresInLowLevelResolution_u24lambda_u240.visitNode(p0);
        }
        return $this$detectFailuresInLowLevelResolution_u24lambda_u240.getFailures();
    }

    @Override
    public boolean shouldHandleFeature(@NotNull InterpretationStepFeature.DocumentChecks feature) {
        return DocumentCheck.super.shouldHandleFeature(feature);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck$AccessOnCurrentReceiverCheckFeature;", "Lorg/gradle/declarative/dsl/evaluation/InterpretationStepFeature$DocumentChecks;", "<init>", "()V", "checkKeys", "", "", "getCheckKeys", "()Ljava/lang/Iterable;", "declarative-dsl-evaluator"})
    public static final class AccessOnCurrentReceiverCheckFeature
    implements InterpretationStepFeature.DocumentChecks {
        @NotNull
        public Iterable<String> getCheckKeys() {
            return CollectionsKt.listOf((Object)INSTANCE.getCheckKey());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\u000e\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck$CheckContext;", "", "resolutionTrace", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionTrace;", "languageTreeMappingContainer", "Lorg/gradle/internal/declarativedsl/dom/fromLanguageTree/LanguageTreeMappingContainer;", "<init>", "(Lorg/gradle/internal/declarativedsl/analysis/ResolutionTrace;Lorg/gradle/internal/declarativedsl/dom/fromLanguageTree/LanguageTreeMappingContainer;)V", "getResolutionTrace", "()Lorg/gradle/internal/declarativedsl/analysis/ResolutionTrace;", "getLanguageTreeMappingContainer", "()Lorg/gradle/internal/declarativedsl/dom/fromLanguageTree/LanguageTreeMappingContainer;", "failures", "", "Lorg/gradle/internal/declarativedsl/evaluator/checks/DocumentCheckFailure;", "getFailures", "()Ljava/util/List;", "visitNode", "", "node", "Lorg/gradle/internal/declarativedsl/dom/DeclarativeDocument$Node;", "isUsageOfDirectOnlyAccessMember", "", "objectOrigin", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin$HasReceiver;", "isViolatingOrigin", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "isViolatingAssignmentLhs", "assignmentRecord", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentRecord;", "valueOrigin", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionTrace$ResolutionOrErrors;", "valueNode", "Lorg/gradle/internal/declarativedsl/dom/DeclarativeDocument$ValueNode;", "propertyNode", "Lorg/gradle/internal/declarativedsl/dom/DeclarativeDocument$DocumentNode$PropertyNode;", "report", "declarative-dsl-evaluator"})
    @SourceDebugExtension(value={"SMAP\nAccessOnCurrentReceiverCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessOnCurrentReceiverCheck.kt\norg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck$CheckContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1869#2,2:133\n1869#2,2:135\n1869#2,2:137\n1#3:139\n*S KotlinDebug\n*F\n+ 1 AccessOnCurrentReceiverCheck.kt\norg/gradle/internal/declarativedsl/evaluator/checks/AccessOnCurrentReceiverCheck$CheckContext\n*L\n83#1:133,2\n91#1:135,2\n92#1:137,2\n*E\n"})
    private static final class CheckContext {
        @NotNull
        private final ResolutionTrace resolutionTrace;
        @NotNull
        private final LanguageTreeMappingContainer languageTreeMappingContainer;
        @NotNull
        private final List<DocumentCheckFailure> failures;

        public CheckContext(@NotNull ResolutionTrace resolutionTrace, @NotNull LanguageTreeMappingContainer languageTreeMappingContainer) {
            Intrinsics.checkNotNullParameter((Object)resolutionTrace, (String)"resolutionTrace");
            Intrinsics.checkNotNullParameter((Object)languageTreeMappingContainer, (String)"languageTreeMappingContainer");
            this.resolutionTrace = resolutionTrace;
            this.languageTreeMappingContainer = languageTreeMappingContainer;
            this.failures = new ArrayList();
        }

        @NotNull
        public final ResolutionTrace getResolutionTrace() {
            return this.resolutionTrace;
        }

        @NotNull
        public final LanguageTreeMappingContainer getLanguageTreeMappingContainer() {
            return this.languageTreeMappingContainer;
        }

        @NotNull
        public final List<DocumentCheckFailure> getFailures() {
            return this.failures;
        }

        public final void visitNode(@NotNull DeclarativeDocument.Node node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DeclarativeDocument.Node node2 = node;
            if (node2 instanceof DeclarativeDocument.DocumentNode.PropertyNode) {
                ResolutionTrace.ResolutionOrErrors<AssignmentRecord> record = this.assignmentRecord((DeclarativeDocument.DocumentNode.PropertyNode)node);
                if (record instanceof ResolutionTrace.ResolutionOrErrors.Resolution && this.isViolatingAssignmentLhs((AssignmentRecord)((ResolutionTrace.ResolutionOrErrors.Resolution)record).getResult())) {
                    this.report(node);
                }
                this.visitNode((DeclarativeDocument.Node)((DeclarativeDocument.DocumentNode.PropertyNode)node).getValue());
            } else if (node2 instanceof DeclarativeDocument.ValueNode.NamedReferenceNode) {
                ResolutionTrace.ResolutionOrErrors<ObjectOrigin> resolution = this.valueOrigin((DeclarativeDocument.ValueNode)node);
                if (resolution instanceof ResolutionTrace.ResolutionOrErrors.Resolution && this.isViolatingOrigin((ObjectOrigin)((ResolutionTrace.ResolutionOrErrors.Resolution)resolution).getResult())) {
                    this.report(node);
                }
            } else if (node2 instanceof DeclarativeDocument.ValueNode.ValueFactoryNode) {
                ResolutionTrace.ResolutionOrErrors<ObjectOrigin> resolution = this.valueOrigin((DeclarativeDocument.ValueNode)node);
                if (resolution instanceof ResolutionTrace.ResolutionOrErrors.Resolution && this.isViolatingOrigin((ObjectOrigin)((ResolutionTrace.ResolutionOrErrors.Resolution)resolution).getResult())) {
                    this.report(node);
                }
                Iterable $this$forEach$iv = ((DeclarativeDocument.ValueNode.ValueFactoryNode)node).getValues();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DeclarativeDocument.Node p0 = (DeclarativeDocument.Node)element$iv;
                    boolean bl = false;
                    this.visitNode(p0);
                }
            } else if (node2 instanceof DeclarativeDocument.DocumentNode.ElementNode) {
                DeclarativeDocument.Node p0;
                ResolutionTrace.ResolutionOrErrors resolution = this.resolutionTrace.expressionResolution((Expr)this.languageTreeMappingContainer.data((DeclarativeDocument.DocumentNode.ElementNode)node));
                if (resolution instanceof ResolutionTrace.ResolutionOrErrors.Resolution && this.isViolatingOrigin((ObjectOrigin)((ResolutionTrace.ResolutionOrErrors.Resolution)resolution).getResult())) {
                    this.report(node);
                }
                Iterable $this$forEach$iv = ((DeclarativeDocument.DocumentNode.ElementNode)node).getElementValues();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    p0 = (DeclarativeDocument.Node)element$iv;
                    boolean bl = false;
                    this.visitNode(p0);
                }
                $this$forEach$iv = ((DeclarativeDocument.DocumentNode.ElementNode)node).getContent();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    p0 = (DeclarativeDocument.Node)element$iv;
                    boolean bl = false;
                    this.visitNode(p0);
                }
            } else if (!(node2 instanceof DeclarativeDocument.DocumentNode.ErrorNode) && !(node2 instanceof DeclarativeDocument.ValueNode.LiteralValueNode)) {
                throw new NoWhenBranchMatchedException();
            }
        }

        private final boolean isUsageOfDirectOnlyAccessMember(ObjectOrigin.HasReceiver objectOrigin) {
            boolean bl;
            ObjectOrigin.HasReceiver hasReceiver = objectOrigin;
            if (hasReceiver instanceof ObjectOrigin.BuilderReturnedReceiver) {
                SchemaFunction schemaFunction = ((ObjectOrigin.BuilderReturnedReceiver)objectOrigin).getFunction();
                SchemaMemberFunction schemaMemberFunction = schemaFunction instanceof SchemaMemberFunction ? (SchemaMemberFunction)schemaFunction : null;
                bl = schemaMemberFunction != null ? schemaMemberFunction.isDirectAccessOnly() : false;
            } else if (hasReceiver instanceof ObjectOrigin.NewObjectFromMemberFunction) {
                bl = ((ObjectOrigin.NewObjectFromMemberFunction)objectOrigin).getFunction().isDirectAccessOnly();
            } else if (hasReceiver instanceof ObjectOrigin.PropertyReference) {
                bl = ((ObjectOrigin.PropertyReference)objectOrigin).getProperty().isDirectAccessOnly();
            } else if (hasReceiver instanceof ObjectOrigin.CustomConfigureAccessor || hasReceiver instanceof ObjectOrigin.PropertyDefaultValue || hasReceiver instanceof ObjectOrigin.ConfiguringLambdaReceiver) {
                bl = false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        public final boolean isViolatingOrigin(@NotNull ObjectOrigin objectOrigin) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)objectOrigin, (String)"objectOrigin");
            if (objectOrigin instanceof ObjectOrigin.HasReceiver) {
                ObjectOrigin it = ((ObjectOrigin.HasReceiver)objectOrigin).getReceiver();
                boolean bl2 = false;
                boolean isNotCurrentReceiver = !(it instanceof ObjectOrigin.ImplicitThisReceiver) || !((ObjectOrigin.ImplicitThisReceiver)it).isCurrentScopeReceiver();
                bl = isNotCurrentReceiver && this.isUsageOfDirectOnlyAccessMember((ObjectOrigin.HasReceiver)objectOrigin);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isViolatingAssignmentLhs(@NotNull AssignmentRecord assignmentRecord) {
            Intrinsics.checkNotNullParameter((Object)assignmentRecord, (String)"assignmentRecord");
            if (!assignmentRecord.getLhs().getProperty().isDirectAccessOnly()) return false;
            ObjectOrigin lhsReceiver = assignmentRecord.getLhs().getReceiverObject();
            boolean bl = false;
            if (!(lhsReceiver instanceof ObjectOrigin.ImplicitThisReceiver)) return false;
            if (((ObjectOrigin.ImplicitThisReceiver)lhsReceiver).isCurrentScopeReceiver()) return false;
            return true;
        }

        private final ResolutionTrace.ResolutionOrErrors<ObjectOrigin> valueOrigin(DeclarativeDocument.ValueNode valueNode) {
            return this.resolutionTrace.expressionResolution((Expr)this.languageTreeMappingContainer.data(valueNode));
        }

        private final ResolutionTrace.ResolutionOrErrors<AssignmentRecord> assignmentRecord(DeclarativeDocument.DocumentNode.PropertyNode propertyNode) {
            return this.resolutionTrace.assignmentResolution((AssignmentLikeStatement)this.languageTreeMappingContainer.data(propertyNode));
        }

        public final void report(@NotNull DeclarativeDocument.Node node) {
            DocumentCheckFailureLocation documentCheckFailureLocation;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            DeclarativeDocument.Node node2 = node;
            if (node2 instanceof DeclarativeDocument.DocumentNode) {
                documentCheckFailureLocation = new DocumentCheckFailureLocation.FailedAtNode((DeclarativeDocument.DocumentNode)node);
            } else if (node2 instanceof DeclarativeDocument.ValueNode) {
                documentCheckFailureLocation = new DocumentCheckFailureLocation.FailedAtValue((DeclarativeDocument.ValueNode)node);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            DocumentCheckFailureLocation location = documentCheckFailureLocation;
            this.failures.add(new DocumentCheckFailure(INSTANCE, location, DocumentCheckFailureReason.AccessOnCurrentReceiverViolation.INSTANCE));
        }
    }
}

