/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.BuiltInWithDifferentJvmName;
import org.jetbrains.kotlin.backend.common.lower.SpecialMethodWithDefaultInfo;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001.B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0010\u001a\u00020\t*\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J&\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001b\u0018\u00010(2\u0006\u0010)\u001a\u00020\u00112\b\b\u0002\u0010*\u001a\u00020+J\u0010\u0010,\u001a\u0004\u0018\u00010\u001b2\u0006\u0010)\u001a\u00020\u0011J\u0010\u0010-\u001a\u0004\u0018\u00010\u001d2\u0006\u0010)\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R!\u0010%\u001a\u0012\u0012\u0004\u0012\u00020!0 j\b\u0012\u0004\u0012\u00020!`\"\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "makeDescription", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods$SpecialMethodDescription;", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "funName", "", "arity", "", "toDescription", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "constFalse", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "bridge", "constNull", "constMinusOne", "getSecondArg", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;", "specialMethodsWithDefaults", "", "Lorg/jetbrains/kotlin/backend/common/lower/SpecialMethodWithDefaultInfo;", "specialProperties", "Lorg/jetbrains/kotlin/backend/common/lower/BuiltInWithDifferentJvmName;", "specialMethods", "specialMethodNames", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/collections/HashSet;", "getSpecialMethodNames", "()Ljava/util/HashSet;", "specialPropertyNames", "getSpecialPropertyNames", "findSpecialWithOverride", "Lkotlin/Pair;", "irFunction", "includeSelf", "", "getSpecialMethodInfo", "getBuiltInWithDifferentJvmName", "SpecialMethodDescription", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nSpecialBridgeMethods.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialBridgeMethods.kt\norg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,146:1\n126#2:147\n153#2,3:148\n126#2:151\n153#2,3:152\n*S KotlinDebug\n*F\n+ 1 SpecialBridgeMethods.kt\norg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods\n*L\n111#1:147\n111#1:148,3\n112#1:151\n112#1:152,3\n*E\n"})
public final class SpecialBridgeMethods {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final Map<SpecialMethodDescription, SpecialMethodWithDefaultInfo> specialMethodsWithDefaults;
    @NotNull
    private final Map<SpecialMethodDescription, BuiltInWithDifferentJvmName> specialProperties;
    @NotNull
    private final Map<SpecialMethodDescription, BuiltInWithDifferentJvmName> specialMethods;
    @NotNull
    private final HashSet<Name> specialMethodNames;
    @NotNull
    private final HashSet<Name> specialPropertyNames;

    public SpecialBridgeMethods(@NotNull CommonBackendContext context2) {
        SpecialMethodDescription description;
        Collection collection;
        Map.Entry entry;
        Map.Entry<Object, Object> item$iv$iv;
        Map<SpecialMethodDescription, BuiltInWithDifferentJvmName> $this$mapTo$iv$iv;
        Map<SpecialMethodDescription, BuiltInWithDifferentJvmName> $this$map$iv;
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        Object object = new Pair[]{TuplesKt.to(this.makeDescription(StandardNames.FqNames.collection, "contains", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, false, false, 12, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.mutableCollection, "remove", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, false, false, 12, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.map, "containsKey", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, false, false, 12, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.map, "containsValue", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, false, false, 12, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.mutableMap, "remove", 2), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constFalse((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 2, false, false, 12, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.list, "indexOf", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constMinusOne((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, false, false, 12, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.list, "lastIndexOf", 1), new SpecialMethodWithDefaultInfo(new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constMinusOne((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, false, false, 12, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.map, "getOrDefault", 2), new SpecialMethodWithDefaultInfo((Function1<? super IrSimpleFunction, ? extends IrExpression>)new Function1<IrSimpleFunction, IrGetValueImpl>((Object)this){

            public final IrGetValueImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$getSecondArg((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, true, true)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.map, "get", 1), new SpecialMethodWithDefaultInfo((Function1<? super IrSimpleFunction, ? extends IrExpression>)new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constNull((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, true, true)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.mutableMap, "remove", 1), new SpecialMethodWithDefaultInfo((Function1<? super IrSimpleFunction, ? extends IrExpression>)new Function1<IrSimpleFunction, IrConstImpl>((Object)this){

            public final IrConstImpl invoke(IrSimpleFunction p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return SpecialBridgeMethods.access$constNull((SpecialBridgeMethods)this.receiver, p0);
            }
        }, 1, true, true))};
        this.specialMethodsWithDefaults = MapsKt.mapOf(object);
        object = new Pair[]{TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.collection, "size", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.map, "size", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.charSequence.toSafe(), "length", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.map, "keys", 0, 4, null), new BuiltInWithDifferentJvmName(true, false, 2, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.map, "values", 0, 4, null), new BuiltInWithDifferentJvmName(true, false, 2, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.map, "entries", 0, 4, null), new BuiltInWithDifferentJvmName(true, false, 2, null))};
        this.specialProperties = MapsKt.mapOf(object);
        object = new Pair[]{TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.number.toSafe(), "toByte", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.number.toSafe(), "toShort", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.number.toSafe(), "toInt", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.number.toSafe(), "toLong", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.number.toSafe(), "toFloat", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(SpecialBridgeMethods.makeDescription$default(this, StandardNames.FqNames.number.toSafe(), "toDouble", 0, 4, null), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.charSequence.toSafe(), "get", 1), new BuiltInWithDifferentJvmName(false, false, 3, null)), TuplesKt.to(this.makeDescription(StandardNames.FqNames.mutableList, "removeAt", 1), new BuiltInWithDifferentJvmName(true, false))};
        this.specialMethods = MapsKt.mapOf(object);
        object = MapsKt.plus(this.specialMethodsWithDefaults, this.specialMethods);
        SpecialBridgeMethods specialBridgeMethods = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator<Map.Entry<Object, Object>> iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            description = (SpecialMethodDescription)entry.getKey();
            collection.add(description.getName());
        }
        specialBridgeMethods.specialMethodNames = CollectionsKt.toHashSet((List)destination$iv$iv);
        $this$map$iv = this.specialProperties;
        specialBridgeMethods = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            boolean bl = false;
            description = (SpecialMethodDescription)entry.getKey();
            collection.add(description.getName());
        }
        specialBridgeMethods.specialPropertyNames = CollectionsKt.toHashSet((List)destination$iv$iv);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    private final SpecialMethodDescription makeDescription(FqName classFqName, String funName, int arity) {
        Name name2 = Name.identifier(funName);
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        return new SpecialMethodDescription(classFqName, name2, arity);
    }

    static /* synthetic */ SpecialMethodDescription makeDescription$default(SpecialBridgeMethods specialBridgeMethods, FqName fqName, String string, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return specialBridgeMethods.makeDescription(fqName, string, n2);
    }

    private final SpecialMethodDescription toDescription(IrSimpleFunction $this$toDescription) {
        return new SpecialMethodDescription(IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass($this$toDescription)), $this$toDescription.getName(), IrUtilsKt.getNonDispatchParameters($this$toDescription).size());
    }

    private final IrConstImpl constFalse(IrSimpleFunction bridge) {
        return BuildersKt.IrConstImpl(-1, -1, this.context.getIrBuiltIns().getBooleanType(), IrConstKind.Boolean.INSTANCE, false);
    }

    private final IrConstImpl constNull(IrSimpleFunction bridge) {
        return BuildersKt.IrConstImpl(-1, -1, this.context.getIrBuiltIns().getAnyNType(), IrConstKind.Null.INSTANCE, null);
    }

    private final IrConstImpl constMinusOne(IrSimpleFunction bridge) {
        return BuildersKt.IrConstImpl(-1, -1, this.context.getIrBuiltIns().getIntType(), IrConstKind.Int.INSTANCE, -1);
    }

    private final IrGetValueImpl getSecondArg(IrSimpleFunction bridge) {
        return BuildersKt.IrGetValueImpl$default(-1, -1, bridge.getParameters().get(2).getSymbol(), null, 8, null);
    }

    @NotNull
    public final HashSet<Name> getSpecialMethodNames() {
        return this.specialMethodNames;
    }

    @NotNull
    public final HashSet<Name> getSpecialPropertyNames() {
        return this.specialPropertyNames;
    }

    @Nullable
    public final Pair<IrSimpleFunction, SpecialMethodWithDefaultInfo> findSpecialWithOverride(@NotNull IrSimpleFunction irFunction, boolean includeSelf) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        if (!(irFunction.getParent() instanceof IrClass)) {
            return null;
        }
        for (IrSimpleFunction irSimpleFunction : IrUtilsKt.allOverridden((IrOverridableDeclaration)irFunction, includeSelf)) {
            SpecialMethodDescription description = this.toDescription(irSimpleFunction);
            SpecialMethodWithDefaultInfo specialMethodWithDefaultInfo = this.specialMethodsWithDefaults.get(description);
            if (specialMethodWithDefaultInfo == null) continue;
            SpecialMethodWithDefaultInfo it = specialMethodWithDefaultInfo;
            boolean bl = false;
            return new Pair<IrSimpleFunction, SpecialMethodWithDefaultInfo>(irSimpleFunction, it);
        }
        return null;
    }

    public static /* synthetic */ Pair findSpecialWithOverride$default(SpecialBridgeMethods specialBridgeMethods, IrSimpleFunction irSimpleFunction, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return specialBridgeMethods.findSpecialWithOverride(irSimpleFunction, bl);
    }

    @Nullable
    public final SpecialMethodWithDefaultInfo getSpecialMethodInfo(@NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        SpecialMethodDescription description = this.toDescription(irFunction);
        return this.specialMethodsWithDefaults.get(description);
    }

    @Nullable
    public final BuiltInWithDifferentJvmName getBuiltInWithDifferentJvmName(@NotNull IrSimpleFunction irFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        IrPropertySymbol irPropertySymbol = irFunction.getCorrespondingPropertySymbol();
        if (irPropertySymbol != null) {
            IrPropertySymbol it = irPropertySymbol;
            boolean bl = false;
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(IrUtilsKt.getParentAsClass(irFunction));
            if (fqName == null) {
                return null;
            }
            FqName classFqName = fqName;
            String string = ((IrProperty)it.getOwner()).getName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            return this.specialProperties.get(SpecialBridgeMethods.makeDescription$default(this, classFqName, string, 0, 4, null));
        }
        return this.specialMethods.get(this.toDescription(irFunction));
    }

    public static final /* synthetic */ IrConstImpl access$constFalse(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constFalse(bridge);
    }

    public static final /* synthetic */ IrConstImpl access$constMinusOne(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constMinusOne(bridge);
    }

    public static final /* synthetic */ IrGetValueImpl access$getSecondArg(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.getSecondArg(bridge);
    }

    public static final /* synthetic */ IrConstImpl access$constNull(SpecialBridgeMethods $this, IrSimpleFunction bridge) {
        return $this.constNull(bridge);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/SpecialBridgeMethods$SpecialMethodDescription;", "", "kotlinFqClassName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "arity", "", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/Name;I)V", "getKotlinFqClassName", "()Lorg/jetbrains/kotlin/name/FqName;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getArity", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class SpecialMethodDescription {
        @Nullable
        private final FqName kotlinFqClassName;
        @NotNull
        private final Name name;
        private final int arity;

        public SpecialMethodDescription(@Nullable FqName kotlinFqClassName, @NotNull Name name2, int arity) {
            Intrinsics.checkNotNullParameter(name2, "name");
            this.kotlinFqClassName = kotlinFqClassName;
            this.name = name2;
            this.arity = arity;
        }

        @Nullable
        public final FqName getKotlinFqClassName() {
            return this.kotlinFqClassName;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        public final int getArity() {
            return this.arity;
        }

        @Nullable
        public final FqName component1() {
            return this.kotlinFqClassName;
        }

        @NotNull
        public final Name component2() {
            return this.name;
        }

        public final int component3() {
            return this.arity;
        }

        @NotNull
        public final SpecialMethodDescription copy(@Nullable FqName kotlinFqClassName, @NotNull Name name2, int arity) {
            Intrinsics.checkNotNullParameter(name2, "name");
            return new SpecialMethodDescription(kotlinFqClassName, name2, arity);
        }

        public static /* synthetic */ SpecialMethodDescription copy$default(SpecialMethodDescription specialMethodDescription, FqName fqName, Name name2, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                fqName = specialMethodDescription.kotlinFqClassName;
            }
            if ((n3 & 2) != 0) {
                name2 = specialMethodDescription.name;
            }
            if ((n3 & 4) != 0) {
                n2 = specialMethodDescription.arity;
            }
            return specialMethodDescription.copy(fqName, name2, n2);
        }

        @NotNull
        public String toString() {
            return "SpecialMethodDescription(kotlinFqClassName=" + this.kotlinFqClassName + ", name=" + this.name + ", arity=" + this.arity + ')';
        }

        public int hashCode() {
            int result2 = this.kotlinFqClassName == null ? 0 : this.kotlinFqClassName.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.arity);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpecialMethodDescription)) {
                return false;
            }
            SpecialMethodDescription specialMethodDescription = (SpecialMethodDescription)other;
            if (!Intrinsics.areEqual(this.kotlinFqClassName, specialMethodDescription.kotlinFqClassName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.name, specialMethodDescription.name)) {
                return false;
            }
            return this.arity == specialMethodDescription.arity;
        }
    }
}

