/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.concurrentinit;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ConcurrentInitialize<T> {
    private final AtomicBoolean initializer = new AtomicBoolean(false);
    private final CountDownLatch resolved = new CountDownLatch(1);
    private Thread creator;
    private T value;
    private Exception exception;

    public T get() throws Exception {
        if (this.initializer.compareAndSet(false, true)) {
            this.creator = Thread.currentThread();
            try {
                this.value = this.create();
            }
            catch (Exception e) {
                this.exception = e;
            }
            finally {
                this.creator = null;
                this.resolved.countDown();
            }
        } else {
            Thread t = this.creator;
            if (t != null && t == Thread.currentThread()) {
                throw new IllegalStateException("Cycle: ConcurrentInitialize's create returns to same instance");
            }
            this.resolved.await();
        }
        if (this.exception == null) {
            return this.value;
        }
        throw this.exception;
    }

    public abstract T create() throws Exception;
}

