/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.error.Error;

public final class SqlInvariants {
    public static final String SYSTEM_AUTHORIZATION_NAME = "_SYSTEM";
    public static final String DBA_ADMIN_ROLE_NAME = "DBA";
    public static final String SCHEMA_CREATE_ROLE_NAME = "CREATE_SCHEMA";
    public static final String CHANGE_AUTH_ROLE_NAME = "CHANGE_AUTHORIZATION";
    public static final String SCRIPT_OPS_ROLE_NAME = "SCRIPT_OPS";
    public static final String SYSTEM_SUBQUERY = "SYSTEM_SUBQUERY";
    public static final String PUBLIC_ROLE_NAME = "PUBLIC";
    public static final String DEFAULT_CATALOG_NAME = "PUBLIC";
    public static final String SESSION_SCHEMA = "SESSION";
    public static final String SYSTEM_SCHEMA = "SYSTEM_SCHEMA";
    public static final String LOBS_SCHEMA = "SYSTEM_LOBS";
    public static final String DEFINITION_SCHEMA = "DEFINITION_SCHEMA";
    public static final String INFORMATION_SCHEMA = "INFORMATION_SCHEMA";
    public static final String SQLJ_SCHEMA = "SQLJ";
    public static final String PUBLIC_SCHEMA = "PUBLIC";
    public static final String CLASSPATH_NAME = "CLASSPATH";
    public static final String MODULE = "MODULE";
    public static final String DUAL = "DUAL";
    public static final String DUMMY = "DUMMY";
    public static final String IDX = "IDX";
    public static final String RECURSIVE_TABLE = "RECURSIVE_TABLE";
    public static final HsqlNameManager.HsqlName INFORMATION_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("INFORMATION_SCHEMA", 2);
    public static final HsqlNameManager.HsqlName SESSION_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SESSION", 2);
    public static final HsqlNameManager.HsqlName SYSTEM_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_SCHEMA", 2);
    public static final HsqlNameManager.HsqlName LOBS_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_LOBS", 2);
    public static final HsqlNameManager.HsqlName SQLJ_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SQLJ", 2);
    public static final HsqlNameManager.HsqlName SYSTEM_SUBQUERY_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_SUBQUERY", 3);
    public static final HsqlNameManager.HsqlName MODULE_HSQLNAME = HsqlNameManager.newSystemObjectName("MODULE", 2);
    public static final HsqlNameManager.HsqlName DUAL_TABLE_HSQLNAME = HsqlNameManager.newSystemObjectName("DUAL", 3);
    public static final HsqlNameManager.HsqlName DUAL_COLUMN_HSQLNAME;
    public static final HsqlNameManager.HsqlName SYSTEM_INDEX_HSQLNAME;

    public static void checkSchemaNameNotSystem(String string) {
        if (SqlInvariants.isSystemSchemaName(string)) {
            throw Error.error(5503, string);
        }
    }

    public static boolean isSystemSchemaName(String string) {
        return DEFINITION_SCHEMA.equals(string) || INFORMATION_SCHEMA.equals(string) || SYSTEM_SCHEMA.equals(string) || SQLJ_SCHEMA.equals(string);
    }

    public static boolean isLobsSchemaName(String string) {
        return LOBS_SCHEMA.equals(string);
    }

    public static boolean isSchemaNameSystem(HsqlNameManager.HsqlName hsqlName) {
        if (hsqlName.schema != null) {
            hsqlName = hsqlName.schema;
        }
        return INFORMATION_SCHEMA_HSQLNAME.equals(hsqlName) || SYSTEM_SCHEMA_HSQLNAME.equals(hsqlName) || SQLJ_SCHEMA_HSQLNAME.equals(hsqlName);
    }

    static {
        SqlInvariants.DUAL_TABLE_HSQLNAME.schema = SYSTEM_SCHEMA_HSQLNAME;
        DUAL_COLUMN_HSQLNAME = HsqlNameManager.newSystemObjectName(DUMMY, 9);
        SqlInvariants.DUAL_COLUMN_HSQLNAME.parent = DUAL_TABLE_HSQLNAME;
        SYSTEM_INDEX_HSQLNAME = HsqlNameManager.newSystemObjectName(IDX, 20);
        SYSTEM_SUBQUERY_HSQLNAME.setSchemaIfNull(SYSTEM_SCHEMA_HSQLNAME);
    }
}

