/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data.sketch;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.matrix.data.sketch.MatrixSketch;
import org.apache.sysds.runtime.matrix.data.sketch.countdistinct.CountDistinctFunctionSketch;
import org.apache.sysds.runtime.matrix.data.sketch.countdistinctapprox.KMVSketch;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperator;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperatorTypes;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class MatrixSketchFactory {
    public static MatrixSketch get(Operator op) {
        if (op instanceof CountDistinctOperator) {
            CountDistinctOperator cdop = (CountDistinctOperator)op;
            if (cdop.getOperatorType() == CountDistinctOperatorTypes.COUNT) {
                return new CountDistinctFunctionSketch(op);
            }
            if (cdop.getOperatorType() == CountDistinctOperatorTypes.KMV) {
                return new KMVSketch(op);
            }
            throw new NotImplementedException("Only COUNT and KMV count distinct sketches are supported for now");
        }
        throw new IllegalArgumentException("Only sketches for count distinct operators are supported for now");
    }
}

