/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import java.util.HashSet;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.recompile.Recompiler;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.spark.CSVReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.LIBSVMReblockSPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysds.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FileFormatPropertiesLIBSVM;
import org.apache.sysds.runtime.io.FileFormatPropertiesMM;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;
import org.apache.sysds.runtime.util.ProgramConverter;
import org.apache.sysds.utils.Statistics;

public class ReblockSPInstruction
extends UnarySPInstruction {
    private int blen;
    private boolean outputEmptyBlocks;

    private ReblockSPInstruction(Operator op, CPOperand in, CPOperand out, int br, int bc, boolean emptyBlocks, String opcode, String instr) {
        super(SPInstruction.SPType.Reblock, op, in, out, opcode, instr);
        this.blen = br;
        this.blen = bc;
        this.outputEmptyBlocks = emptyBlocks;
    }

    public static ReblockSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equals(Opcodes.RBLK.toString())) {
            throw new DMLRuntimeException("Incorrect opcode for ReblockSPInstruction:" + opcode);
        }
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        int blen = Integer.parseInt(parts[3]);
        boolean outputEmptyBlocks = Boolean.parseBoolean(parts[4]);
        Operator op = null;
        return new ReblockSPInstruction(op, in, out, blen, blen, outputEmptyBlocks, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        CacheableData<?> obj = sec.getCacheableData(this.input1.getName());
        DataCharacteristics mc = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        mcOut.set(mc.getRows(), mc.getCols(), this.blen, mc.getNonZeros());
        MetaDataFormat iimd = (MetaDataFormat)obj.getMetaData();
        if (iimd == null) {
            throw new DMLRuntimeException("Error: Metadata not found");
        }
        if (Recompiler.checkCPReblock(sec, this.input1.getName())) {
            if (this.input1.getDataType().isMatrix() || this.input1.getDataType().isFrame()) {
                Recompiler.executeInMemoryReblock(sec, this.input1.getName(), this.output.getName(), iimd.getFileFormat() == Types.FileFormat.BINARY ? (LineageItem)this.getLineageItem(ec).getValue() : null);
            }
            Statistics.decrementNoOfExecutedSPInst();
            return;
        }
        if (this.input1.getDataType() == Types.DataType.MATRIX) {
            this.processMatrixReblockInstruction(sec, iimd.getFileFormat());
        } else if (this.input1.getDataType() == Types.DataType.FRAME) {
            this.processFrameReblockInstruction(sec, iimd.getFileFormat());
        }
    }

    protected void processMatrixReblockInstruction(SparkExecutionContext sec, Types.FileFormat fmt) {
        MatrixObject mo = sec.getMatrixObject(this.input1.getName());
        DataCharacteristics mc = sec.getDataCharacteristics(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (fmt == Types.FileFormat.TEXT || fmt == Types.FileFormat.MM) {
            FileFormatPropertiesMM mmProps = fmt == Types.FileFormat.MM ? IOUtilFunctions.readAndParseMatrixMarketHeader(mo.getFileName()) : null;
            JavaPairRDD<?, ?> lines = sec.getRDDHandleForMatrixObject(mo, fmt);
            JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.textCellToBinaryBlock(sec.getSparkContext(), lines, mcOut, this.outputEmptyBlocks, mmProps);
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        } else {
            if (fmt == Types.FileFormat.CSV) {
                CSVReblockSPInstruction csvInstruction = null;
                boolean hasHeader = false;
                String delim = ",";
                boolean fill = false;
                double fillValue = 0.0;
                HashSet<String> naStrings = null;
                if (mo.getFileFormatProperties() instanceof FileFormatPropertiesCSV && mo.getFileFormatProperties() != null) {
                    FileFormatPropertiesCSV props = (FileFormatPropertiesCSV)mo.getFileFormatProperties();
                    hasHeader = props.hasHeader();
                    delim = props.getDelim();
                    fill = props.isFill();
                    fillValue = props.getFillValue();
                    naStrings = props.getNAStrings();
                }
                csvInstruction = new CSVReblockSPInstruction(null, this.input1, this.output, mcOut.getBlocksize(), mcOut.getBlocksize(), hasHeader, delim, fill, fillValue, Opcodes.CSVRBLK.toString(), this.instString, naStrings);
                csvInstruction.processInstruction(sec);
                return;
            }
            if (fmt == Types.FileFormat.BINARY && mc.getBlocksize() <= 0) {
                JavaPairRDD<?, ?> binaryCells = sec.getRDDHandleForMatrixObject(mo, Types.FileFormat.BINARY);
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.binaryCellToBinaryBlock(sec.getSparkContext(), binaryCells, mcOut, this.outputEmptyBlocks);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
            } else if (fmt == Types.FileFormat.BINARY) {
                JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.binaryBlockToBinaryBlock(in1, mc, mcOut);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
            } else if (fmt == Types.FileFormat.LIBSVM) {
                String delim = " ";
                String indexDelim = ":";
                if (mo.getFileFormatProperties() instanceof FileFormatPropertiesLIBSVM && mo.getFileFormatProperties() != null) {
                    FileFormatPropertiesLIBSVM props = (FileFormatPropertiesLIBSVM)mo.getFileFormatProperties();
                    delim = props.getDelim();
                    indexDelim = props.getIndexDelim();
                }
                LIBSVMReblockSPInstruction libsvmInstruction = new LIBSVMReblockSPInstruction(null, this.input1, this.output, mcOut.getBlocksize(), mcOut.getBlocksize(), "libsvmblk", delim, indexDelim, this.instString);
                libsvmInstruction.processInstruction(sec);
            } else if (fmt == Types.FileFormat.COMPRESSED) {
                JavaPairRDD<?, ?> in1 = sec.getRDDHandleForMatrixObject(mo, Types.FileFormat.COMPRESSED);
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.binaryBlockToBinaryBlock(in1, mc, mcOut);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
            } else {
                throw new DMLRuntimeException("The given format is not implemented for ReblockSPInstruction:" + fmt.toString());
            }
        }
    }

    protected void processFrameReblockInstruction(SparkExecutionContext sec, Types.FileFormat fmt) {
        FrameObject fo = sec.getFrameObject(this.input1.getName());
        DataCharacteristics mcOut = sec.getDataCharacteristics(this.output.getName());
        if (fmt == Types.FileFormat.TEXT) {
            JavaPairRDD<?, ?> lines = sec.getRDDHandleForFrameObject(fo, fmt);
            JavaPairRDD<Long, FrameBlock> out = FrameRDDConverterUtils.textCellToBinaryBlock(sec.getSparkContext(), lines, mcOut, fo.getSchema());
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        } else if (fmt == Types.FileFormat.CSV) {
            CSVReblockSPInstruction csvInstruction = null;
            boolean hasHeader = false;
            String delim = ",";
            boolean fill = false;
            double fillValue = 0.0;
            HashSet<String> naStrings = null;
            if (fo.getFileFormatProperties() instanceof FileFormatPropertiesCSV && fo.getFileFormatProperties() != null) {
                FileFormatPropertiesCSV props = (FileFormatPropertiesCSV)fo.getFileFormatProperties();
                hasHeader = props.hasHeader();
                delim = props.getDelim();
                fill = props.isFill();
                fillValue = props.getFillValue();
                naStrings = props.getNAStrings();
            }
            csvInstruction = new CSVReblockSPInstruction(null, this.input1, this.output, mcOut.getBlocksize(), mcOut.getBlocksize(), hasHeader, delim, fill, fillValue, Opcodes.CSVRBLK.toString(), this.instString, naStrings);
            csvInstruction.processInstruction(sec);
        } else if (fmt == Types.FileFormat.LIBSVM) {
            String delim = " ";
            String indexDelim = ":";
            if (fo.getFileFormatProperties() instanceof FileFormatPropertiesLIBSVM && fo.getFileFormatProperties() != null) {
                FileFormatPropertiesLIBSVM props = (FileFormatPropertiesLIBSVM)fo.getFileFormatProperties();
                delim = props.getDelim();
                indexDelim = props.getIndexDelim();
            }
            LIBSVMReblockSPInstruction libsvmInstruction = new LIBSVMReblockSPInstruction(null, this.input1, this.output, mcOut.getBlocksize(), mcOut.getBlocksize(), "libsvmblk", delim, indexDelim, this.instString);
            libsvmInstruction.processInstruction(sec);
        } else {
            throw new DMLRuntimeException("The given format is not implemented for ReblockSPInstruction: " + fmt.toString());
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        if (ec.getLineage() == null) {
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(ProgramConverter.serializeDataObject(this.input1.getName(), ec.getCacheableData(this.input1)), "cache_rblk"));
        }
        return super.getLineageItem(ec);
    }

    public int getBlockLength() {
        return this.blen;
    }

    public boolean getOutputEmptyBlocks() {
        return this.outputEmptyBlocks;
    }
}

