/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.node.MissingNode;

class UsernamePasswordAuthenticationTokenDeserializer
extends ValueDeserializer<UsernamePasswordAuthenticationToken> {
    private static final TypeReference<List<GrantedAuthority>> GRANTED_AUTHORITY_LIST = new TypeReference<List<GrantedAuthority>>(){};

    UsernamePasswordAuthenticationTokenDeserializer() {
    }

    public UsernamePasswordAuthenticationToken deserialize(JsonParser jp, DeserializationContext ctxt) throws JacksonException {
        JsonNode jsonNode = ctxt.readTree(jp);
        boolean authenticated = this.readJsonNode(jsonNode, "authenticated").asBoolean();
        JsonNode principalNode = this.readJsonNode(jsonNode, "principal");
        Object principal = this.getPrincipal(ctxt, principalNode);
        JsonNode credentialsNode = this.readJsonNode(jsonNode, "credentials");
        Object credentials = this.getCredentials(credentialsNode);
        JsonNode authoritiesNode = this.readJsonNode(jsonNode, "authorities");
        List authorities = (List)ctxt.readTreeAsValue(authoritiesNode, ctxt.getTypeFactory().constructType(GRANTED_AUTHORITY_LIST));
        UsernamePasswordAuthenticationToken token = !authenticated ? UsernamePasswordAuthenticationToken.unauthenticated(principal, credentials) : UsernamePasswordAuthenticationToken.authenticated(principal, credentials, authorities);
        JsonNode detailsNode = this.readJsonNode(jsonNode, "details");
        if (detailsNode.isNull() || detailsNode.isMissingNode()) {
            token.setDetails(null);
        } else {
            Object details = ctxt.readTreeAsValue(detailsNode, Object.class);
            token.setDetails(details);
        }
        return token;
    }

    private @Nullable Object getCredentials(JsonNode credentialsNode) {
        if (credentialsNode.isNull() || credentialsNode.isMissingNode()) {
            return null;
        }
        return credentialsNode.asString();
    }

    private Object getPrincipal(DeserializationContext ctxt, JsonNode principalNode) throws StreamReadException, DatabindException {
        if (principalNode.isObject()) {
            return ctxt.readTreeAsValue(principalNode, Object.class);
        }
        return principalNode.asString();
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        return jsonNode.has(field) ? jsonNode.get(field) : MissingNode.getInstance();
    }
}

