/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.lang.model.element.Modifier;
import org.springframework.data.javapoet.TypeNames;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.MethodMetadata;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterSpec;
import org.springframework.javapoet.TypeVariableName;

class AotRepositoryMethodBuilder {
    private final AotQueryMethodGenerationContext context;
    private Function<AotQueryMethodGenerationContext, CodeBlock> contribution = context -> CodeBlock.builder().build();
    private BiConsumer<AotQueryMethodGenerationContext, CodeBlock.Builder> customizer = (context, body) -> {};

    AotRepositoryMethodBuilder(AotQueryMethodGenerationContext context2) {
        this.context = context2;
    }

    public AotRepositoryMethodBuilder contribute(Function<AotQueryMethodGenerationContext, CodeBlock> contribution) {
        this.contribution = contribution;
        return this;
    }

    public AotRepositoryMethodBuilder customize(BiConsumer<AotQueryMethodGenerationContext, CodeBlock.Builder> customizer) {
        this.customizer = customizer;
        return this;
    }

    public MethodSpec buildMethod() {
        CodeBlock methodBody = this.contribution.apply(this.context);
        MethodSpec.Builder builder = this.initializeMethodBuilder();
        if (this.context.getExpressionMarker().isInUse()) {
            builder.addCode(this.context.getExpressionMarker().declaration());
        }
        builder.addCode(methodBody);
        CodeBlock.Builder customizerBlock = CodeBlock.builder();
        this.customizer.accept(this.context, customizerBlock);
        builder.addCode(customizerBlock.build());
        return builder.build();
    }

    private MethodSpec.Builder initializeMethodBuilder() {
        TypeVariable<Method>[] tvs;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)this.context.getMethod().getName()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        builder.returns(TypeNames.resolvedTypeName(this.context.getTargetMethodMetadata().getReturnType()));
        for (TypeVariable<Method> tv : tvs = this.context.getMethod().getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get(tv));
        }
        MethodMetadata methodMetadata = this.context.getTargetMethodMetadata();
        Map<String, ParameterSpec> methodArguments = methodMetadata.getMethodArguments();
        builder.addJavadoc("AOT generated implementation of {@link $T#$L}.", new Object[]{this.context.getMethod().getDeclaringClass(), ReflectionUtils.toString(this.context.getMethod())});
        methodArguments.forEach((name, spec) -> builder.addParameter(spec));
        return builder;
    }
}

