/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.facelets;

import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.util.Map;
import org.apache.myfaces.tobago.component.Attributes;

public class GridLayoutConstraintHandler
extends TagHandler {
    private final TagAttribute columnSpan;
    private final TagAttribute rowSpan;
    private final TagAttribute gridColumn;
    private final TagAttribute gridRow;

    public GridLayoutConstraintHandler(TagConfig config) {
        super(config);
        TagAttribute oldColumn = this.getAttribute(Attributes.column.getName());
        TagAttribute newColumn = this.getAttribute(Attributes.columnSpan.getName());
        this.columnSpan = newColumn != null ? newColumn : oldColumn;
        TagAttribute oldRow = this.getAttribute(Attributes.row.getName());
        TagAttribute newRow = this.getAttribute(Attributes.rowSpan.getName());
        this.rowSpan = newRow != null ? newRow : oldRow;
        this.gridColumn = this.getAttribute(Attributes.gridColumn.getName());
        this.gridRow = this.getAttribute(Attributes.gridRow.getName());
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException {
        Map attributes = parent.getAttributes();
        if (this.columnSpan != null) {
            if (this.columnSpan.isLiteral()) {
                attributes.put(Attributes.columnSpan.getName(), Integer.valueOf(this.columnSpan.getValue()));
            } else {
                parent.setValueExpression(Attributes.columnSpan.getName(), this.columnSpan.getValueExpression(faceletContext, Integer.TYPE));
            }
        }
        if (this.rowSpan != null) {
            if (this.rowSpan.isLiteral()) {
                attributes.put(Attributes.rowSpan.getName(), Integer.valueOf(this.rowSpan.getValue()));
            } else {
                parent.setValueExpression(Attributes.rowSpan.getName(), this.rowSpan.getValueExpression(faceletContext, Integer.TYPE));
            }
        }
        if (this.gridColumn != null) {
            if (this.gridColumn.isLiteral()) {
                attributes.put(Attributes.gridColumn.getName(), Integer.valueOf(this.gridColumn.getValue()));
            } else {
                parent.setValueExpression(Attributes.gridColumn.getName(), this.gridColumn.getValueExpression(faceletContext, Integer.TYPE));
            }
        }
        if (this.gridRow != null) {
            if (this.gridRow.isLiteral()) {
                attributes.put(Attributes.gridRow.getName(), Integer.valueOf(this.gridRow.getValue()));
            } else {
                parent.setValueExpression(Attributes.gridRow.getName(), this.gridRow.getValueExpression(faceletContext, Integer.TYPE));
            }
        }
    }
}

