/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.v4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.toolchain.TrackableBase;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.xml.XmlNodeImpl;

@Generated
public class MavenToolchainsTransformer {
    private final UnaryOperator<String> transformer;

    public MavenToolchainsTransformer(UnaryOperator<String> transformer) {
        this.transformer = transformer;
    }

    public PersistedToolchains visit(PersistedToolchains target) {
        Objects.requireNonNull(target, "target cannot be null");
        return this.transformPersistedToolchains(target);
    }

    protected String transform(String value) {
        return (String)this.transformer.apply(value);
    }

    protected TrackableBase transformTrackableBase(TrackableBase target) {
        if (target == null) {
            return null;
        }
        Supplier<TrackableBase.Builder> creator = () -> TrackableBase.newBuilder((TrackableBase)target);
        Object builder = null;
        return builder != null ? builder.build() : target;
    }

    protected PersistedToolchains transformPersistedToolchains(PersistedToolchains target) {
        if (target == null) {
            return null;
        }
        Supplier<PersistedToolchains.Builder> creator = () -> PersistedToolchains.newBuilder((PersistedToolchains)target);
        PersistedToolchains.Builder builder = null;
        return (builder = this.transformPersistedToolchains_Toolchains(creator, builder, target)) != null ? builder.build() : target;
    }

    protected PersistedToolchains.Builder transformPersistedToolchains_Toolchains(Supplier<? extends PersistedToolchains.Builder> creator, PersistedToolchains.Builder builder, PersistedToolchains target) {
        List oldVal = target.getToolchains();
        List newVal = this.transform(oldVal, this::transformToolchainModel);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).toolchains(newVal) : builder;
    }

    protected ToolchainModel transformToolchainModel(ToolchainModel target) {
        if (target == null) {
            return null;
        }
        Supplier<ToolchainModel.Builder> creator = () -> ToolchainModel.newBuilder((ToolchainModel)target);
        ToolchainModel.Builder builder = null;
        builder = this.transformToolchainModel_Type(creator, builder, target);
        builder = this.transformToolchainModel_Provides(creator, builder, target);
        return (builder = this.transformToolchainModel_Configuration(creator, builder, target)) != null ? builder.build() : target;
    }

    protected ToolchainModel.Builder transformToolchainModel_Type(Supplier<? extends ToolchainModel.Builder> creator, ToolchainModel.Builder builder, ToolchainModel target) {
        String oldVal = target.getType();
        String newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).type(newVal) : builder;
    }

    protected ToolchainModel.Builder transformToolchainModel_Provides(Supplier<? extends ToolchainModel.Builder> creator, ToolchainModel.Builder builder, ToolchainModel target) {
        Map props = target.getProvides();
        HashMap<String, String> newProps = null;
        for (Map.Entry entry : props.entrySet()) {
            String newVal = this.transform((String)entry.getValue());
            if (newVal == null || newVal == entry.getValue()) continue;
            if (newProps == null) {
                newProps = new HashMap<String, String>();
                newProps.putAll(props);
                builder = builder != null ? builder : creator.get();
                builder.provides(newProps);
            }
            newProps.put((String)entry.getKey(), newVal);
        }
        return builder;
    }

    protected ToolchainModel.Builder transformToolchainModel_Configuration(Supplier<? extends ToolchainModel.Builder> creator, ToolchainModel.Builder builder, ToolchainModel target) {
        XmlNode oldVal = target.getConfiguration();
        XmlNode newVal = this.transform(oldVal);
        return newVal != oldVal ? (builder != null ? builder : creator.get()).configuration(newVal) : builder;
    }

    protected <T> List<T> transform(List<T> list, UnaryOperator<T> transformer) {
        List<T> newList = list;
        for (int i = 0; i < list.size(); ++i) {
            T oldVal = list.get(i);
            Object newVal = transformer.apply(oldVal);
            if (newVal == oldVal) continue;
            if (newList == list) {
                newList = new ArrayList<T>(list);
            }
            newList.set(i, newVal);
        }
        return newList;
    }

    protected <T> Map<String, T> transform(Map<String, T> map, UnaryOperator<T> transformer) {
        Map<String, T> newMap = map;
        for (String key : map.keySet()) {
            T oldVal = map.get(key);
            Object newVal = transformer.apply(oldVal);
            if (newVal == oldVal) continue;
            if (newMap == map) {
                newMap = new HashMap<String, T>(map);
            }
            newMap.put(key, newVal);
        }
        return newMap;
    }

    protected XmlNode transform(XmlNode node) {
        if (node != null) {
            String oldValue = node.getValue();
            String newValue = this.transform(oldValue);
            Map oldAttrs = node.getAttributes();
            Map newAttrs = this.transform(oldAttrs, this::transform);
            List oldChildren = node.getChildren();
            List newChildren = this.transform(oldChildren, this::transform);
            if (oldValue != newValue || oldAttrs != newAttrs || oldChildren != newChildren) {
                return new XmlNodeImpl(node.getPrefix(), node.getNamespaceUri(), node.getName(), newValue, newAttrs, newChildren, node.getInputLocation());
            }
        }
        return node;
    }
}

