/*
 * Decompiled with CFR 0.152.
 */
package org.jline.consoleui.prompt;

import java.io.IOError;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jline.builtins.Styles;
import org.jline.consoleui.elements.Checkbox;
import org.jline.consoleui.elements.ConfirmChoice;
import org.jline.consoleui.elements.ExpandableChoice;
import org.jline.consoleui.elements.InputValue;
import org.jline.consoleui.elements.ListChoice;
import org.jline.consoleui.elements.PageSizeType;
import org.jline.consoleui.elements.PromptableElementIF;
import org.jline.consoleui.elements.Text;
import org.jline.consoleui.elements.items.ConsoleUIItemIF;
import org.jline.consoleui.elements.items.impl.ChoiceItem;
import org.jline.consoleui.prompt.AbstractPrompt;
import org.jline.consoleui.prompt.ConfirmResult;
import org.jline.consoleui.prompt.NoResult;
import org.jline.consoleui.prompt.PromptResultItemIF;
import org.jline.consoleui.prompt.builder.PromptBuilder;
import org.jline.reader.LineReader;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Attributes;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedCharSequence;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import org.jline.utils.StyleResolver;

public class ConsolePrompt {
    protected final LineReader reader;
    protected final Terminal terminal;
    protected final UiConfig config;
    protected Attributes attributes;
    protected List<AttributedString> header = new ArrayList<AttributedString>();

    public ConsolePrompt(Terminal terminal) {
        this(null, terminal, new UiConfig());
    }

    public ConsolePrompt(Terminal terminal, UiConfig config) {
        this(null, terminal, config);
    }

    public ConsolePrompt(LineReader reader, Terminal terminal, UiConfig config) {
        this.terminal = terminal;
        this.config = config;
        this.reader = reader;
        if (reader != null) {
            HashMap<LineReader.Option, Boolean> options = new HashMap<LineReader.Option, Boolean>();
            for (LineReader.Option option : LineReader.Option.values()) {
                options.put(option, reader.isSet(option));
            }
            config.setReaderOptions(options);
        }
    }

    protected void open() {
        if (!this.terminalInRawMode()) {
            this.attributes = this.terminal.enterRawMode();
            this.terminal.puts(InfoCmp.Capability.enter_ca_mode, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.keypad_xmit, new Object[0]);
            this.terminal.writer().flush();
        }
    }

    protected void close() {
        if (this.terminalInRawMode()) {
            this.terminal.setAttributes(this.attributes);
            this.terminal.puts(InfoCmp.Capability.exit_ca_mode, new Object[0]);
            this.terminal.puts(InfoCmp.Capability.keypad_local, new Object[0]);
            this.terminal.writer().flush();
            for (AttributedString as : this.header) {
                as.println(this.terminal);
            }
            this.terminal.writer().flush();
            this.attributes = null;
        }
    }

    private boolean terminalInRawMode() {
        return this.attributes != null;
    }

    public Map<String, PromptResultItemIF> prompt(List<PromptableElementIF> promptableElementList) throws IOException, UserInterruptException {
        return this.prompt(new ArrayList<AttributedString>(), promptableElementList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PromptResultItemIF> prompt(List<AttributedString> header, List<PromptableElementIF> promptableElementList) throws IOException, UserInterruptException {
        try {
            this.open();
            HashMap<String, PromptResultItemIF> resultMap = new HashMap<String, PromptResultItemIF>();
            this.prompt(header, promptableElementList, resultMap);
            Map<String, PromptResultItemIF> map = this.removeNoResults(resultMap);
            return map;
        }
        finally {
            this.close();
        }
    }

    public Map<String, PromptResultItemIF> prompt(Function<Map<String, PromptResultItemIF>, List<PromptableElementIF>> promptableElementLists) throws IOException {
        return this.prompt(new ArrayList<AttributedString>(), promptableElementLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PromptResultItemIF> prompt(List<AttributedString> headerIn, Function<Map<String, PromptResultItemIF>, List<PromptableElementIF>> promptableElementLists) throws IOException {
        HashMap<String, PromptResultItemIF> resultMap = new HashMap<String, PromptResultItemIF>();
        ArrayDeque<List<PromptableElementIF>> prevLists = new ArrayDeque<List<PromptableElementIF>>();
        ArrayDeque<HashMap<String, PromptResultItemIF>> prevResults = new ArrayDeque<HashMap<String, PromptResultItemIF>>();
        boolean cancellable = this.config.cancellableFirstPrompt();
        try {
            this.open();
            List<PromptableElementIF> peList = promptableElementLists.apply(new HashMap());
            Map<String, PromptResultItemIF> peResult = new HashMap<String, PromptResultItemIF>();
            while (peList != null) {
                this.config.setCancellableFirstPrompt(!prevLists.isEmpty() || cancellable);
                this.prompt(headerIn, peList, peResult);
                if (peResult.isEmpty()) {
                    peList = (List<PromptableElementIF>)prevLists.pollFirst();
                    peResult = (Map)prevResults.pollFirst();
                    if (peResult == null) continue;
                    peResult.forEach((k, v) -> resultMap.remove(k));
                    headerIn.remove(headerIn.size() - 1);
                    continue;
                }
                prevLists.push(peList);
                prevResults.push((HashMap<String, PromptResultItemIF>)peResult);
                resultMap.putAll(peResult);
                peList = promptableElementLists.apply(resultMap);
                peResult = new HashMap();
            }
            Map<String, PromptResultItemIF> map = this.removeNoResults(resultMap);
            return map;
        }
        finally {
            this.close();
            this.config.setCancellableFirstPrompt(cancellable);
        }
    }

    protected void prompt(List<AttributedString> headerIn, List<PromptableElementIF> promptableElementList, Map<String, PromptResultItemIF> resultMap) throws IOException {
        int i;
        if (!this.terminalInRawMode()) {
            throw new IllegalStateException("Terminal is not in raw mode! Maybe ConsolePrompt is closed?");
        }
        this.header = headerIn;
        boolean backward = false;
        int n = i = resultMap.isEmpty() ? 0 : resultMap.size() - 1;
        while (i < promptableElementList.size()) {
            PromptableElementIF pe = promptableElementList.get(i);
            try {
                PromptResultItemIF oldResult;
                PromptResultItemIF result;
                if (backward) {
                    this.removePreviousResult(pe);
                    backward = false;
                }
                if ((result = this.promptElement(this.header, pe, oldResult = resultMap.get(pe.getName()))) == null) {
                    if (i > 0) {
                        i -= 2;
                        backward = true;
                    } else {
                        if (this.config.cancellableFirstPrompt()) {
                            resultMap.clear();
                            return;
                        }
                        --i;
                    }
                } else {
                    if (pe instanceof Text) {
                        Text te = (Text)pe;
                        this.header.addAll(te.getLines());
                    } else {
                        String resp = result.getDisplayResult();
                        if (result instanceof ConfirmResult) {
                            ConfirmResult cr = (ConfirmResult)result;
                            resp = cr.getConfirmed() == ConfirmChoice.ConfirmationValue.YES ? this.config.resourceBundle().getString("confirmation_yes_answer") : this.config.resourceBundle().getString("confirmation_no_answer");
                        }
                        AttributedStringBuilder message = this.createMessage(pe.getMessage(), resp);
                        this.header.add(message.toAttributedString());
                    }
                    resultMap.put(pe.getName(), result);
                }
            }
            catch (IOError e) {
                if (e.getCause() instanceof InterruptedIOException) {
                    throw new UserInterruptException(e.getCause());
                }
                throw e;
            }
            ++i;
        }
    }

    protected PromptResultItemIF promptElement(List<AttributedString> header, PromptableElementIF pe, PromptResultItemIF oldResult) {
        PromptResultItemIF result;
        AttributedStringBuilder message = this.createMessage(pe.getMessage(), null);
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.append((AttributedCharSequence)message);
        asb.style(AttributedStyle.DEFAULT);
        if (pe instanceof ListChoice) {
            ListChoice lc = (ListChoice)pe;
            result = AbstractPrompt.ListChoicePrompt.getPrompt(this.terminal, header, asb.toAttributedString(), lc.getListItemList(), ConsolePrompt.computePageSize(this.terminal, lc.getPageSize(), lc.getPageSizeType()), this.config).execute();
        } else if (pe instanceof InputValue) {
            InputValue ip = (InputValue)pe;
            if (ip.getDefaultValue() != null) {
                asb.append((CharSequence)"(").append((CharSequence)ip.getDefaultValue()).append((CharSequence)") ");
            }
            result = AbstractPrompt.InputValuePrompt.getPrompt(this.reader, this.terminal, header, asb.toAttributedString(), ip, this.config).execute();
        } else if (pe instanceof ExpandableChoice) {
            ExpandableChoice ec = (ExpandableChoice)pe;
            asb.append((CharSequence)"(");
            for (ConsoleUIItemIF consoleUIItemIF : ec.getChoiceItems()) {
                ChoiceItem ci;
                if (!(consoleUIItemIF instanceof ChoiceItem) || !(ci = (ChoiceItem)consoleUIItemIF).isSelectable()) continue;
                asb.append(ci.isDefaultChoice() ? Character.toUpperCase(ci.getKey().charValue()) : ci.getKey().charValue());
            }
            asb.append((CharSequence)"h) ");
            try {
                result = AbstractPrompt.ExpandableChoicePrompt.getPrompt(this.terminal, header, asb.toAttributedString(), ec, this.config).execute();
            }
            catch (AbstractPrompt.ExpandableChoiceException e) {
                result = AbstractPrompt.ListChoicePrompt.getPrompt(this.terminal, header, message.toAttributedString(), ec.getChoiceItems(), 10, this.config).execute();
            }
        } else if (pe instanceof Checkbox) {
            Checkbox cb = (Checkbox)pe;
            result = AbstractPrompt.CheckboxPrompt.getPrompt(this.terminal, header, message.toAttributedString(), cb.getCheckboxItemList(), ConsolePrompt.computePageSize(this.terminal, cb.getPageSize(), cb.getPageSizeType()), this.config).execute();
        } else if (pe instanceof ConfirmChoice) {
            ConfirmChoice cc = (ConfirmChoice)pe;
            if (cc.getDefaultConfirmation() == null) {
                asb.append((CharSequence)this.config.resourceBundle().getString("confirmation_without_default"));
            } else if (cc.getDefaultConfirmation() == ConfirmChoice.ConfirmationValue.YES) {
                asb.append((CharSequence)this.config.resourceBundle().getString("confirmation_yes_default"));
            } else {
                asb.append((CharSequence)this.config.resourceBundle().getString("confirmation_no_default"));
            }
            asb.append((CharSequence)" ");
            result = AbstractPrompt.ConfirmPrompt.getPrompt(this.terminal, header, asb.toAttributedString(), cc, this.config).execute();
        } else if (pe instanceof Text) {
            Text te = (Text)pe;
            result = oldResult == null ? NoResult.INSTANCE : null;
        } else {
            throw new IllegalArgumentException("wrong type of promptable element");
        }
        return result;
    }

    protected AttributedStringBuilder createMessage(String message, String response) {
        AttributedStringBuilder asb = new AttributedStringBuilder();
        asb.style(this.config.style(".pr")).append((CharSequence)"? ");
        asb.style(this.config.style(".me")).append((CharSequence)message).append((CharSequence)" ");
        if (response != null) {
            asb.style(this.config.style(".an")).append((CharSequence)response);
        }
        return asb;
    }

    public static int computePageSize(Terminal terminal, int pageSize, PageSizeType sizeType) {
        int rows = terminal.getHeight();
        return sizeType == PageSizeType.ABSOLUTE ? Math.min(rows, pageSize) : rows * pageSize / 100;
    }

    private void removePreviousResult(PromptableElementIF pe) {
        if (pe instanceof Text) {
            Text te = (Text)pe;
            for (int i = 0; i < te.getLines().size(); ++i) {
                this.header.remove(this.header.size() - 1);
            }
        } else {
            this.header.remove(this.header.size() - 1);
        }
    }

    private Map<String, PromptResultItemIF> removeNoResults(Map<String, PromptResultItemIF> resultMap) {
        return resultMap.entrySet().stream().filter(e -> !(e.getValue() instanceof NoResult)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public PromptBuilder getPromptBuilder() {
        return new PromptBuilder();
    }

    public static class UiConfig {
        static final String DEFAULT_UI_COLORS = "cu=36:be=32:bd=37:pr=32:me=1:an=36:se=36:cb=100";
        static final String UI_COLORS = "UI_COLORS";
        private final AttributedString indicator;
        private final AttributedString uncheckedBox;
        private final AttributedString checkedBox;
        private final AttributedString unavailable;
        private final StyleResolver resolver;
        private final ResourceBundle resourceBundle;
        private Map<LineReader.Option, Boolean> readerOptions = new HashMap<LineReader.Option, Boolean>();
        private boolean cancellableFirstPrompt;

        public UiConfig() {
            this(null, null, null, null);
        }

        public UiConfig(String indicator, String uncheckedBox, String checkedBox, String unavailable) {
            String uc = System.getenv(UI_COLORS);
            String uiColors = uc != null && Styles.isStylePattern((String)uc) ? uc : DEFAULT_UI_COLORS;
            this.resolver = UiConfig.resolver(uiColors);
            this.indicator = UiConfig.toAttributedString(this.resolver, indicator != null ? indicator : ">", ".cu");
            this.uncheckedBox = UiConfig.toAttributedString(this.resolver, uncheckedBox != null ? uncheckedBox : " ", ".be");
            this.checkedBox = UiConfig.toAttributedString(this.resolver, checkedBox != null ? checkedBox : "x ", ".be");
            this.unavailable = UiConfig.toAttributedString(this.resolver, unavailable != null ? unavailable : "- ", ".bd");
            this.resourceBundle = ResourceBundle.getBundle("consoleui_messages");
        }

        private static AttributedString toAttributedString(StyleResolver resolver, String string, String styleKey) {
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.style(resolver.resolve(styleKey));
            asb.append((CharSequence)string);
            return asb.toAttributedString();
        }

        public AttributedString indicator() {
            return this.indicator;
        }

        public AttributedString uncheckedBox() {
            return this.uncheckedBox;
        }

        public AttributedString checkedBox() {
            return this.checkedBox;
        }

        public AttributedString unavailable() {
            return this.unavailable;
        }

        public AttributedStyle style(String key) {
            return this.resolver.resolve(key);
        }

        public ResourceBundle resourceBundle() {
            return this.resourceBundle;
        }

        public boolean cancellableFirstPrompt() {
            return this.cancellableFirstPrompt;
        }

        public void setCancellableFirstPrompt(boolean cancellableFirstPrompt) {
            this.cancellableFirstPrompt = cancellableFirstPrompt;
        }

        protected void setReaderOptions(Map<LineReader.Option, Boolean> readerOptions) {
            this.readerOptions = readerOptions;
        }

        public Map<LineReader.Option, Boolean> readerOptions() {
            return this.readerOptions;
        }

        public static StyleResolver resolver(String style) {
            Map<String, String> colors = Arrays.stream(style.split(":")).collect(Collectors.toMap(s -> s.substring(0, s.indexOf(61)), s -> s.substring(s.indexOf(61) + 1)));
            return new StyleResolver(colors::get);
        }
    }
}

