/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.DownloadedArtifact;
import org.apache.maven.api.Repository;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.services.ArtifactResolverRequest;
import org.apache.maven.api.services.Result;

@Experimental
public interface ArtifactResolverResult
extends Result<ArtifactResolverRequest> {
    @Nonnull
    public Collection<DownloadedArtifact> getArtifacts();

    @Nullable
    public Path getPath(@Nonnull Artifact var1);

    @Nonnull
    public Map<? extends ArtifactCoordinates, ResultItem> getResults();

    default public ResultItem getResult(ArtifactCoordinates coordinates) {
        return this.getResults().get(coordinates);
    }

    public static interface ResultItem {
        public ArtifactCoordinates getCoordinates();

        public DownloadedArtifact getArtifact();

        public Map<Repository, List<Exception>> getExceptions();

        public Repository getRepository();

        public Path getPath();

        public boolean isResolved();

        public boolean isMissing();
    }
}

