/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.LifeCyclePluginAnalyzer;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.lifecycle.LifecycleNotFoundException;
import org.apache.maven.lifecycle.LifecyclePhaseNotFoundException;
import org.apache.maven.lifecycle.MavenExecutionPlan;
import org.apache.maven.lifecycle.internal.LifecycleExecutionPlanCalculator;
import org.apache.maven.lifecycle.internal.LifecycleStarter;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.MojoExecutor;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;

@Named
@Singleton
public class DefaultLifecycleExecutor
implements LifecycleExecutor {
    private final LifeCyclePluginAnalyzer lifeCyclePluginAnalyzer;
    private final DefaultLifecycles defaultLifeCycles;
    private final LifecycleTaskSegmentCalculator lifecycleTaskSegmentCalculator;
    private final LifecycleExecutionPlanCalculator lifecycleExecutionPlanCalculator;
    private final MojoExecutor mojoExecutor;
    private final LifecycleStarter lifecycleStarter;

    @Inject
    public DefaultLifecycleExecutor(LifeCyclePluginAnalyzer lifeCyclePluginAnalyzer, DefaultLifecycles defaultLifeCycles, LifecycleTaskSegmentCalculator lifecycleTaskSegmentCalculator, LifecycleExecutionPlanCalculator lifecycleExecutionPlanCalculator, MojoExecutor mojoExecutor, LifecycleStarter lifecycleStarter) {
        this.lifeCyclePluginAnalyzer = lifeCyclePluginAnalyzer;
        this.defaultLifeCycles = defaultLifeCycles;
        this.lifecycleTaskSegmentCalculator = lifecycleTaskSegmentCalculator;
        this.lifecycleExecutionPlanCalculator = lifecycleExecutionPlanCalculator;
        this.mojoExecutor = mojoExecutor;
        this.lifecycleStarter = lifecycleStarter;
    }

    @Override
    public void execute(MavenSession session) {
        this.lifecycleStarter.execute(session);
    }

    @Override
    public Set<Plugin> getPluginsBoundByDefaultToAllLifecycles(String packaging) {
        return this.lifeCyclePluginAnalyzer.getPluginsBoundByDefaultToAllLifecycles(packaging);
    }

    @Deprecated
    public Map<String, Lifecycle> getPhaseToLifecycleMap() {
        return this.defaultLifeCycles.getPhaseToLifecycleMap();
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, boolean setup, String ... tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginManagerException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        List<TaskSegment> taskSegments = this.lifecycleTaskSegmentCalculator.calculateTaskSegments(session, Arrays.asList(tasks));
        TaskSegment mergedSegment = new TaskSegment(false);
        for (TaskSegment taskSegment : taskSegments) {
            mergedSegment.getTasks().addAll(taskSegment.getTasks());
        }
        return this.lifecycleExecutionPlanCalculator.calculateExecutionPlan(session, session.getCurrentProject(), mergedSegment.getTasks(), setup);
    }

    @Override
    public MavenExecutionPlan calculateExecutionPlan(MavenSession session, String ... tasks) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, PluginManagerException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        return this.calculateExecutionPlan(session, true, tasks);
    }

    @Override
    public void calculateForkedExecutions(MojoExecution mojoExecution, MavenSession session) throws MojoNotFoundException, PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, NoPluginFoundForPrefixException, InvalidPluginDescriptorException, LifecyclePhaseNotFoundException, LifecycleNotFoundException, PluginVersionResolutionException {
        this.lifecycleExecutionPlanCalculator.calculateForkedExecutions(mojoExecution, session);
    }

    @Override
    public List<MavenProject> executeForkedExecutions(MojoExecution mojoExecution, MavenSession session) throws LifecycleExecutionException {
        return this.mojoExecutor.executeForkedExecutions(mojoExecution, session);
    }
}

