/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.HeaderAnnotation;
import org.apache.juneau.http.header.SerializedHeader;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.httppart.ResponsePartMeta;

public class ResponseHeaderArg
implements RestOpArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    final ResponsePartMeta meta;
    final String name;
    private final Type type;

    public static ResponseHeaderArg create(ParameterInfo paramInfo, AnnotationWorkList annotations) {
        if (paramInfo.getParameterType().is(Value.class) && AP.has(Header.class, paramInfo, new AnnotationTraversal[0])) {
            return new ResponseHeaderArg(paramInfo, annotations);
        }
        return null;
    }

    protected ResponseHeaderArg(ParameterInfo pi, AnnotationWorkList annotations) {
        Class c;
        this.name = HeaderAnnotation.findName(pi).orElseThrow(() -> new ArgException(pi, "@Header used without name or value", new Object[0]));
        this.type = pi.getParameterType().innerType();
        HttpPartSchema schema = HttpPartSchema.create(Header.class, pi);
        Class<? extends HttpPartSerializer> ps = schema.getSerializer();
        this.meta = new ResponsePartMeta(HttpPartType.HEADER, schema, Utils.nn(ps) ? (HttpPartSerializer)HttpPartSerializer.creator().type((Class)ps).apply(annotations).create() : null);
        Class clazz = this.type instanceof Class ? (Class)this.type : (c = this.type instanceof ParameterizedType ? (Class)((ParameterizedType)this.type).getRawType() : null);
        if (c != Value.class) {
            throw new ArgException(pi, "Type must be Value<?> on parameter annotated with @Header annotation", new Object[0]);
        }
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        Value<Object> v = new Value<Object>();
        v.listener(o -> {
            RestRequest req = opSession.getRequest();
            RestResponse res = opSession.getResponse();
            ResponsePartMeta rpm = req.getOpContext().getResponseHeaderMeta(o);
            if (rpm == null) {
                rpm = this.meta;
            }
            HttpPartSerializerSession pss = rpm.getSerializer() == null ? req.getPartSerializerSession() : rpm.getSerializer().getPartSession();
            res.setHeader(new SerializedHeader(this.name, o, pss, rpm.getSchema(), false));
        });
        return v;
    }
}

