/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.context.TermDefinition;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.CompactUri;
import com.apicatalog.jsonld.lang.DirectionType;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.uri.UriUtils;
import com.apicatalog.jsonld.uri.UriValidationPolicy;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TermDefinitionBuilder {
    private static final Logger LOGGER = Logger.getLogger(TermDefinitionBuilder.class.getName());
    private static final Collection<String> CONTAINER_KEYWORDS = Arrays.asList("@graph", "@id", "@index", "@language", "@list", "@set", "@type");
    private static final Collection<String> PROTECTED_KEYWORDS = Arrays.asList("@id", "@reverse", "@container", "@context", "@direction", "@index", "@language", "@nest", "@prefix", "@protected", "@type");
    private final ActiveContext activeContext;
    private final JsonObject localContext;
    private final Map<String, Boolean> defined;
    private URI baseUrl;
    private boolean protectedFlag;
    private boolean overrideProtectedFlag;
    private Collection<String> remoteContexts;

    private TermDefinitionBuilder(ActiveContext activeContext, JsonObject localContext, Map<String, Boolean> defined) {
        this.activeContext = activeContext;
        this.localContext = localContext;
        this.defined = defined;
        this.baseUrl = null;
        this.protectedFlag = false;
        this.overrideProtectedFlag = false;
        this.remoteContexts = new ArrayList<String>();
    }

    public static final TermDefinitionBuilder with(ActiveContext activeContext, JsonObject localContext, Map<String, Boolean> defined) {
        return new TermDefinitionBuilder(activeContext, localContext, defined);
    }

    public TermDefinitionBuilder baseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public TermDefinitionBuilder protectedFlag(boolean protectedFlag) {
        this.protectedFlag = protectedFlag;
        return this;
    }

    public TermDefinitionBuilder overrideProtectedFlag(boolean overrideProtectedFlag) {
        this.overrideProtectedFlag = overrideProtectedFlag;
        return this;
    }

    public TermDefinitionBuilder remoteContexts(Collection<String> remoteContexts) {
        this.remoteContexts = remoteContexts;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void create(String term) throws JsonLdError {
        boolean simpleTerm;
        JsonValue idValue;
        JsonObject valueObject;
        if (StringUtils.isBlank(term)) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
        }
        if (this.defined.containsKey(term)) {
            if (!Boolean.TRUE.equals(this.defined.get(term))) throw new JsonLdError(JsonLdErrorCode.CYCLIC_IRI_MAPPING);
            return;
        }
        this.defined.put(term, Boolean.FALSE);
        JsonValue value = (JsonValue)this.localContext.get((Object)term);
        if ("@type".equals(term)) {
            JsonValue containerValue;
            JsonValue container;
            if (this.activeContext.runtime().isV10()) {
                throw new JsonLdError(JsonLdErrorCode.KEYWORD_REDEFINITION);
            }
            if (!JsonUtils.isObject(value)) throw new JsonLdError(JsonLdErrorCode.KEYWORD_REDEFINITION);
            JsonObject map = value.asJsonObject();
            if (map.size() == 1 && map.containsKey((Object)"@container") ? JsonUtils.isNotString(container = (JsonValue)map.get((Object)"@container")) || !"@set".equals(((JsonString)container).getString()) : (map.size() == 2 && map.containsKey((Object)"@container") && map.containsKey((Object)"@protected") ? !JsonUtils.contains("@set", containerValue = (JsonValue)map.get((Object)"@container")) : map.size() != 1 || !map.containsKey((Object)"@protected"))) {
                throw new JsonLdError(JsonLdErrorCode.KEYWORD_REDEFINITION);
            }
        } else {
            if (Keywords.contains(term)) {
                throw new JsonLdError(JsonLdErrorCode.KEYWORD_REDEFINITION, "A keyword [" + term + "] redefinition has been detected.");
            }
            if (Keywords.matchForm(term)) {
                LOGGER.log(Level.WARNING, "Term [{0}] has form of a keyword. Keywords cannot be overridden.", term);
                return;
            }
        }
        TermDefinition previousDefinition = this.activeContext.removeTerm(term).orElse(null);
        if (JsonUtils.isNull(value)) {
            valueObject = Collections.emptyMap();
            idValue = JsonValue.NULL;
            simpleTerm = false;
        } else if (JsonUtils.isString(value)) {
            valueObject = Collections.emptyMap();
            idValue = value;
            simpleTerm = true;
        } else {
            if (!JsonUtils.isObject(value)) throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            valueObject = value.asJsonObject();
            idValue = (JsonValue)valueObject.get("@id");
            simpleTerm = false;
        }
        TermDefinition definition = new TermDefinition(false, this.protectedFlag, false);
        if (valueObject.containsKey("@protected")) {
            if (this.activeContext.runtime().isV10()) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            }
            JsonValue protectedValue = (JsonValue)valueObject.get("@protected");
            if (JsonUtils.isNotBoolean(protectedValue)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_PROTECTED_VALUE);
            }
            definition.setProtected(JsonUtils.isTrue(protectedValue));
        }
        if (valueObject.containsKey("@type")) {
            JsonValue type = (JsonValue)valueObject.get("@type");
            if (JsonUtils.isNotString(type)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TYPE_MAPPING);
            }
            String expandedTypeString = this.activeContext.uriExpansion().localContext(this.localContext).defined(this.defined).vocab(true).expand(((JsonString)type).getString());
            if (expandedTypeString == null) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TYPE_MAPPING);
            }
            if (("@json".equals(expandedTypeString) || "@none".equals(expandedTypeString)) && this.activeContext.runtime().isV10() || Keywords.noneMatch(expandedTypeString, "@id", "@json", "@none", "@vocab") && UriUtils.isNotAbsoluteUri(expandedTypeString, UriValidationPolicy.Full)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TYPE_MAPPING);
            }
            definition.setTypeMapping(expandedTypeString);
        }
        if (valueObject.containsKey("@reverse")) {
            if (valueObject.containsKey("@id") || valueObject.containsKey("@nest")) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY);
            }
            JsonValue reverse = (JsonValue)valueObject.get("@reverse");
            if (JsonUtils.isNotString(reverse)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_IRI_MAPPING);
            }
            String reverseString = ((JsonString)reverse).getString();
            if (Keywords.matchForm(reverseString)) {
                LOGGER.log(Level.WARNING, "The value [{0}] associated with @reverse cannot have form of a keyword.", reverseString);
                return;
            }
            definition.setUriMapping(this.activeContext.uriExpansion().localContext(this.localContext).defined(this.defined).vocab(true).expand(reverseString));
            if (UriUtils.isNotURI(definition.getUriMapping())) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_IRI_MAPPING);
            }
            if (valueObject.containsKey("@container")) {
                JsonValue container = (JsonValue)valueObject.get("@container");
                if (JsonUtils.isNotString(container) && JsonUtils.isNotNull(container)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY);
                }
                if (JsonUtils.isString(container)) {
                    String containerString = ((JsonString)container).getString();
                    if (!"@set".equals(containerString) && !"@index".equals(containerString)) throw new JsonLdError(JsonLdErrorCode.INVALID_REVERSE_PROPERTY);
                    definition.addContainerMapping(containerString);
                }
            }
            definition.setReverseProperty(true);
            this.activeContext.setTerm(term, definition);
            this.defined.put(term, Boolean.TRUE);
        } else if (idValue != null && (JsonUtils.isNotString(idValue) || !term.equals(((JsonString)idValue).getString()))) {
            if (JsonUtils.isNotNull(idValue)) {
                if (JsonUtils.isNotString(idValue)) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_IRI_MAPPING);
                }
                String idValueString = ((JsonString)idValue).getString();
                if (!Keywords.contains(idValueString) && Keywords.matchForm(idValueString)) {
                    LOGGER.log(Level.WARNING, "The value [{0}] associated with @id has form of a keyword but is not keyword.", idValueString);
                    return;
                }
                definition.setUriMapping(this.activeContext.uriExpansion().localContext(this.localContext).defined(this.defined).vocab(true).expand(idValueString));
                if ("@context".equals(definition.getUriMapping())) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_ALIAS);
                }
                if (!Keywords.contains(definition.getUriMapping()) && UriUtils.isNotURI(definition.getUriMapping()) && !BlankNode.hasPrefix(definition.getUriMapping())) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_IRI_MAPPING);
                }
                if (term.substring(0, term.length() - 1).indexOf(58, 1) != -1 || term.contains("/")) {
                    this.defined.put(term, Boolean.TRUE);
                    String expandedTerm = this.activeContext.uriExpansion().localContext(this.localContext).defined(this.defined).vocab(true).expand(term);
                    if (expandedTerm == null || !expandedTerm.equals(definition.getUriMapping())) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_IRI_MAPPING);
                    }
                }
                if (definition.isNotPrefix()) {
                    definition.setPrefix(!term.contains(":") && !term.contains("/") && simpleTerm && definition.getUriMapping() != null && (UriUtils.endsWithGenDelim(definition.getUriMapping()) && UriUtils.isURI(definition.getUriMapping().substring(0, definition.getUriMapping().length() - 1)) || BlankNode.hasPrefix(definition.getUriMapping())));
                }
            }
        } else if (term.indexOf(58, 1) != -1) {
            CompactUri compactUri = CompactUri.create(term);
            if (compactUri != null && compactUri.isNotBlank() && this.localContext.containsKey((Object)compactUri.getPrefix())) {
                this.activeContext.newTerm(this.localContext, this.defined).create(compactUri.getPrefix());
            }
            if (compactUri != null && compactUri.isNotBlank() && this.activeContext.containsTerm(compactUri.getPrefix())) {
                definition.setUriMapping(this.activeContext.getTerm(compactUri.getPrefix()).map(TermDefinition::getUriMapping).map(u -> u.concat(compactUri.getSuffix())).orElse(null));
            } else if (UriUtils.isURI(term) || BlankNode.hasPrefix(term)) {
                definition.setUriMapping(term);
            }
        } else if (term.contains("/")) {
            definition.setUriMapping(this.activeContext.uriExpansion().localContext(this.localContext).defined(this.defined).vocab(true).expand(term));
            if (UriUtils.isNotURI(definition.getUriMapping())) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_IRI_MAPPING);
            }
        } else if ("@type".equals(term)) {
            definition.setUriMapping("@type");
        } else {
            if (this.activeContext.getVocabularyMapping() == null) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_IRI_MAPPING);
            }
            definition.setUriMapping(this.activeContext.getVocabularyMapping().concat(term));
        }
        if (valueObject.containsKey("@container")) {
            JsonValue containerValue = (JsonValue)valueObject.get("@container");
            if (!this.validateContainer(containerValue)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_CONTAINER_MAPPING);
            }
            JsonUtils.toStream(containerValue).filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).forEach(definition::addContainerMapping);
            if (definition.getContainerMapping().contains("@type")) {
                if (definition.getTypeMapping() == null) {
                    definition.setTypeMapping("@id");
                }
                if (!"@id".equals(definition.getTypeMapping()) && !"@vocab".equals(definition.getTypeMapping())) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_TYPE_MAPPING);
                }
            }
        }
        if (valueObject.containsKey("@index")) {
            if (this.activeContext.runtime().isV10() || !definition.getContainerMapping().contains("@index")) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            }
            JsonValue index = (JsonValue)valueObject.get("@index");
            if (JsonUtils.isNotString(index)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            }
            String indexString = ((JsonString)index).getString();
            String expandedIndex = this.activeContext.uriExpansion().localContext(this.localContext).defined(this.defined).vocab(true).expand(indexString);
            if (expandedIndex == null || UriUtils.isNotURI(expandedIndex)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            }
            definition.setIndexMapping(indexString);
        }
        if (valueObject.containsKey("@context")) {
            if (this.activeContext.runtime().isV10()) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            }
            JsonValue context = (JsonValue)valueObject.get("@context");
            try {
                this.activeContext.newContext().overrideProtected(true).remoteContexts(new ArrayList<String>(this.remoteContexts)).validateScopedContext(false).create(context, this.baseUrl);
            }
            catch (JsonLdError e) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_SCOPED_CONTEXT, (Throwable)e);
            }
            definition.setLocalContext(context);
            definition.setBaseUrl(this.baseUrl);
        }
        if (valueObject.containsKey("@language") && !valueObject.containsKey("@type")) {
            JsonValue language = (JsonValue)valueObject.get("@language");
            if (!JsonUtils.isNull(language) && !JsonUtils.isString(language)) throw new JsonLdError(JsonLdErrorCode.INVALID_LANGUAGE_MAPPING);
            if (JsonUtils.isString(language) && !LanguageTag.isWellFormed(((JsonString)language).getString())) {
                LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", ((JsonString)language).getString());
            }
            definition.setLanguageMapping(language);
        }
        if (valueObject.containsKey("@direction") && !valueObject.containsKey("@type")) {
            JsonValue direction = (JsonValue)valueObject.get("@direction");
            if (JsonUtils.isNull(direction)) {
                definition.setDirectionMapping(DirectionType.NULL);
            } else {
                if (!JsonUtils.isString(direction)) throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                String directionString = ((JsonString)direction).getString();
                if ("ltr".equals(directionString)) {
                    definition.setDirectionMapping(DirectionType.LTR);
                } else {
                    if (!"rtl".equals(directionString)) throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                    definition.setDirectionMapping(DirectionType.RTL);
                }
            }
        }
        if (valueObject.containsKey("@nest")) {
            if (this.activeContext.runtime().isV10()) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            }
            JsonValue nest = (JsonValue)valueObject.get("@nest");
            if (JsonUtils.isNotString(nest)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_NEST_VALUE);
            }
            String nestString = ((JsonString)nest).getString();
            if (Keywords.contains(nestString) && !"@nest".equals(nestString)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_NEST_VALUE);
            }
            definition.setNestValue(nestString);
        }
        if (valueObject.containsKey("@prefix")) {
            if (this.activeContext.runtime().isV10() || term.contains(":") || term.contains("/")) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            }
            JsonValue prefix = (JsonValue)valueObject.get("@prefix");
            if (JsonUtils.isTrue(prefix)) {
                definition.setPrefix(true);
            } else {
                if (!JsonUtils.isFalse(prefix)) throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_PREFIX_VALUE);
                definition.setPrefix(false);
            }
            if (definition.isPrefix() && Keywords.contains(definition.getUriMapping())) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
            }
        }
        if (!PROTECTED_KEYWORDS.containsAll(valueObject.keySet())) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_TERM_DEFINITION);
        }
        if (!this.overrideProtectedFlag && previousDefinition != null && previousDefinition.isProtected()) {
            if (definition.isNotSameExcept(previousDefinition)) {
                throw new JsonLdError(JsonLdErrorCode.PROTECTED_TERM_REDEFINITION);
            }
            this.activeContext.setTerm(term, previousDefinition);
        } else {
            this.activeContext.setTerm(term, definition);
        }
        this.defined.put(term, Boolean.TRUE);
    }

    private final boolean validateContainer(JsonValue value) {
        JsonValue container = value;
        if (JsonUtils.isNull(container)) {
            return false;
        }
        if (this.activeContext.runtime().isV10()) {
            return JsonUtils.isString(container) && Keywords.noneMatch(((JsonString)container).getString(), "@graph", "@id", "@type");
        }
        if (JsonUtils.isArray(container) && container.asJsonArray().size() == 1) {
            container = (JsonValue)container.asJsonArray().get(0);
        }
        if (JsonUtils.isString(container)) {
            return CONTAINER_KEYWORDS.contains(((JsonString)container).getString());
        }
        return JsonUtils.isArray(container) && TermDefinitionBuilder.validateContainerArray(container.asJsonArray());
    }

    private static final boolean validateContainerArray(JsonArray containers) {
        if (containers.size() > 3) {
            return false;
        }
        if (JsonUtils.contains("@graph", (JsonValue)containers) && (JsonUtils.contains("@id", (JsonValue)containers) || JsonUtils.contains("@index", (JsonValue)containers))) {
            return containers.size() == 2 || JsonUtils.contains("@set", (JsonValue)containers);
        }
        return containers.size() == 2 && JsonUtils.contains("@set", (JsonValue)containers) && (JsonUtils.contains("@graph", (JsonValue)containers) || JsonUtils.contains("@id", (JsonValue)containers) || JsonUtils.contains("@index", (JsonValue)containers) || JsonUtils.contains("@language", (JsonValue)containers) || JsonUtils.contains("@type", (JsonValue)containers));
    }
}

