/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionManager;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersioningLock;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VersionManagerImplBase {
    private static final Logger log = LoggerFactory.getLogger(VersionManagerImplBase.class);
    protected final SessionContext context;
    protected final SessionImpl session;
    protected final UpdatableItemStateManager stateMgr;
    protected final HierarchyManager hierMgr;
    protected final NodeTypeRegistry ntReg;
    protected final InternalVersionManager vMgr;
    private final VersioningLock rwLock = new VersioningLock();
    protected NodeId currentActivity;

    protected VersionManagerImplBase(SessionContext context, UpdatableItemStateManager stateMgr, HierarchyManager hierMgr) {
        this.context = context;
        this.session = context.getSessionImpl();
        this.stateMgr = stateMgr;
        this.hierMgr = hierMgr;
        this.ntReg = this.session.getNodeTypeManager().getNodeTypeRegistry();
        this.vMgr = this.session.getInternalVersionManager();
    }

    protected NodeId checkoutCheckin(NodeStateEx state, boolean checkin, boolean checkout, Calendar created) throws RepositoryException {
        assert (checkin || checkout);
        boolean isFull = this.checkVersionable(state);
        if (this.isCheckedOut(state)) {
            if (checkout && !checkin) {
                String msg = this.safeGetJCRPath(state) + ": Node is already checked-out. ignoring.";
                log.debug(msg);
                return null;
            }
        } else {
            if (!checkout) {
                String msg = this.safeGetJCRPath(state) + ": Node is already checked-in. ignoring.";
                log.debug(msg);
                if (isFull) {
                    return this.getBaseVersionId(state);
                }
                return this.vMgr.getHeadVersionOfNode(state.getNodeId()).getId();
            }
            checkin = false;
        }
        NodeId baseId = isFull && checkout ? this.vMgr.canCheckout(state, this.currentActivity) : null;
        try (WriteOperation ops = this.startWriteOperation();){
            Object v;
            if (checkin) {
                if (state.getEffectiveNodeType().includesNodeType(NameConstants.NT_CONFIGURATION)) {
                    Set<NodeId> baseVersions = this.collectBaseVersions(state);
                    InternalValue[] vs = new InternalValue[baseVersions.size()];
                    int i = 0;
                    for (NodeId id : baseVersions) {
                        vs[i++] = InternalValue.create(id);
                    }
                    state.setPropertyValues(NameConstants.REP_VERSIONS, 9, vs);
                    state.store();
                }
                v = this.vMgr.checkin(this.session, state, created);
                baseId = v.getId();
                if (isFull) {
                    state.setPropertyValue(NameConstants.JCR_BASEVERSION, InternalValue.create(baseId));
                    state.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, InternalValue.EMPTY_ARRAY);
                    state.removeProperty(NameConstants.JCR_ACTIVITY);
                }
            }
            if (checkout && isFull) {
                state.setPropertyValues(NameConstants.JCR_PREDECESSORS, 9, new InternalValue[]{InternalValue.create(baseId)});
                if (this.currentActivity != null) {
                    state.setPropertyValue(NameConstants.JCR_ACTIVITY, InternalValue.create(this.currentActivity));
                }
            }
            state.setPropertyValue(NameConstants.JCR_ISCHECKEDOUT, InternalValue.create(checkout));
            state.store();
            ops.save();
            v = baseId;
            return v;
        }
    }

    private Set<NodeId> collectBaseVersions(NodeStateEx config) throws RepositoryException {
        NodeId rootId = config.getPropertyValue(NameConstants.JCR_ROOT).getNodeId();
        NodeStateEx root = this.getNodeStateEx(rootId);
        if (root == null) {
            String msg = "Configuration root node for " + this.safeGetJCRPath(config) + " not found.";
            log.error(msg);
            throw new ItemNotFoundException(msg);
        }
        HashSet<NodeId> baseVersions = new HashSet<NodeId>();
        this.collectBaseVersions(root, baseVersions);
        return baseVersions;
    }

    private void collectBaseVersions(NodeStateEx root, Set<NodeId> baseVersions) throws RepositoryException {
        if (!baseVersions.isEmpty() && root.hasProperty(NameConstants.JCR_CONFIGURATION) && root.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE)) {
            return;
        }
        InternalVersion baseVersion = this.getBaseVersion(root);
        if (baseVersion.isRootVersion()) {
            String msg = "Unable to checkin configuration as it has unversioned child node: " + this.safeGetJCRPath(root);
            log.debug(msg);
            throw new UnsupportedRepositoryOperationException(msg);
        }
        baseVersions.add(baseVersion.getId());
        for (NodeStateEx child : root.getChildNodes()) {
            this.collectBaseVersions(child, baseVersions);
        }
    }

    protected boolean checkVersionable(NodeStateEx state) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (state.getEffectiveNodeType().includesNodeType(NameConstants.MIX_VERSIONABLE)) {
            return true;
        }
        if (state.getEffectiveNodeType().includesNodeType(NameConstants.MIX_SIMPLE_VERSIONABLE)) {
            return false;
        }
        String msg = "Unable to perform a versioning operation on a non versionable node: " + this.safeGetJCRPath(state);
        log.debug(msg);
        throw new UnsupportedRepositoryOperationException(msg);
    }

    protected String safeGetJCRPath(NodeStateEx state) {
        Path path;
        try {
            path = this.hierMgr.getPath(state.getNodeId());
        }
        catch (RepositoryException e) {
            log.warn("unable to calculate path for {}", (Object)state.getNodeId());
            return state.getNodeId().toString();
        }
        try {
            return this.session.getJCRPath(path);
        }
        catch (NamespaceException e) {
            log.warn("unable to calculate path for {}", (Object)path);
            return path.toString();
        }
    }

    protected boolean isCheckedOut(NodeStateEx state) throws RepositoryException {
        return state.getPropertyValue(NameConstants.JCR_ISCHECKEDOUT).getBoolean();
    }

    protected NodeId getBaseVersionId(NodeStateEx state) {
        InternalValue value = state.getPropertyValue(NameConstants.JCR_BASEVERSION);
        return value == null ? null : value.getNodeId();
    }

    protected InternalVersionHistory getVersionHistory(NodeStateEx state) throws RepositoryException {
        boolean isFull = this.checkVersionable(state);
        if (isFull) {
            NodeId id = state.getPropertyValue(NameConstants.JCR_VERSIONHISTORY).getNodeId();
            return this.vMgr.getVersionHistory(id);
        }
        return this.vMgr.getVersionHistoryOfNode(state.getNodeId());
    }

    protected InternalVersion getVersion(Version v) throws RepositoryException {
        if (v == null) {
            return null;
        }
        return this.vMgr.getVersion(((VersionImpl)v).getNodeId());
    }

    protected InternalVersion getBaseVersion(NodeStateEx state) throws RepositoryException {
        boolean isFull = this.checkVersionable(state);
        if (isFull) {
            NodeId id = this.getBaseVersionId(state);
            return this.vMgr.getVersion(id);
        }
        return this.vMgr.getHeadVersionOfNode(state.getNodeId());
    }

    protected NodeStateEx getNodeStateEx(NodeId nodeId) throws RepositoryException {
        if (!this.stateMgr.hasItemState(nodeId)) {
            return null;
        }
        try {
            return new NodeStateEx(this.stateMgr, this.ntReg, (NodeState)this.stateMgr.getItemState(nodeId), null);
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    protected void checkModify(NodeStateEx state, int options, int permissions) throws RepositoryException {
        NodeImpl node;
        try {
            node = this.session.getNodeById(state.getNodeId());
        }
        catch (RepositoryException e) {
            return;
        }
        this.context.getItemValidator().checkModify(node, options, permissions);
    }

    protected void checkModify(NodeImpl node, int options, int permissions) throws RepositoryException {
        this.context.getItemValidator().checkModify(node, options, permissions);
    }

    protected VersioningLock.WriteLock acquireWriteLock() {
        while (true) {
            try {
                return this.rwLock.acquireWriteLock();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected VersioningLock.ReadLock acquireReadLock() {
        while (true) {
            try {
                return this.rwLock.acquireReadLock();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public WriteOperation startWriteOperation() throws RepositoryException {
        boolean success = false;
        VersioningLock.WriteLock lock = this.acquireWriteLock();
        try {
            this.stateMgr.edit();
            success = true;
            WriteOperation writeOperation = new WriteOperation(lock);
            return writeOperation;
        }
        catch (IllegalStateException e) {
            String msg = "Unable to start edit operation.";
            throw new RepositoryException(msg, e);
        }
        finally {
            if (!success) {
                lock.release();
            }
        }
    }

    public class WriteOperation {
        private boolean success = false;
        private final VersioningLock.WriteLock lock;

        public WriteOperation(VersioningLock.WriteLock lock) {
            this.lock = lock;
        }

        public void save() throws ItemStateException, RepositoryException {
            VersionManagerImplBase.this.stateMgr.update();
            this.success = true;
        }

        public void close() {
            try {
                if (!this.success) {
                    VersionManagerImplBase.this.stateMgr.cancel();
                }
            }
            finally {
                this.lock.release();
            }
        }
    }
}

