/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.match.model;

import java.nio.ByteBuffer;

public class DTWMatchResult {
    private final float dtwValue;
    private final long startTime;
    private final long endTime;
    public static final int BYTES = 20;

    public DTWMatchResult(float dtwValue, long startTime, long endTime) {
        this.dtwValue = dtwValue;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public String toString() {
        return String.format("{\"distance\":%f,\"startTime\":%d,\"endTime\":%d}", Float.valueOf(this.dtwValue), this.startTime, this.endTime);
    }

    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.putFloat(this.dtwValue);
        buffer.putLong(this.startTime);
        buffer.putLong(this.endTime);
        return buffer.array();
    }

    public static DTWMatchResult fromByteArray(byte[] byteArray) {
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        return new DTWMatchResult(buffer.getFloat(), buffer.getLong(), buffer.getLong());
    }
}

