/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Insert;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class IntoNode
extends SingleChildProcessNode {
    private final String database;
    private final String table;
    private final List<ColumnSchema> columns;
    private final List<Symbol> neededInputColumnNames;
    private final Symbol rowCountSymbol;

    public IntoNode(PlanNodeId id, PlanNode child, String database, String table, List<ColumnSchema> columns, List<Symbol> neededInputColumnNames, Symbol rowCountSymbol) {
        super(id, child);
        this.database = database;
        this.table = table;
        this.columns = columns;
        this.neededInputColumnNames = neededInputColumnNames;
        if (columns.size() != neededInputColumnNames.size()) {
            throw new IllegalArgumentException("insert into table columns's size should be same as query result");
        }
        this.rowCountSymbol = rowCountSymbol;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitInto(this, context);
    }

    @Override
    public PlanNode clone() {
        return new IntoNode(this.id, null, this.database, this.table, this.columns, this.neededInputColumnNames, this.rowCountSymbol);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ImmutableList.of((Object)this.rowCountSymbol.getName());
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.of((Object)this.rowCountSymbol);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.INTO.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.database, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.table, (ByteBuffer)byteBuffer);
        Symbol.serialize(this.rowCountSymbol, byteBuffer);
        ReadWriteIOUtils.write((int)this.columns.size(), (ByteBuffer)byteBuffer);
        for (ColumnSchema tableColumn : this.columns) {
            ColumnSchema.serialize(tableColumn, byteBuffer);
        }
        for (Symbol column : this.neededInputColumnNames) {
            Symbol.serialize(column, byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_INTO_NODE.serialize(stream);
        ReadWriteIOUtils.write((String)this.database, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.table, (OutputStream)stream);
        Symbol.serialize(this.rowCountSymbol, stream);
        ReadWriteIOUtils.write((int)this.columns.size(), (OutputStream)stream);
        for (ColumnSchema tableColumn : this.columns) {
            ColumnSchema.serialize(tableColumn, stream);
        }
        for (Symbol column : this.neededInputColumnNames) {
            Symbol.serialize(column, stream);
        }
    }

    public static IntoNode deserialize(ByteBuffer byteBuffer) {
        String database = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        String table = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        Symbol rowCountSymbol = Symbol.deserialize(byteBuffer);
        int columnSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(columnSize);
        for (int i = 0; i < columnSize; ++i) {
            columns.add(ColumnSchema.deserialize(byteBuffer));
        }
        ArrayList<Symbol> neededInputColumnNames = new ArrayList<Symbol>(columnSize);
        for (int i = 0; i < columnSize; ++i) {
            neededInputColumnNames.add(Symbol.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new IntoNode(planNodeId, null, database, table, columns, neededInputColumnNames, rowCountSymbol);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new IntoNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.database, this.table, this.columns, this.neededInputColumnNames, this.rowCountSymbol);
    }

    public String toString() {
        return "IntoNode-" + this.getPlanNodeId();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntoNode that = (IntoNode)o;
        return this.database.equals(that.database) && this.table.equals(that.table) && this.rowCountSymbol.equals(that.rowCountSymbol) && Objects.deepEquals(this.columns, that.columns) && Objects.deepEquals(this.neededInputColumnNames, that.neededInputColumnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.database, this.table, this.rowCountSymbol, this.columns, this.neededInputColumnNames);
    }

    public List<Type> getOutputType() {
        return ImmutableList.of((Object)Insert.ROWS_TYPE);
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public List<ColumnSchema> getColumns() {
        return this.columns;
    }

    public List<Symbol> getNeededInputColumnNames() {
        return this.neededInputColumnNames;
    }

    public Symbol getRowCountSymbol() {
        return this.rowCountSymbol;
    }
}

