/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.metric.schema;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.pipe.source.IoTDBNonDataRegionSource;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.pipe.source.schemaregion.IoTDBSchemaRegionSource;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeSchemaRegionSourceMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeSchemaRegionSourceMetrics.class);
    private volatile AbstractMetricService metricService;
    private final Map<String, IoTDBSchemaRegionSource> extractorMap = new ConcurrentHashMap<String, IoTDBSchemaRegionSource>();

    public void bindTo(AbstractMetricService metricService) {
        this.metricService = metricService;
        ImmutableSet.copyOf(this.extractorMap.keySet()).forEach(this::createMetrics);
    }

    private void createMetrics(String taskID) {
        this.createAutoGauge(taskID);
    }

    private void createAutoGauge(String taskID) {
        IoTDBSchemaRegionSource extractor = this.extractorMap.get(taskID);
        this.metricService.createAutoGauge(Metric.UNTRANSFERRED_SCHEMA_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this.extractorMap.get(taskID), IoTDBNonDataRegionSource::getUnTransferredEventCount, new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        ImmutableSet.copyOf(this.extractorMap.keySet()).forEach(this::deregister);
        if (!this.extractorMap.isEmpty()) {
            LOGGER.warn("Failed to unbind from pipe schema region extractor metrics, extractor map not empty");
        }
    }

    private void removeMetrics(String taskID) {
        this.removeAutoGauge(taskID);
    }

    private void removeAutoGauge(String taskID) {
        IoTDBSchemaRegionSource extractor = this.extractorMap.get(taskID);
        this.metricService.remove(MetricType.AUTO_GAUGE, Metric.UNTRANSFERRED_SCHEMA_COUNT.toString(), new String[]{Tag.NAME.toString(), extractor.getPipeName(), Tag.REGION.toString(), String.valueOf(extractor.getRegionId()), Tag.CREATION_TIME.toString(), String.valueOf(extractor.getCreationTime())});
    }

    public void register(@NonNull IoTDBSchemaRegionSource extractor) {
        String taskID = extractor.getTaskID();
        this.extractorMap.putIfAbsent(taskID, extractor);
        if (Objects.nonNull(this.metricService)) {
            this.createMetrics(taskID);
        }
    }

    public void deregister(String taskID) {
        if (!this.extractorMap.containsKey(taskID)) {
            LOGGER.warn("Failed to deregister pipe schema region extractor metrics, IoTDBSchemaRegionExtractor({}) does not exist", (Object)taskID);
            return;
        }
        if (Objects.nonNull(this.metricService)) {
            this.removeMetrics(taskID);
        }
        this.extractorMap.remove(taskID);
    }

    public static PipeSchemaRegionSourceMetrics getInstance() {
        return PipeSchemaRegionSourceMetricsHolder.INSTANCE;
    }

    private PipeSchemaRegionSourceMetrics() {
    }

    private static class PipeSchemaRegionSourceMetricsHolder {
        private static final PipeSchemaRegionSourceMetrics INSTANCE = new PipeSchemaRegionSourceMetrics();

        private PipeSchemaRegionSourceMetricsHolder() {
        }
    }
}

