/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection;

import jakarta.annotation.Nonnull;
import java.util.Arrays;

public enum AuthenticationType {
    NULL_TYPE(0),
    OAUTH(1),
    BEARER(2),
    IMPLICIT(3),
    SIGV4(4);

    private static final AuthenticationType[] REVERSE_MAPPING_ARRAY;
    private final int code;

    private AuthenticationType(int code) {
        this.code = code;
    }

    @Nonnull
    public static AuthenticationType fromCode(int authTypeCode) {
        if (authTypeCode < 0 || authTypeCode >= REVERSE_MAPPING_ARRAY.length) {
            return NULL_TYPE;
        }
        return REVERSE_MAPPING_ARRAY[authTypeCode];
    }

    public int getCode() {
        return this.code;
    }

    static {
        int maxCode = Arrays.stream(AuthenticationType.values()).mapToInt(AuthenticationType::getCode).max().orElse(0);
        REVERSE_MAPPING_ARRAY = new AuthenticationType[maxCode + 1];
        AuthenticationType[] authenticationTypeArray = AuthenticationType.values();
        int n = authenticationTypeArray.length;
        for (int i = 0; i < n; ++i) {
            AuthenticationType authType;
            AuthenticationType.REVERSE_MAPPING_ARRAY[authType.code] = authType = authenticationTypeArray[i];
        }
    }
}

