/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime;

import io.quarkus.oidc.AuthorizationCodeTokens;
import io.quarkus.oidc.OidcRequestContext;
import io.quarkus.oidc.OidcTenantConfig;
import io.quarkus.oidc.TokenStateManager;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.runtime.CodeAuthenticationMechanism;
import io.quarkus.oidc.runtime.OidcTenantConfig;
import io.quarkus.oidc.runtime.OidcUtils;
import io.quarkus.oidc.runtime.TenantConfigContext;
import io.quarkus.security.AuthenticationFailedException;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.mutiny.Uni;
import io.vertx.core.http.impl.ServerCookie;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

@ApplicationScoped
public class DefaultTokenStateManager
implements TokenStateManager {
    private static final Logger LOG = Logger.getLogger(DefaultTokenStateManager.class);

    @Override
    public Uni<String> createTokenState(RoutingContext routingContext, OidcTenantConfig oidcConfig, AuthorizationCodeTokens tokens, OidcRequestContext<String> requestContext) {
        if (!oidcConfig.tokenStateManager().splitTokens()) {
            StringBuilder sb = new StringBuilder();
            sb.append(tokens.getIdToken());
            if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
                sb.append("|").append(tokens.getAccessToken()).append("|").append(tokens.getAccessTokenExpiresIn() != null ? tokens.getAccessTokenExpiresIn() : "").append("|").append(tokens.getAccessTokenScope() != null ? DefaultTokenStateManager.encodeScopes(oidcConfig, tokens.getAccessTokenScope()) : "").append("|").append(tokens.getRefreshToken());
            } else if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS) {
                sb.append("|").append("").append("|").append("").append("|").append("").append("|").append(tokens.getRefreshToken());
            }
            String encryptedTokens = DefaultTokenStateManager.encryptToken(sb.toString(), routingContext, oidcConfig);
            return Uni.createFrom().item((Object)encryptedTokens);
        }
        String encryptedIdToken = DefaultTokenStateManager.encryptToken(tokens.getIdToken(), routingContext, oidcConfig);
        if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            DefaultTokenStateManager.createSessionAccessTokenCookie(routingContext, oidcConfig, tokens);
            if (tokens.getRefreshToken() != null) {
                OidcUtils.createSessionCookie(routingContext, oidcConfig, DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig), DefaultTokenStateManager.encryptToken(tokens.getRefreshToken(), routingContext, oidcConfig), (Long)routingContext.get("session-max-age"));
            }
        } else if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS && tokens.getRefreshToken() != null) {
            OidcUtils.createSessionCookie(routingContext, oidcConfig, DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig), DefaultTokenStateManager.encryptToken(tokens.getRefreshToken(), routingContext, oidcConfig), (Long)routingContext.get("session-max-age"));
        }
        return Uni.createFrom().item((Object)encryptedIdToken);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Uni<AuthorizationCodeTokens> getTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<AuthorizationCodeTokens> requestContext) {
        ServerCookie rtCookie;
        String idToken = null;
        String accessToken = null;
        Long accessTokenExpiresIn = null;
        String accessTokenScope = null;
        String refreshToken = null;
        if (!oidcConfig.tokenStateManager().splitTokens()) {
            String decryptedTokenState = DefaultTokenStateManager.decryptToken(tokenState, routingContext, oidcConfig);
            String[] tokens = CodeAuthenticationMechanism.COOKIE_PATTERN.split(decryptedTokenState);
            try {
                idToken = tokens[0];
                if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
                    accessToken = tokens[1];
                    accessTokenExpiresIn = tokens[2].isEmpty() ? null : DefaultTokenStateManager.parseAccessTokenExpiresIn(tokens[2]);
                    accessTokenScope = tokens[3].isEmpty() ? null : tokens[3];
                    refreshToken = tokens[4];
                    return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn, accessTokenScope));
                }
                if (oidcConfig.tokenStateManager().strategy() != OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS) return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn, accessTokenScope));
                refreshToken = tokens[4];
                return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn, accessTokenScope));
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                String error = "Session cookie is malformed";
                LOG.debug((Object)ex);
                return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Session cookie is malformed"));
            }
            catch (AuthenticationFailedException ex) {
                return Uni.createFrom().failure((Throwable)ex);
            }
        }
        idToken = DefaultTokenStateManager.decryptToken(tokenState, routingContext, oidcConfig);
        if (oidcConfig.tokenStateManager().strategy() == OidcTenantConfig.TokenStateManager.Strategy.KEEP_ALL_TOKENS) {
            ServerCookie rtCookie2;
            String atCookieValue = DefaultTokenStateManager.getAccessTokenCookie(routingContext, oidcConfig);
            if (atCookieValue != null) {
                String accessTokenState = DefaultTokenStateManager.decryptToken(atCookieValue, routingContext, oidcConfig);
                String[] accessTokenData = CodeAuthenticationMechanism.COOKIE_PATTERN.split(accessTokenState);
                accessToken = accessTokenData[0];
                try {
                    Long l = accessTokenExpiresIn = accessTokenData[1].isEmpty() ? null : DefaultTokenStateManager.parseAccessTokenExpiresIn(accessTokenData[1]);
                    if (accessTokenData.length == 3) {
                        accessTokenScope = accessTokenData[2].isEmpty() ? null : DefaultTokenStateManager.decodeScopes(oidcConfig, accessTokenData[2]);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    String error = "Session cookie is malformed";
                    LOG.debug((Object)ex);
                    return Uni.createFrom().failure((Throwable)new AuthenticationFailedException("Session cookie is malformed"));
                }
                catch (AuthenticationFailedException ex) {
                    return Uni.createFrom().failure((Throwable)ex);
                }
            }
            if ((rtCookie2 = DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig)) == null) return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn, accessTokenScope));
            refreshToken = DefaultTokenStateManager.decryptToken(rtCookie2.getValue(), routingContext, oidcConfig);
            return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn, accessTokenScope));
        }
        if (oidcConfig.tokenStateManager().strategy() != OidcTenantConfig.TokenStateManager.Strategy.ID_REFRESH_TOKENS || (rtCookie = DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig)) == null) return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn, accessTokenScope));
        refreshToken = DefaultTokenStateManager.decryptToken(rtCookie.getValue(), routingContext, oidcConfig);
        return Uni.createFrom().item((Object)new AuthorizationCodeTokens(idToken, accessToken, refreshToken, accessTokenExpiresIn, accessTokenScope));
    }

    @Override
    public Uni<Void> deleteTokens(RoutingContext routingContext, OidcTenantConfig oidcConfig, String tokenState, OidcRequestContext<Void> requestContext) {
        if (oidcConfig.tokenStateManager().splitTokens()) {
            DefaultTokenStateManager.getAccessTokenCookie(routingContext, oidcConfig);
            List atCookieNames = (List)routingContext.get("q_session_at");
            if (atCookieNames != null) {
                LOG.debugf("Remove session access cookie names: %s", (Object)atCookieNames);
                for (String cookieName : atCookieNames) {
                    OidcUtils.removeCookie(routingContext, oidcConfig, cookieName);
                }
            }
            OidcUtils.removeCookie(routingContext, DefaultTokenStateManager.getRefreshTokenCookie(routingContext, oidcConfig), oidcConfig);
        }
        return CodeAuthenticationMechanism.VOID_UNI;
    }

    private static Long parseAccessTokenExpiresIn(String accessTokenExpiresInString) {
        try {
            return Long.valueOf(accessTokenExpiresInString);
        }
        catch (NumberFormatException ex) {
            String error = "Access token expires_in property in the session cookie must be a number, found %s\n".formatted(accessTokenExpiresInString);
            LOG.debug((Object)ex);
            throw new AuthenticationFailedException(error);
        }
    }

    private static String getAccessTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig) {
        Map cookies = routingContext.request().cookieMap();
        return OidcUtils.getSessionCookie(routingContext.data(), cookies, oidcConfig, "q_session_at", DefaultTokenStateManager.getAccessTokenCookieName(oidcConfig));
    }

    private static ServerCookie getRefreshTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig) {
        return (ServerCookie)routingContext.request().getCookie(DefaultTokenStateManager.getRefreshTokenCookieName(oidcConfig));
    }

    private static String getAccessTokenCookieName(OidcTenantConfig oidcConfig) {
        String cookieSuffix = OidcUtils.getCookieSuffix(oidcConfig);
        return "q_session_at" + cookieSuffix;
    }

    private static String getRefreshTokenCookieName(OidcTenantConfig oidcConfig) {
        String cookieSuffix = OidcUtils.getCookieSuffix(oidcConfig);
        return "q_session_rt" + cookieSuffix;
    }

    private static String encryptToken(String token, RoutingContext context, OidcTenantConfig oidcConfig) {
        if (oidcConfig.tokenStateManager().encryptionRequired()) {
            TenantConfigContext configContext = (TenantConfigContext)context.get(TenantConfigContext.class.getName());
            try {
                KeyEncryptionAlgorithm encAlgorithm = KeyEncryptionAlgorithm.valueOf((String)oidcConfig.tokenStateManager().encryptionAlgorithm().name());
                return OidcUtils.encryptString(token, configContext.getSessionCookieEncryptionKey(), encAlgorithm);
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException((Throwable)ex);
            }
        }
        return token;
    }

    private static String decryptToken(String token, RoutingContext context, OidcTenantConfig oidcConfig) {
        if (oidcConfig.tokenStateManager().encryptionRequired()) {
            TenantConfigContext configContext = (TenantConfigContext)context.get(TenantConfigContext.class.getName());
            try {
                KeyEncryptionAlgorithm encAlgorithm = KeyEncryptionAlgorithm.valueOf((String)oidcConfig.tokenStateManager().encryptionAlgorithm().name());
                return OidcUtils.decryptString(token, configContext.getSessionCookieEncryptionKey(), encAlgorithm);
            }
            catch (Exception ex) {
                throw new AuthenticationFailedException((Throwable)ex);
            }
        }
        return token;
    }

    private static String encodeScopes(OidcTenantConfig oidcConfig, String accessTokenScope) {
        if (oidcConfig.tokenStateManager().encryptionRequired()) {
            return accessTokenScope;
        }
        return OidcCommonUtils.base64UrlEncode((byte[])accessTokenScope.getBytes(StandardCharsets.UTF_8));
    }

    private static String decodeScopes(OidcTenantConfig oidcConfig, String accessTokenScope) {
        if (oidcConfig.tokenStateManager().encryptionRequired()) {
            return accessTokenScope;
        }
        return OidcCommonUtils.base64UrlDecode((String)accessTokenScope);
    }

    private static void createSessionAccessTokenCookie(RoutingContext routingContext, OidcTenantConfig oidcConfig, AuthorizationCodeTokens tokens) {
        String cookieName = DefaultTokenStateManager.getAccessTokenCookieName(oidcConfig);
        StringBuilder sb = new StringBuilder();
        sb.append(tokens.getAccessToken()).append("|").append(tokens.getAccessTokenExpiresIn() != null ? tokens.getAccessTokenExpiresIn() : "").append("|").append(tokens.getAccessTokenScope() != null ? DefaultTokenStateManager.encodeScopes(oidcConfig, tokens.getAccessTokenScope()) : "");
        String cookieValue = DefaultTokenStateManager.encryptToken(sb.toString(), routingContext, oidcConfig);
        LOG.debugf("Session access token cookie length for the tenant %s is %d bytes.", (Object)oidcConfig.tenantId().get(), (Object)cookieValue.length());
        if (cookieValue.length() > OidcUtils.MAX_COOKIE_VALUE_LENGTH) {
            LOG.debugf("Session access token cookie length for the tenant %s is greater than %d bytes. The cookie will be split to chunks to avoid browsers ignoring it. Alternative recommendations: 1. Set 'quarkus.oidc.token-state-manager.strategy=id-refresh-tokens' if you do not need to use the access token as a source of roles or to request UserInfo or propagate it to the downstream services. 2. Decrease the encrypted session access token cookie's length by enabling a direct encryption algorithm with 'quarkus.oidc.token-state-manager.encryption-algorithm=dir'. 3. Decrease the session access token cookie's length by disabling its encryption with 'quarkus.oidc.token-state-manager.encryption-required=false' but only if it is considered to be safe in your application's network. 4. Use the 'quarkus-oidc-db-token-state-manager' extension or the 'quarkus-oidc-redis-token-state-manager' extension or register a custom 'quarkus.oidc.TokenStateManager' CDI bean with the alternative priority set to 1 and save the tokens on the server.", (Object)oidcConfig.tenantId().get(), (Object)OidcUtils.MAX_COOKIE_VALUE_LENGTH);
            OidcUtils.createChunkedCookie(routingContext, oidcConfig, cookieName, cookieValue, (Long)routingContext.get("session-max-age"));
        } else {
            OidcUtils.createSessionCookie(routingContext, oidcConfig, cookieName, cookieValue, (Long)routingContext.get("session-max-age"));
        }
    }
}

