/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rule;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.PhysicalNode;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.ignite3.internal.sql.engine.rel.IgniteConvention;
import org.apache.ignite3.internal.sql.engine.rel.IgniteIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteSystemViewScan;
import org.apache.ignite3.internal.sql.engine.rel.IgniteTableScan;
import org.apache.ignite3.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite3.internal.sql.engine.rel.logical.IgniteLogicalIndexScan;
import org.apache.ignite3.internal.sql.engine.rel.logical.IgniteLogicalSystemViewScan;
import org.apache.ignite3.internal.sql.engine.rel.logical.IgniteLogicalTableScan;
import org.apache.ignite3.internal.sql.engine.rule.AbstractIgniteConverterRule;
import org.apache.ignite3.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite3.internal.sql.engine.schema.IgniteSystemView;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.jetbrains.annotations.Nullable;

public abstract class LogicalScanConverterRule<T extends ProjectableFilterableTableScan>
extends AbstractIgniteConverterRule<T> {
    public static final LogicalScanConverterRule<IgniteLogicalIndexScan> INDEX_SCAN = new LogicalScanConverterRule<IgniteLogicalIndexScan>(IgniteLogicalIndexScan.class, "LogicalIndexScanConverterRule"){

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, IgniteLogicalIndexScan rel) {
            RelCollation collation;
            RelOptCluster cluster = rel.getCluster();
            IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
            IgniteIndex index = table.indexes().get(rel.indexName());
            IgniteDistribution distribution = table.distribution();
            RelCollation relCollation = collation = index.type() == IgniteIndex.Type.HASH ? RelCollations.EMPTY : index.collation();
            if (rel.projects() != null || rel.requiredColumns() != null) {
                Mappings.TargetMapping mapping = 1.createMapping(rel.projects(), rel.requiredColumns(), table.getRowType(cluster.getTypeFactory()).getFieldCount());
                distribution = distribution.apply(mapping);
                collation = (RelCollation)collation.apply(mapping);
            }
            RelTraitSet traits = rel.getCluster().traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)distribution).replace((RelTrait)collation);
            return new IgniteIndexScan(cluster, traits, rel.getTable(), rel.indexName(), index.type(), collation, rel.fieldNames(), rel.projects(), rel.condition(), rel.searchBounds(), rel.requiredColumns());
        }
    };
    public static final LogicalScanConverterRule<IgniteLogicalTableScan> TABLE_SCAN = new LogicalScanConverterRule<IgniteLogicalTableScan>(IgniteLogicalTableScan.class, "LogicalTableScanConverterRule"){

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, IgniteLogicalTableScan rel) {
            RelOptCluster cluster = rel.getCluster();
            IgniteTable table = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
            IgniteDistribution distribution = table.distribution();
            if (rel.requiredColumns() != null) {
                Mappings.TargetMapping mapping = 2.createMapping(rel.projects(), rel.requiredColumns(), table.getRowType(cluster.getTypeFactory()).getFieldCount());
                distribution = distribution.apply(mapping);
            }
            RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)distribution);
            return new IgniteTableScan(rel.getCluster(), traits, rel.getTable(), (List<RelHint>)rel.getHints(), rel.fieldNames(), rel.projects(), rel.condition(), rel.requiredColumns());
        }
    };
    public static final LogicalScanConverterRule<IgniteLogicalSystemViewScan> SYSTEM_VIEW_SCAN = new LogicalScanConverterRule<IgniteLogicalSystemViewScan>(IgniteLogicalSystemViewScan.class, "LogicalSystemViewScanConverterRule"){

        @Override
        protected PhysicalNode convert(RelOptPlanner planner, RelMetadataQuery mq, IgniteLogicalSystemViewScan rel) {
            RelOptCluster cluster = rel.getCluster();
            IgniteSystemView systemView = (IgniteSystemView)rel.getTable().unwrap(IgniteSystemView.class);
            IgniteDistribution distribution = systemView.distribution();
            if (rel.requiredColumns() != null) {
                Mappings.TargetMapping mapping = 3.createMapping(rel.projects(), rel.requiredColumns(), systemView.getRowType(cluster.getTypeFactory()).getFieldCount());
                distribution = distribution.apply(mapping);
            }
            RelTraitSet traits = cluster.traitSetOf((RelTrait)IgniteConvention.INSTANCE).replace((RelTrait)distribution);
            return new IgniteSystemViewScan(rel.getCluster(), traits, (List<RelHint>)rel.getHints(), rel.getTable(), rel.fieldNames(), rel.projects(), rel.condition(), rel.requiredColumns());
        }
    };

    private LogicalScanConverterRule(Class<T> clazz, String descPrefix) {
        super(clazz, descPrefix);
    }

    public static Mappings.TargetMapping createMapping(@Nullable List<RexNode> projects, @Nullable ImmutableIntList requiredColumns, int tableRowSize) {
        if (projects != null) {
            Mappings.IdentityMapping trimmingMapping = requiredColumns != null ? Mappings.invert((Mapping)Mappings.source((List)requiredColumns, (int)tableRowSize)) : Mappings.createIdentity((int)tableRowSize);
            ArrayList<IntPair> pairs = new ArrayList<IntPair>(projects.size());
            for (int i = 0; i < projects.size(); ++i) {
                RexNode rex = projects.get(i);
                if (!(rex instanceof RexLocalRef)) continue;
                RexLocalRef ref = (RexLocalRef)rex;
                pairs.add(IntPair.of((int)trimmingMapping.getSource(ref.getIndex()), (int)i));
            }
            return Mappings.target(pairs, (int)tableRowSize, (int)projects.size());
        }
        if (requiredColumns != null) {
            return Mappings.target((List)requiredColumns, (int)tableRowSize);
        }
        return Mappings.createIdentity((int)tableRowSize);
    }
}

