/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective;

import java.nio.charset.Charset;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class TabItemReorder {
    private final IHopPerspective perspective;
    private CTabItem dragItem;

    public TabItemReorder(IHopPerspective perspective, final CTabFolder folder) {
        this.perspective = perspective;
        DragSource source = new DragSource((Control)folder, 2);
        source.setTransfer(new Transfer[]{TabTransfer.INSTANCE});
        source.addDragListener(new DragSourceListener(){
            private Image dragImage;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dragStart(DragSourceEvent event) {
                Point point = folder.toControl(folder.getDisplay().getCursorLocation());
                TabItemReorder.this.dragItem = folder.getItem(point);
                if (TabItemReorder.this.dragItem == null) {
                    return;
                }
                Rectangle columnBounds = TabItemReorder.this.dragItem.getBounds();
                if (this.dragImage != null) {
                    this.dragImage.dispose();
                    this.dragImage = null;
                }
                if (EnvironmentUtils.getInstance().isWeb()) {
                    this.dragImage = GuiResource.getInstance().getImageHop();
                } else {
                    GC gc = null;
                    try {
                        gc = new GC((Drawable)folder);
                        this.dragImage = new Image((Device)Display.getCurrent(), columnBounds.width, columnBounds.height);
                        gc.copyArea(this.dragImage, columnBounds.x, columnBounds.y);
                        gc.dispose();
                    }
                    finally {
                        if (gc != null) {
                            gc.dispose();
                        }
                    }
                }
                event.image = this.dragImage;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = TabItemReorder.this.dragItem;
            }

            public void dragFinished(DragSourceEvent event) {
                if (EnvironmentUtils.getInstance().isWeb()) {
                    return;
                }
                if (this.dragImage != null) {
                    this.dragImage.dispose();
                    this.dragImage = null;
                }
            }
        });
        DropTarget dropTarget = new DropTarget((Control)folder, 2);
        dropTarget.setTransfer(new Transfer[]{TabTransfer.INSTANCE, TextTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2) {
                    TabItemReorder.this.moveTabs(folder, event);
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                event.detail = !this.isDropSupported(folder, event) ? 0 : 2;
                event.feedback = 1;
            }

            private boolean isDropSupported(CTabFolder folder2, DropTargetEvent event) {
                if (TabItemReorder.this.dragItem == null) {
                    return false;
                }
                Point point = folder2.toControl(folder2.getDisplay().getCursorLocation());
                return folder2.getItem(new Point(point.x, point.y)) != null;
            }
        });
    }

    private void moveTabs(CTabFolder folder, DropTargetEvent event) {
        Point point = folder.toControl(folder.getDisplay().getCursorLocation());
        CTabItem dropItem = folder.getItem(new Point(point.x, point.y));
        if (dropItem != null && this.dragItem != null) {
            Control dragControl = this.dragItem.getControl();
            String dragText = this.dragItem.getText();
            Image dragImage = this.dragItem.getImage();
            String dragToolTip = this.dragItem.getToolTipText();
            boolean dragShowClose = this.dragItem.getShowClose();
            Font dragFont = this.dragItem.getFont();
            IHopFileTypeHandler dragFileTypeHandler = (IHopFileTypeHandler)this.dragItem.getData();
            IHopFileTypeHandler dropFileTypeHandler = (IHopFileTypeHandler)dropItem.getData();
            this.updateTabItemHandler(dragFileTypeHandler, dropItem);
            this.updateTabItemHandler(dropFileTypeHandler, this.dragItem);
            this.dragItem.setText(dropItem.getText());
            this.dragItem.setImage(dropItem.getImage());
            this.dragItem.setToolTipText(dropItem.getToolTipText());
            this.dragItem.setFont(dropItem.getFont());
            this.dragItem.setData(dropItem.getData());
            this.dragItem.setShowClose(dropItem.getShowClose());
            this.dragItem.setControl(dropItem.getControl());
            dropItem.setText(dragText);
            dropItem.setImage(dragImage);
            dropItem.setToolTipText(dragToolTip);
            dropItem.setFont(dragFont);
            dropItem.setData((Object)dragFileTypeHandler);
            dropItem.setShowClose(dragShowClose);
            dropItem.setControl(dragControl);
            folder.setSelection(dropItem);
        }
    }

    private void updateTabItemHandler(IHopFileTypeHandler fileTypeHandler, CTabItem tabItem) {
        for (TabItemHandler item : this.perspective.getItems()) {
            if (!fileTypeHandler.equals(item.getTypeHandler())) continue;
            item.setTabItem(tabItem);
        }
    }

    public static final class TabTransfer
    extends ByteArrayTransfer {
        public static final TabTransfer INSTANCE = new TabTransfer();
        private static final String TYPE_NAME = "TabTransfer.CTabItem Transfer" + System.currentTimeMillis() + ":" + ((Object)((Object)INSTANCE)).hashCode();
        private static final int TYPEID = TabTransfer.registerType((String)TYPE_NAME);
        private CTabItem item;
        private long startTime;

        private TabTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        public void javaToNative(Object object, TransferData transferData) {
            this.item = (CTabItem)object;
            this.startTime = System.currentTimeMillis();
            if (transferData != null) {
                super.javaToNative((Object)String.valueOf(this.startTime).getBytes(Charset.defaultCharset()), transferData);
            }
        }

        public Object nativeToJava(TransferData transferData) {
            byte[] bytes = (byte[])super.nativeToJava(transferData);
            if (bytes == null) {
                return null;
            }
            long startTime = Long.parseLong(new String(bytes));
            return this.startTime == startTime ? this.item : null;
        }
    }
}

