/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.coders;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class StatelessJavaSerializer
extends Serializer {
    private StatelessJavaSerializer(@UnknownKeyFor @NonNull @Initialized Kryo ignore1, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> ignore2) {
    }

    public StatelessJavaSerializer() {
        this(null, null);
    }

    public void write(@UnknownKeyFor @NonNull @Initialized Kryo kryo, @UnknownKeyFor @NonNull @Initialized Output output, @UnknownKeyFor @NonNull @Initialized Object object) {
        try {
            ObjectOutputStream objectStream = new ObjectOutputStream((OutputStream)output);
            objectStream.writeObject(object);
            objectStream.flush();
        }
        catch (Exception e) {
            throw new KryoException("Error during Java serialization.", (Throwable)e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Object read(@UnknownKeyFor @NonNull @Initialized Kryo kryo, @UnknownKeyFor @NonNull @Initialized Input input, @UnknownKeyFor @NonNull @Initialized Class type) {
        try {
            return new ObjectInputStreamWithClassLoader((InputStream)input, kryo.getClassLoader()).readObject();
        }
        catch (Exception e) {
            throw new KryoException("Error during Java deserialization.", (Throwable)e);
        }
    }

    private static class ObjectInputStreamWithClassLoader
    extends ObjectInputStream {
        private final @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader;

        ObjectInputStreamWithClassLoader(@UnknownKeyFor @NonNull @Initialized InputStream in, @UnknownKeyFor @NonNull @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> resolveClass(@UnknownKeyFor @NonNull @Initialized ObjectStreamClass desc) {
            try {
                return Class.forName(desc.getName(), false, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find class: " + desc.getName(), e);
            }
        }
    }
}

