/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.evaluatetablecontent;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="EVAL_TABLE_CONTENT", name="i18n::ActionEvalTableContent.Name", description="i18n::ActionEvalTableContent.Description", image="EvalTableContent.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", keywords={"i18n::ActionEvalTableContent.keyword"}, documentationUrl="/workflow/actions/evaluatetablecontent.html")
public class ActionEvalTableContent
extends ActionBase {
    private static final Class<?> PKG = ActionEvalTableContent.class;
    @HopMetadataProperty(key="add_rows_result")
    private boolean addRowsResult = false;
    @HopMetadataProperty(key="clear_result_rows")
    private boolean clearResultList = true;
    @HopMetadataProperty(key="is_usevars")
    private boolean useVars = false;
    @HopMetadataProperty(key="is_custom_sql")
    private boolean useCustomSql = false;
    @HopMetadataProperty(key="custom_sql")
    private String customSql = null;
    @HopMetadataProperty(key="connection")
    private String connection = null;
    @HopMetadataProperty(key="tablename")
    private String tableName = null;
    @HopMetadataProperty(key="schemaname")
    private String schemaname = null;
    @HopMetadataProperty(key="limit")
    private String limit = "0";
    @HopMetadataProperty(key="success_condition")
    private String successCondition = ActionEvalTableContent.getSuccessConditionCode(4);
    private DatabaseMeta databaseMeta;
    private static final String SELECT_COUNT = "SELECT count(*) FROM ";
    public static final String[] successConditionsDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountSmallerThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountSmallerOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountGreaterThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionEvalTableContent.SuccessWhenRowCountGreaterOrEqual.Label", (String[])new String[0])};
    public static final String[] successConditionsCode = new String[]{"rows_count_equal", "rows_count_different", "rows_count_smaller", "rows_count_smaller_equal", "rows_count_greater", "rows_count_greater_equal"};
    public static final int SUCCESS_CONDITION_ROWS_COUNT_EQUAL = 0;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER = 2;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER_EQUAL = 3;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER = 4;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER_EQUAL = 5;

    public ActionEvalTableContent(String n) {
        super(n, "");
    }

    public ActionEvalTableContent() {
        this("");
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsDesc.length; ++i) {
            if (!successConditionsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionEvalTableContent.getSuccessConditionByCode(tt);
    }

    public static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionsCode.length) {
            return successConditionsCode[0];
        }
        return successConditionsCode[i];
    }

    public static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionsDesc.length) {
            return successConditionsDesc[0];
        }
        return successConditionsDesc[i];
    }

    public DatabaseMeta getDatabase() {
        if (this.databaseMeta != null) {
            return this.databaseMeta;
        }
        try {
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.getMetadataProvider(), (String)this.connection);
            return this.databaseMeta;
        }
        catch (HopXmlException e) {
            return null;
        }
    }

    @VisibleForTesting
    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public Result execute(Result previousResult, int nr) {
        block37: {
            result = previousResult;
            result.setResult(false);
            countSqlStatement = null;
            rowsCount = 0L;
            errCount = 0L;
            successOK = false;
            nrRowsLimit = Const.toInt((String)this.resolve(this.limit), (int)0);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.nrRowsLimit", (String[])new String[]{"" + nrRowsLimit}));
            }
            if (this.getDatabase() != null) {
                try {
                    db = new Database((ILoggingObject)this, (IVariables)this, this.getDatabase());
                    try {
                        db.connect();
                        if (this.useCustomSql) {
                            realCustomSql = this.customSql;
                            if (this.useVars) {
                                realCustomSql = this.resolve(realCustomSql);
                            }
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.EnteredCustomSQL", (String[])new String[]{realCustomSql}));
                            }
                            if (!Utils.isEmpty((CharSequence)realCustomSql)) {
                                countSqlStatement = realCustomSql;
                            } else {
                                ++errCount;
                                this.logError(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Error.NoCustomSQL", (String[])new String[0]));
                            }
                        } else {
                            realTablename = this.resolve(this.tableName);
                            realSchemaname = this.resolve(this.schemaname);
                            if (!Utils.isEmpty((CharSequence)realTablename)) {
                                countSqlStatement = !Utils.isEmpty((CharSequence)realSchemaname) ? "SELECT count(*) FROM " + db.getDatabaseMeta().getQuotedSchemaTableCombination((IVariables)this, realSchemaname, realTablename) : "SELECT count(*) FROM " + db.getDatabaseMeta().quoteField(realTablename);
                            } else {
                                ++errCount;
                                this.logError(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Error.NoTableName", (String[])new String[0]));
                            }
                        }
                        if (countSqlStatement == null) break block37;
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.RunSQLStatement", (String[])new String[]{countSqlStatement}));
                        }
                        if (this.useCustomSql) {
                            if (this.clearResultList) {
                                result.getRows().clear();
                            }
                            if ((ar = db.getRows((String)countSqlStatement, 0)) != null) {
                                rowsCount = ar.size();
                                rowMeta = db.getQueryFields((String)countSqlStatement, false);
                                rows = new ArrayList<RowMetaAndData>();
                                for (Object[] objects : ar) {
                                    rows.add(new RowMetaAndData(rowMeta, objects));
                                }
                                if (this.addRowsResult && this.useCustomSql && rows != null) {
                                    result.getRows().addAll(rows);
                                }
                            } else if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.customSQLreturnedNothing", (String[])new String[]{countSqlStatement}));
                            }
                        } else {
                            row = db.getOneRow((String)countSqlStatement);
                            if (row != null) {
                                rowsCount = row.getInteger(0);
                            }
                        }
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Log.NrRowsReturned", (String[])new String[]{"" + rowsCount}));
                        }
                        switch (ActionEvalTableContent.getSuccessConditionByDesc(this.successCondition)) {
                            case 0: {
                                successOK = rowsCount == (long)nrRowsLimit;
                                ** break;
lbl64:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                successOK = rowsCount != (long)nrRowsLimit;
                                ** break;
lbl68:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                successOK = rowsCount < (long)nrRowsLimit;
                                ** break;
lbl72:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                successOK = rowsCount <= (long)nrRowsLimit;
                                ** break;
lbl76:
                                // 1 sources

                                break;
                            }
                            case 4: {
                                successOK = rowsCount > (long)nrRowsLimit;
                                ** break;
lbl80:
                                // 1 sources

                                break;
                            }
                            case 5: {
                                successOK = rowsCount >= (long)nrRowsLimit;
                                ** break;
lbl84:
                                // 1 sources

                                break;
                            }
                            ** default:
lbl86:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        db.close();
                    }
                }
                catch (HopException dbe) {
                    ++errCount;
                    this.logError(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
                }
            } else {
                ++errCount;
                this.logError(BaseMessages.getString(ActionEvalTableContent.PKG, (String)"ActionEvalTableContent.NoDbConnection", (String[])new String[0]));
            }
        }
        result.setResult(successOK);
        result.setNrLinesRead(rowsCount);
        result.setNrErrors(errCount);
        return result;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.getDatabase() != null) {
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(this.getDatabase().getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.getDatabase().getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "WaitForSQL", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    @Generated
    public void setAddRowsResult(boolean addRowsResult) {
        this.addRowsResult = addRowsResult;
    }

    @Generated
    public void setClearResultList(boolean clearResultList) {
        this.clearResultList = clearResultList;
    }

    @Generated
    public void setUseVars(boolean useVars) {
        this.useVars = useVars;
    }

    @Generated
    public void setUseCustomSql(boolean useCustomSql) {
        this.useCustomSql = useCustomSql;
    }

    @Generated
    public void setCustomSql(String customSql) {
        this.customSql = customSql;
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    @Generated
    public void setLimit(String limit) {
        this.limit = limit;
    }

    @Generated
    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    @Generated
    public boolean isAddRowsResult() {
        return this.addRowsResult;
    }

    @Generated
    public boolean isClearResultList() {
        return this.clearResultList;
    }

    @Generated
    public boolean isUseVars() {
        return this.useVars;
    }

    @Generated
    public boolean isUseCustomSql() {
        return this.useCustomSql;
    }

    @Generated
    public String getCustomSql() {
        return this.customSql;
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getSchemaname() {
        return this.schemaname;
    }

    @Generated
    public String getLimit() {
        return this.limit;
    }

    @Generated
    public String getSuccessCondition() {
        return this.successCondition;
    }

    @Generated
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }
}

