/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.auth;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.google.auto.value.AutoValue;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.aws2.auth.AutoValue_StsAssumeRoleForFederatedCredentialsProvider;
import org.apache.beam.sdk.io.aws2.auth.WebIdTokenProvider;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@JsonSubTypes(value={@JsonSubTypes.Type(value=AutoValue_StsAssumeRoleForFederatedCredentialsProvider.class, name="StsAssumeRoleForFederatedCredentialsProvider")})
@AutoValue
public abstract class StsAssumeRoleForFederatedCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    public static final @UnknownKeyFor @NonNull @Initialized Integer DEFAULT_SESSION_DURATION_SECS = 3600;

    abstract @UnknownKeyFor @NonNull @Initialized CredentialsProviderDelegate credentialsProviderDelegate();

    public abstract @UnknownKeyFor @NonNull @Initialized String audience();

    public abstract @UnknownKeyFor @NonNull @Initialized String assumedRoleArn();

    public abstract @UnknownKeyFor @NonNull @Initialized String webIdTokenProviderFQCN();

    @Nullable
    public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer sessionDurationSecs();

    public @UnknownKeyFor @NonNull @Initialized AwsCredentials resolveCredentials() {
        return this.credentialsProviderDelegate().resolveCredentials();
    }

    public void close() {
        this.credentialsProviderDelegate().close();
    }

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_StsAssumeRoleForFederatedCredentialsProvider.Builder();
    }

    static class CredentialsProviderDelegate {
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized StsAssumeRoleWithWebIdentityCredentialsProvider> credentialsProviderDelegate;

        CredentialsProviderDelegate(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized StsAssumeRoleWithWebIdentityCredentialsProvider> credentialsProviderDelegate) {
            this.credentialsProviderDelegate = credentialsProviderDelegate;
        }

        public static @UnknownKeyFor @NonNull @Initialized CredentialsProviderDelegate create(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized WebIdTokenProvider> webIdTokenProvider, @UnknownKeyFor @NonNull @Initialized String audience, @UnknownKeyFor @NonNull @Initialized String assumedRoleArn, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer sessionDurationSecs) {
            return new CredentialsProviderDelegate((Supplier<StsAssumeRoleWithWebIdentityCredentialsProvider>)Suppliers.memoize(() -> CredentialsProviderDelegate.createCredentialsDelegate(webIdTokenProvider, audience, assumedRoleArn, sessionDurationSecs)));
        }

        public @UnknownKeyFor @NonNull @Initialized AwsCredentials resolveCredentials() {
            return this.credentialsProviderDelegate.get().resolveCredentials();
        }

        public void close() {
            this.credentialsProviderDelegate.get().close();
        }

        static @UnknownKeyFor @NonNull @Initialized StsAssumeRoleWithWebIdentityCredentialsProvider createCredentialsDelegate(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized WebIdTokenProvider> webIdTokenProvider, @UnknownKeyFor @NonNull @Initialized String audience, @UnknownKeyFor @NonNull @Initialized String assumedRoleArn, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer sessionDurationSecs) {
            return ((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)((StsAssumeRoleWithWebIdentityCredentialsProvider.Builder)StsAssumeRoleWithWebIdentityCredentialsProvider.builder().asyncCredentialUpdateEnabled(Boolean.valueOf(true))).refreshRequest(() -> (AssumeRoleWithWebIdentityRequest)AssumeRoleWithWebIdentityRequest.builder().webIdentityToken(((WebIdTokenProvider)webIdTokenProvider.get()).resolveTokenValue(audience)).roleArn(assumedRoleArn).roleSessionName("beam-federated-session-" + UUID.randomUUID()).durationSeconds(Optional.ofNullable(sessionDurationSecs).orElse(DEFAULT_SESSION_DURATION_SECS)).build()).stsClient((StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(Region.AWS_GLOBAL)).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).build())).build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAssumedRoleArn(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setAudience(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setWebIdTokenProviderFQCN(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSessionDurationSecs(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Integer var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCredentialsProviderDelegate(@UnknownKeyFor @NonNull @Initialized CredentialsProviderDelegate var1);

        abstract @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized CredentialsProviderDelegate> credentialsProviderDelegate();

        abstract @UnknownKeyFor @NonNull @Initialized String assumedRoleArn();

        abstract @UnknownKeyFor @NonNull @Initialized String audience();

        abstract @UnknownKeyFor @NonNull @Initialized String webIdTokenProviderFQCN();

        abstract @UnknownKeyFor @NonNull @Initialized Integer sessionDurationSecs();

        abstract @UnknownKeyFor @NonNull @Initialized StsAssumeRoleForFederatedCredentialsProvider autoBuild();

        public @UnknownKeyFor @NonNull @Initialized StsAssumeRoleForFederatedCredentialsProvider build() {
            Preconditions.checkState((this.audience() != null ? 1 : 0) != 0, (Object)"Audience value should not be null");
            Preconditions.checkState((this.assumedRoleArn() != null ? 1 : 0) != 0, (Object)"The role to assume should not be null");
            Preconditions.checkState((this.webIdTokenProviderFQCN() != null ? 1 : 0) != 0, (Object)"The web id token provider fully qualified class name should not be null");
            this.setCredentialsProviderDelegate(this.credentialsProviderDelegate().orElse(CredentialsProviderDelegate.create((Supplier<WebIdTokenProvider>)Suppliers.memoize(() -> WebIdTokenProvider.create(this.webIdTokenProviderFQCN())), this.audience(), this.assumedRoleArn(), this.sessionDurationSecs())));
            return this.autoBuild();
        }
    }
}

