/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.streamschemamerge;

import java.util.Collections;
import java.util.HashSet;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;

public class SchemaMapper {
    IRowMeta row;
    int[][] mapping;

    public SchemaMapper(IRowMeta[] info) throws HopPluginException {
        this.unionMerge(info);
    }

    private void unionMerge(IRowMeta[] info) throws HopPluginException {
        this.mapping = new int[info.length][];
        IRowMeta base = info[0].clone();
        HashSet<String> fieldNames = new HashSet<String>();
        Collections.addAll(fieldNames, base.getFieldNames());
        for (int i = 0; i < info.length; ++i) {
            int[] rowMapping = new int[info[i].size()];
            for (int x = 0; x < rowMapping.length; ++x) {
                int basePosition;
                IValueMeta field = info[i].getValueMeta(x);
                String name = field.getName();
                if (!fieldNames.contains(name)) {
                    base.addValueMeta(field);
                    fieldNames.add(name);
                }
                rowMapping[x] = basePosition = base.indexOfValue(name);
                IValueMeta baseField = base.getValueMeta(basePosition);
                if (baseField.getType() == field.getType()) continue;
                IValueMeta updatedField = ValueMetaFactory.cloneValueMeta((IValueMeta)baseField, (int)2);
                base.setValueMeta(basePosition, updatedField);
            }
            this.mapping[i] = rowMapping;
        }
        this.row = base;
    }

    public int[][] getMapping() {
        return this.mapping;
    }

    public IRowMeta getRowMeta() {
        return this.row;
    }
}

