/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.getxmldata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlData;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataData;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlDataField;
import org.apache.hop.pipeline.transforms.xml.getxmldata.GetXmlFileItem;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="getXMLData", image="GXD.svg", name="i18n::GetXMLData.name", description="i18n::GetXMLData.description", categoryDescription="i18n::GetXMLData.category", keywords={"i18n::GetXmlDataMeta.keyword"}, documentationUrl="/pipeline/transforms/getdatafromxml.html")
public class GetXmlDataMeta
extends BaseTransformMeta<GetXmlData, GetXmlDataData> {
    private static final Class<?> PKG = GetXmlDataMeta.class;
    private static final String YES = "Y";
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    public static final String AT = "@";
    public static final String N0DE_SEPARATOR = "/";
    public static final String CONST_SPACES = "      ";
    public static final String CONST_FIELD = "field";
    @HopMetadataProperty(key="file", injectionKeyDescription="GetXmlDataMeta.Injection.File.Label", injectionGroupKey="files", injectionGroupDescription="GetXmlDataMeta.Injection.Group.FileTab.Label", inlineListTags={"name", "filemask", "exclude_filemask", "file_required", "include_subfolders"})
    private List<GetXmlFileItem> filesList;
    @HopMetadataProperty(key="include", injectionKeyDescription="GetXmlDataMeta.Injection.IncludeFileName")
    private boolean includeFilename;
    @HopMetadataProperty(key="include_field", injectionKeyDescription="GetXmlDataMeta.Injection.FilenameField")
    private String filenameField;
    @HopMetadataProperty(key="rownum", injectionKeyDescription="GetXmlDataMeta.Injection.IncludeRowNumber")
    private boolean includeRowNumber;
    @HopMetadataProperty(key="rownum_field", injectionKeyDescription="GetXmlDataMeta.Injection.RowNumberField")
    private String rowNumberField;
    @HopMetadataProperty(key="limit", injectionKeyDescription="GetXmlDataMeta.Injection.RowLimit")
    private long rowLimit;
    @HopMetadataProperty(key="loopxpath", injectionKeyDescription="GetXmlDataMeta.Injection.LoopXPath")
    private String loopXPath;
    @HopMetadataProperty(key="field", groupKey="fields", injectionKeyDescription="GetXmlDataMeta.Injection.Fields.Label", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Fields.Label")
    private List<GetXmlDataField> inputFields;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.Encoding")
    private String encoding;
    @HopMetadataProperty(key="XmlField", injectionKeyDescription="GetXmlDataMeta.Injection.XmlField")
    private String xmlField;
    @HopMetadataProperty(key="IsInFields", injectionKeyDescription="GetXmlDataMeta.Injection.InFields")
    private boolean inFields;
    @HopMetadataProperty(key="IsAFile", injectionKeyDescription="GetXmlDataMeta.Injection.IsAFile")
    private boolean aFile;
    @HopMetadataProperty(key="addresultfile", injectionKeyDescription="GetXmlDataMeta.Injection.AddResultFile")
    private boolean addResultFile;
    @HopMetadataProperty(key="namespaceaware", injectionKeyDescription="GetXmlDataMeta.Injection.NameSpaceAware")
    private boolean nameSpaceAware;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.Validating")
    private boolean validating;
    @HopMetadataProperty(key="usetoken", injectionKeyDescription="GetXmlDataMeta.Injection.Usetoken")
    private boolean useToken;
    @HopMetadataProperty(key="IsIgnoreEmptyFile", injectionKeyDescription="GetXmlDataMeta.Injection.IsIgnoreEmptyFile")
    private boolean ignoreEmptyFile;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.DoNotFailIfNoFile")
    private boolean doNotFailIfNoFile;
    @HopMetadataProperty(key="ignorecomments", injectionKeyDescription="GetXmlDataMeta.Injection.IgnoreComments")
    private boolean ignoreComments;
    @HopMetadataProperty(key="readurl", injectionKeyDescription="GetXmlDataMeta.Injection.ReadUrl")
    private boolean readUrl;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.PrunePath")
    private String prunePath;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.PrunePath", injectionGroupKey="AdditionalFields", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Additional.Label")
    private String shortFileFieldName;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.PathFieldName", injectionGroupKey="AdditionalFields", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Additional.Label")
    private String pathFieldName;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.HiddenFieldName", injectionGroupKey="AdditionalFields", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Additional.Label")
    private String hiddenFieldName;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.LastModificationTimeFieldName", injectionGroupKey="AdditionalFields", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Additional.Label")
    private String lastModificationTimeFieldName;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.UriNameFieldName", injectionGroupKey="AdditionalFields", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Additional.Label")
    private String uriNameFieldName;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.RootUriNameFieldName", injectionGroupKey="AdditionalFields", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Additional.Label")
    private String rootUriNameFieldName;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.ExtensionFieldName", injectionGroupKey="AdditionalFields", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Additional.Label")
    private String extensionFieldName;
    @HopMetadataProperty(injectionKeyDescription="GetXmlDataMeta.Injection.SizeFieldName", injectionGroupKey="AdditionalFields", injectionGroupDescription="GetXmlDataMeta.Injection.Group.Additional.Label")
    private String sizeFieldName;

    public GetXmlDataMeta() {
        if (this.filesList == null) {
            this.filesList = new ArrayList<GetXmlFileItem>();
        }
        if (this.inputFields == null) {
            this.inputFields = new ArrayList<GetXmlDataField>();
        }
    }

    public String getRequiredFilesDesc(String tt) {
        if (Utils.isEmpty((CharSequence)tt)) {
            return RequiredFilesDesc[0];
        }
        if (tt.equalsIgnoreCase(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public void setDefault() {
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.sizeFieldName = null;
        this.useToken = false;
        this.ignoreEmptyFile = false;
        this.doNotFailIfNoFile = true;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.aFile = false;
        this.addResultFile = false;
        this.nameSpaceAware = false;
        this.ignoreComments = false;
        this.readUrl = false;
        this.validating = false;
        this.loopXPath = "";
        if (this.filesList == null) {
            this.filesList = new ArrayList<GetXmlFileItem>();
        }
        if (this.inputFields == null) {
            this.inputFields = new ArrayList<GetXmlDataField>();
        }
        this.rowLimit = 0L;
        this.inFields = false;
        this.xmlField = "";
        this.prunePath = "";
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString v;
        for (int i = 0; i < this.inputFields.size(); ++i) {
            GetXmlDataField field = this.inputFields.get(i);
            int type = ValueMetaBase.getType((String)field.getType());
            if (type == 0) {
                type = 2;
            }
            try {
                IValueMeta v2 = ValueMetaFactory.createValueMeta((String)variables.resolve(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setOrigin(name);
                v2.setConversionMask(field.getFormat());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.includeFilename) {
            v = new ValueMetaString(variables.resolve(this.filenameField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getShortFileFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getShortFileFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getExtensionFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getExtensionFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getPathFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getPathFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getSizeFieldName())) {
            v = new ValueMetaInteger(variables.resolve(this.getSizeFieldName()));
            v.setOrigin(name);
            v.setLength(9);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getHiddenFieldName())) {
            v = new ValueMetaBoolean(variables.resolve(this.getHiddenFieldName()));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getLastModificationTimeFieldName())) {
            v = new ValueMetaDate(variables.resolve(this.getLastModificationTimeFieldName()));
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getUriNameFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getUriNameFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)this.getRootUriNameFieldName())) {
            v = new ValueMetaString(variables.resolve(this.getRootUriNameFieldName()));
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    protected String[] buildFilenamesArray() {
        String[] fileNames = new String[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            fileNames[i] = this.filesList.get(i).getFileName();
        }
        return fileNames;
    }

    protected String[] buildMasksArray() {
        String[] fileMasks = new String[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            fileMasks[i] = this.filesList.get(i).getFileMask();
        }
        return fileMasks;
    }

    protected String[] buildExcludeMasksArray() {
        String[] excludeMasks = new String[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            excludeMasks[i] = this.filesList.get(i).getExcludeFileMask();
        }
        return excludeMasks;
    }

    protected String[] buildFileRequiredArray() {
        String[] required = new String[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            required[i] = this.filesList.get(i).getFileRequired();
        }
        return required;
    }

    private boolean[] includeSubFolderBoolean() {
        boolean[] includeSubFolderBoolean = new boolean[this.filesList.size()];
        for (int i = 0; i < this.filesList.size(); ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.filesList.get(i).getIncludeSubFolders());
        }
        return includeSubFolderBoolean;
    }

    public FileInputList getFiles(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.buildFilenamesArray(), (String[])this.buildMasksArray(), (String[])this.buildExcludeMasksArray(), (String[])this.buildFileRequiredArray(), (boolean[])this.includeSubFolderBoolean());
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetXMLDataMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetXMLDataMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.getLoopXPath() == null || Utils.isEmpty((CharSequence)this.getLoopXPath())) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetXMLDataMeta.CheckResult.NoLoopXpath", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.getInputFields().size() <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetXMLDataMeta.CheckResult.NoInputField", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isInFields()) {
            if (Utils.isEmpty((CharSequence)this.getXmlField())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetXMLDataMeta.CheckResult.NoField", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetXMLDataMeta.CheckResult.FieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(variables);
            if (fileInputList == null || fileInputList.getFiles().isEmpty()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetXMLDataMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetXMLDataMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming resourceNamingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileInputList fileList;
            ArrayList<String> newFilenames = new ArrayList<String>();
            if (!this.isInFields() && !(fileList = this.getFiles(variables)).getFiles().isEmpty()) {
                for (FileObject fileObject : fileList.getFiles()) {
                    if (!fileObject.exists()) continue;
                    newFilenames.add(fileObject.getName().getPath());
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    @Generated
    public List<GetXmlFileItem> getFilesList() {
        return this.filesList;
    }

    @Generated
    public boolean isIncludeFilename() {
        return this.includeFilename;
    }

    @Generated
    public String getFilenameField() {
        return this.filenameField;
    }

    @Generated
    public boolean isIncludeRowNumber() {
        return this.includeRowNumber;
    }

    @Generated
    public String getRowNumberField() {
        return this.rowNumberField;
    }

    @Generated
    public long getRowLimit() {
        return this.rowLimit;
    }

    @Generated
    public String getLoopXPath() {
        return this.loopXPath;
    }

    @Generated
    public List<GetXmlDataField> getInputFields() {
        return this.inputFields;
    }

    @Generated
    public String getEncoding() {
        return this.encoding;
    }

    @Generated
    public String getXmlField() {
        return this.xmlField;
    }

    @Generated
    public boolean isInFields() {
        return this.inFields;
    }

    @Generated
    public boolean isAFile() {
        return this.aFile;
    }

    @Generated
    public boolean isAddResultFile() {
        return this.addResultFile;
    }

    @Generated
    public boolean isNameSpaceAware() {
        return this.nameSpaceAware;
    }

    @Generated
    public boolean isValidating() {
        return this.validating;
    }

    @Generated
    public boolean isUseToken() {
        return this.useToken;
    }

    @Generated
    public boolean isIgnoreEmptyFile() {
        return this.ignoreEmptyFile;
    }

    @Generated
    public boolean isDoNotFailIfNoFile() {
        return this.doNotFailIfNoFile;
    }

    @Generated
    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    @Generated
    public boolean isReadUrl() {
        return this.readUrl;
    }

    @Generated
    public String getPrunePath() {
        return this.prunePath;
    }

    @Generated
    public String getShortFileFieldName() {
        return this.shortFileFieldName;
    }

    @Generated
    public String getPathFieldName() {
        return this.pathFieldName;
    }

    @Generated
    public String getHiddenFieldName() {
        return this.hiddenFieldName;
    }

    @Generated
    public String getLastModificationTimeFieldName() {
        return this.lastModificationTimeFieldName;
    }

    @Generated
    public String getUriNameFieldName() {
        return this.uriNameFieldName;
    }

    @Generated
    public String getRootUriNameFieldName() {
        return this.rootUriNameFieldName;
    }

    @Generated
    public String getExtensionFieldName() {
        return this.extensionFieldName;
    }

    @Generated
    public String getSizeFieldName() {
        return this.sizeFieldName;
    }

    @Generated
    public void setFilesList(List<GetXmlFileItem> filesList) {
        this.filesList = filesList;
    }

    @Generated
    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    @Generated
    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    @Generated
    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    @Generated
    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Generated
    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Generated
    public void setLoopXPath(String loopXPath) {
        this.loopXPath = loopXPath;
    }

    @Generated
    public void setInputFields(List<GetXmlDataField> inputFields) {
        this.inputFields = inputFields;
    }

    @Generated
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Generated
    public void setXmlField(String xmlField) {
        this.xmlField = xmlField;
    }

    @Generated
    public void setInFields(boolean inFields) {
        this.inFields = inFields;
    }

    @Generated
    public void setAFile(boolean aFile) {
        this.aFile = aFile;
    }

    @Generated
    public void setAddResultFile(boolean addResultFile) {
        this.addResultFile = addResultFile;
    }

    @Generated
    public void setNameSpaceAware(boolean nameSpaceAware) {
        this.nameSpaceAware = nameSpaceAware;
    }

    @Generated
    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    @Generated
    public void setUseToken(boolean useToken) {
        this.useToken = useToken;
    }

    @Generated
    public void setIgnoreEmptyFile(boolean ignoreEmptyFile) {
        this.ignoreEmptyFile = ignoreEmptyFile;
    }

    @Generated
    public void setDoNotFailIfNoFile(boolean doNotFailIfNoFile) {
        this.doNotFailIfNoFile = doNotFailIfNoFile;
    }

    @Generated
    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    @Generated
    public void setReadUrl(boolean readUrl) {
        this.readUrl = readUrl;
    }

    @Generated
    public void setPrunePath(String prunePath) {
        this.prunePath = prunePath;
    }

    @Generated
    public void setShortFileFieldName(String shortFileFieldName) {
        this.shortFileFieldName = shortFileFieldName;
    }

    @Generated
    public void setPathFieldName(String pathFieldName) {
        this.pathFieldName = pathFieldName;
    }

    @Generated
    public void setHiddenFieldName(String hiddenFieldName) {
        this.hiddenFieldName = hiddenFieldName;
    }

    @Generated
    public void setLastModificationTimeFieldName(String lastModificationTimeFieldName) {
        this.lastModificationTimeFieldName = lastModificationTimeFieldName;
    }

    @Generated
    public void setUriNameFieldName(String uriNameFieldName) {
        this.uriNameFieldName = uriNameFieldName;
    }

    @Generated
    public void setRootUriNameFieldName(String rootUriNameFieldName) {
        this.rootUriNameFieldName = rootUriNameFieldName;
    }

    @Generated
    public void setExtensionFieldName(String extensionFieldName) {
        this.extensionFieldName = extensionFieldName;
    }

    @Generated
    public void setSizeFieldName(String sizeFieldName) {
        this.sizeFieldName = sizeFieldName;
    }
}

