/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.row.IValueMeta;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public class ParquetValueConverter
extends PrimitiveConverter {
    private final RowMetaAndData group;
    private final IValueMeta valueMeta;
    private final int rowIndex;
    private final LogicalTypeAnnotation logicalTypeAnnotation;

    public ParquetValueConverter(RowMetaAndData group, int rowIndex, LogicalTypeAnnotation logicalTypeAnnotation) {
        this.group = group;
        this.valueMeta = group.getValueMeta(rowIndex);
        this.rowIndex = rowIndex;
        this.logicalTypeAnnotation = logicalTypeAnnotation;
    }

    public void addBinary(Binary value) {
        if (this.rowIndex < 0) {
            return;
        }
        this.group.getData()[this.rowIndex] = switch (this.valueMeta.getType()) {
            case 2 -> value.toStringUsingUTF8();
            case 8 -> value.getBytes();
            case 6 -> {
                try {
                    yield new BigDecimal(value.toStringUsingUTF8());
                }
                catch (NumberFormatException e) {
                    if (this.logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                        yield ParquetValueConverter.binaryToDecimal(value, ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.logicalTypeAnnotation).getPrecision(), ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.logicalTypeAnnotation).getScale());
                    }
                    yield ParquetValueConverter.binaryToDecimal(value, this.valueMeta.getLength(), this.valueMeta.getPrecision());
                }
            }
            case 11 -> {
                JsonNode node = null;
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    node = mapper.readTree(value.toStringUsingUTF8());
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to parse an json value : " + e.getMessage());
                }
                yield node;
            }
            case 9 -> {
                if (value.length() == 12) {
                    ByteBuffer bb = ByteBuffer.wrap(value.getBytes()).order(ByteOrder.LITTLE_ENDIAN);
                    long nsDay = bb.getLong();
                    long julianDay = (long)bb.getInt() & 0xFFFFFFFFL;
                    BigInteger bns = BigInteger.valueOf(julianDay - 2440588L).multiply(BigInteger.valueOf(86400000000000L)).add(BigInteger.valueOf(nsDay));
                    BigInteger bms = bns.divide(BigInteger.valueOf(1000000L));
                    long ms = bms.longValue();
                    int nanos = (int)(ms % 1000000000L);
                    Timestamp timestamp = new Timestamp(ms);
                    timestamp.setNanos(nanos);
                    yield timestamp;
                }
            }
            default -> throw new RuntimeException("Unable to convert Binary source data to type " + this.valueMeta.getTypeDesc());
        };
    }

    public void addLong(long value) {
        Object object;
        if (this.rowIndex < 0) {
            return;
        }
        switch (this.valueMeta.getType()) {
            case 5: {
                object = value;
                break;
            }
            case 2: {
                object = Long.toString(value);
                break;
            }
            case 3: {
                if (this.logicalTypeAnnotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                    LocalDate date = LocalDate.ofEpochDay(value);
                    Date utilDate = Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
                    object = utilDate;
                    break;
                }
                object = this.convertToTimestamp(value, this.logicalTypeAnnotation);
                break;
            }
            case 6: {
                object = new BigDecimal(value);
                if (!(this.logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) break;
                int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.logicalTypeAnnotation).getScale();
                object = new BigDecimal(((BigDecimal)object).doubleValue()).movePointLeft(scale);
                break;
            }
            case 9: {
                object = this.convertToTimestamp(value, this.logicalTypeAnnotation);
                break;
            }
            default: {
                throw new RuntimeException("Unable to convert Long source data to type " + this.valueMeta.getTypeDesc());
            }
        }
        this.group.getData()[this.rowIndex] = object;
    }

    public void addDouble(double value) {
        Object object;
        if (this.rowIndex < 0) {
            return;
        }
        this.group.getData()[this.rowIndex] = object = (switch (this.valueMeta.getType()) {
            case 1 -> value;
            case 2 -> Double.toString(value);
            case 6 -> BigDecimal.valueOf(value);
            default -> throw new RuntimeException("Unable to convert Double/Float source data to type " + this.valueMeta.getTypeDesc());
        });
    }

    public void addBoolean(boolean value) {
        Object object;
        if (this.rowIndex < 0) {
            return;
        }
        this.group.getData()[this.rowIndex] = object = (switch (this.valueMeta.getType()) {
            case 4 -> value;
            case 2 -> {
                if (value) {
                    yield "true";
                }
                yield "false";
            }
            case 5 -> value ? 1L : 0L;
            default -> throw new RuntimeException("Unable to convert Boolean source data to type " + this.valueMeta.getTypeDesc());
        });
    }

    public void addFloat(float value) {
        this.addDouble(value);
    }

    public void addInt(int value) {
        this.addLong(value);
    }

    private Timestamp convertToTimestamp(long value, LogicalTypeAnnotation logicalTypeAnnotation) {
        LogicalTypeAnnotation.TimeUnit unit = null;
        boolean isUTC = true;
        if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
            unit = ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalTypeAnnotation).getUnit();
            isUTC = ((LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)this.logicalTypeAnnotation).isAdjustedToUTC();
        } else if (logicalTypeAnnotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
            unit = ((LogicalTypeAnnotation.TimeLogicalTypeAnnotation)logicalTypeAnnotation).getUnit();
            isUTC = false;
        }
        if (unit == null) {
            throw new RuntimeException("Unknown timestamp unit for the logical type: " + String.valueOf(logicalTypeAnnotation));
        }
        long epochMillis = switch (unit) {
            case LogicalTypeAnnotation.TimeUnit.MILLIS -> value;
            case LogicalTypeAnnotation.TimeUnit.MICROS -> value / 1000L;
            case LogicalTypeAnnotation.TimeUnit.NANOS -> value / 1000000L;
            default -> throw new RuntimeException("Unknown timestamp unit: " + String.valueOf(unit));
        };
        Timestamp ts = new Timestamp(epochMillis);
        if (!isUTC) {
            int offset = TimeZone.getDefault().getOffset(epochMillis);
            ts.setTime(ts.getTime() - (long)offset);
        }
        if (unit == LogicalTypeAnnotation.TimeUnit.MICROS) {
            ts.setNanos((int)(value % 1000000L * 1000L));
        } else if (unit == LogicalTypeAnnotation.TimeUnit.NANOS) {
            ts.setNanos((int)(value % 1000000000L));
        }
        return ts;
    }

    public static BigDecimal binaryToDecimal(Binary value, int precision, int scale) {
        if (precision <= 18) {
            ByteBuffer buffer = value.toByteBuffer();
            byte[] bytes = buffer.array();
            int start = buffer.arrayOffset() + buffer.position();
            int end = buffer.arrayOffset() + buffer.limit();
            long unscaled = 0L;
            for (int i = start; i < end; ++i) {
                unscaled = unscaled << 8 | (long)(bytes[i] & 0xFF);
            }
            int bits = 8 * (end - start);
            long unscaledNew = unscaled << 64 - bits >> 64 - bits;
            if ((double)unscaledNew <= -Math.pow(10.0, 18.0) || (double)unscaledNew >= Math.pow(10.0, 18.0)) {
                return new BigDecimal(unscaledNew);
            }
            return BigDecimal.valueOf((double)unscaledNew / Math.pow(10.0, scale));
        }
        return new BigDecimal(new BigInteger(value.getBytes()), scale);
    }
}

