/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.AbstractModelComposite;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class OpenAiComposite
extends AbstractModelComposite {
    private final Label baseUrlLabel = this.createLabel();
    private final TextVar baseUrlInput = this.createTextVar();
    private final Label apiKeyLabel;
    private final TextVar apiKeyInput;
    private final Label organizationIdLabel;
    private final TextVar organizationIdInput;
    private final Label modelNameLabel;
    private final TextVar modelNameInput;
    private final Label temperatureLabel;
    private final TextVar temperatureInput;
    private final Label topPLabel;
    private final TextVar topPInput;
    private final Label maxTokensLabel;
    private final TextVar maxTokensInput;
    private final Label presencePenaltyLabel;
    private final TextVar presencePenaltyInput;
    private final Label frequencyPenaltyLabel;
    private final TextVar frequencyPenaltyInput;
    private final Label responseFormatLabel;
    private final TextVar responseFormatInput;
    private final Label seedLabel;
    private final TextVar seedInput;
    private final Label userLabel;
    private final TextVar userInput;
    private final Label timeoutLabel;
    private final TextVar timeoutInput;
    private final Label maxRetriesLabel;
    private final TextVar maxRetriesInput;
    private final Button useProxyButton;
    private final Label proxyHostLabel;
    private final TextVar proxyHostInput;
    private final Label proxyPortLabel;
    private final TextVar proxyPortInput;
    private final Button logRequestsButton;
    private final Button logResponsesButton;

    public OpenAiComposite(CompositeParameters parameters) {
        super(ModelType.OPEN_AI, parameters);
        this.prepare("BaseUrl", this.baseUrlLabel, (Control)this.baseUrlInput);
        this.apiKeyLabel = this.createLabel();
        this.apiKeyInput = this.createTextVar();
        this.prepare("ApiKey", this.apiKeyLabel, (Control)this.apiKeyInput);
        this.modelNameLabel = this.createLabel();
        this.modelNameInput = this.createTextVar();
        this.prepare("ModelName", this.modelNameLabel, (Control)this.modelNameInput);
        this.temperatureLabel = this.createLabel();
        this.temperatureInput = this.createTextVar();
        this.prepare("Temperature", this.temperatureLabel, (Control)this.temperatureInput);
        this.organizationIdLabel = this.createLabel();
        this.organizationIdInput = this.createTextVar();
        this.prepare("Organisation", this.organizationIdLabel, (Control)this.organizationIdInput);
        this.topPLabel = this.createLabel();
        this.topPInput = this.createTextVar();
        this.prepare("TopP", this.topPLabel, (Control)this.topPInput);
        this.maxTokensLabel = this.createLabel();
        this.maxTokensInput = this.createTextVar();
        this.prepare("MaxTokens", this.maxTokensLabel, (Control)this.maxTokensInput);
        this.presencePenaltyLabel = this.createLabel();
        this.presencePenaltyInput = this.createTextVar();
        this.prepare("PresencePenalty", this.presencePenaltyLabel, (Control)this.presencePenaltyInput);
        this.frequencyPenaltyLabel = this.createLabel();
        this.frequencyPenaltyInput = this.createTextVar();
        this.prepare("FrequencyPenalty", this.frequencyPenaltyLabel, (Control)this.frequencyPenaltyInput);
        this.responseFormatLabel = this.createLabel();
        this.responseFormatInput = this.createTextVar();
        this.prepare("ResponseFormat", this.responseFormatLabel, (Control)this.responseFormatInput);
        this.seedLabel = this.createLabel();
        this.seedInput = this.createTextVar();
        this.prepare("Seed", this.seedLabel, (Control)this.seedInput);
        this.userLabel = this.createLabel();
        this.userInput = this.createTextVar();
        this.prepare("User", this.userLabel, (Control)this.userInput);
        this.timeoutLabel = this.createLabel();
        this.timeoutInput = this.createTextVar();
        this.prepare("Timeout", this.timeoutLabel, (Control)this.timeoutInput);
        this.maxRetriesLabel = this.createLabel();
        this.maxRetriesInput = this.createTextVar();
        this.prepare("MaxRetries", this.maxRetriesLabel, (Control)this.maxRetriesInput);
        this.logRequestsButton = this.createButton();
        this.prepare("LogRequests", null, (Control)this.logRequestsButton);
        this.logResponsesButton = this.createButton();
        this.prepare("LogResponses", null, (Control)this.logResponsesButton);
        this.useProxyButton = this.createButton();
        this.useProxyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenAiComposite.this.proxyHostLabel.setVisible(OpenAiComposite.this.useProxyButton.getSelection());
                OpenAiComposite.this.proxyHostInput.setVisible(OpenAiComposite.this.useProxyButton.getSelection());
                OpenAiComposite.this.proxyPortLabel.setVisible(OpenAiComposite.this.useProxyButton.getSelection());
                OpenAiComposite.this.proxyPortInput.setVisible(OpenAiComposite.this.useProxyButton.getSelection());
                OpenAiComposite.this.composite.layout(true, true);
            }
        });
        this.prepare("UseProxy", null, (Control)this.useProxyButton);
        this.proxyHostLabel = this.createLabel();
        this.proxyHostInput = this.createTextVar();
        this.proxyHostLabel.setVisible(false);
        this.proxyHostInput.setVisible(false);
        this.prepare("ProxyHost", this.proxyHostLabel, (Control)this.proxyHostInput);
        this.proxyPortLabel = this.createLabel();
        this.proxyPortInput = this.createTextVar();
        this.proxyPortLabel.setVisible(false);
        this.proxyPortInput.setVisible(false);
        this.prepare("ProxyPort", this.proxyPortLabel, (Control)this.proxyPortInput);
    }

    @Override
    public void loadData() {
        if (!this.isSelectedModelType()) {
            return;
        }
        if (this.meta.getOpenAiBaseUrl() != null) {
            this.baseUrlInput.setText(this.meta.getOpenAiBaseUrl());
        }
        if (this.meta.getOpenAiApiKey() != null) {
            this.apiKeyInput.setText(this.meta.getOpenAiApiKey());
        }
        if (this.meta.getOpenAiOrganizationId() != null) {
            this.organizationIdInput.setText(this.meta.getOpenAiOrganizationId());
        }
        if (this.meta.getOpenAiModelName() != null) {
            this.modelNameInput.setText(this.meta.getOpenAiModelName());
        }
        if (this.meta.getOpenAiTemperature() != null) {
            this.temperatureInput.setText("" + this.meta.getOpenAiTemperature());
        }
        if (this.meta.getOpenAiTopP() != null) {
            this.topPInput.setText("" + this.meta.getOpenAiTopP());
        }
        if (this.meta.getOpenAiMaxTokens() != null) {
            this.maxTokensInput.setText("" + this.meta.getOpenAiMaxTokens());
        }
        if (this.meta.getOpenAiPresencePenalty() != null) {
            this.presencePenaltyInput.setText("" + this.meta.getOpenAiPresencePenalty());
        }
        if (this.meta.getOpenAiFrequencyPenalty() != null) {
            this.frequencyPenaltyInput.setText("" + this.meta.getOpenAiFrequencyPenalty());
        }
        if (this.meta.getOpenAiResponseFormat() != null) {
            this.responseFormatInput.setText(this.meta.getOpenAiResponseFormat());
        }
        if (this.meta.getOpenAiSeed() != null) {
            this.seedInput.setText("" + this.meta.getOpenAiSeed());
        }
        if (this.meta.getOpenAiUser() != null) {
            this.userInput.setText(this.meta.getOpenAiUser());
        }
        if (this.meta.getOpenAiTimeout() != null) {
            this.timeoutInput.setText("" + this.meta.getOpenAiTimeout());
        }
        if (this.meta.getOpenAiMaxRetries() != null) {
            this.maxRetriesInput.setText("" + this.meta.getOpenAiMaxRetries());
        }
        this.useProxyButton.setSelection(this.meta.isOpenAiUseProxy());
        if (this.meta.getOpenAiProxyHost() != null) {
            this.proxyHostInput.setText(this.meta.getOpenAiProxyHost());
        }
        if (this.meta.getOpenAiProxyPort() != null) {
            this.proxyPortInput.setText("" + this.meta.getOpenAiProxyPort());
        }
        this.logRequestsButton.setSelection(this.meta.isOpenAiLogRequests());
        this.logResponsesButton.setSelection(this.meta.isOpenAiLogResponses());
    }

    @Override
    public boolean validateInputs() {
        if (!this.isSelectedModelType()) {
            return true;
        }
        String temperature = StringUtils.trim((String)this.temperatureInput.getText());
        return StringUtils.isBlank((CharSequence)temperature) || NumberUtils.isCreatable((String)temperature);
    }

    @Override
    public void updateTransformMeta() {
        if (!this.validateInputs()) {
            return;
        }
        this.meta.setOpenAiBaseUrl(this.trimStringToNull(this.baseUrlInput.getText()));
        this.meta.setOpenAiApiKey(this.trimStringToNull(this.apiKeyInput.getText()));
        this.meta.setOpenAiOrganizationId(this.trimStringToNull(this.organizationIdInput.getText()));
        this.meta.setOpenAiModelName(this.trimStringToNull(this.modelNameInput.getText()));
        this.meta.setOpenAiTemperature(this.trimDoubleToNull(this.temperatureInput.getText()));
        this.meta.setOpenAiTopP(this.trimDoubleToNull(this.topPInput.getText()));
        this.meta.setOpenAiMaxTokens(this.trimIntegerToNull(this.maxTokensInput.getText()));
        this.meta.setOpenAiPresencePenalty(this.trimDoubleToNull(this.presencePenaltyInput.getText()));
        this.meta.setOpenAiFrequencyPenalty(this.trimDoubleToNull(this.frequencyPenaltyInput.getText()));
        this.meta.setOpenAiResponseFormat(this.trimStringToNull(this.responseFormatInput.getText()));
        this.meta.setOpenAiSeed(this.trimIntegerToNull(this.seedInput.getText()));
        this.meta.setOpenAiUser(this.trimStringToNull(this.userInput.getText()));
        this.meta.setOpenAiTimeout(this.trimIntegerToNull(this.timeoutInput.getText()));
        this.meta.setOpenAiMaxRetries(this.trimIntegerToNull(this.maxRetriesInput.getText()));
        this.meta.setOpenAiUseProxy(this.useProxyButton.getSelection());
        this.meta.setOpenAiProxyHost(this.trimStringToNull(this.proxyHostInput.getText()));
        this.meta.setOpenAiProxyPort(this.trimIntegerToNull(this.proxyPortInput.getText()));
        this.meta.setOpenAiLogRequests(this.logRequestsButton.getSelection());
        this.meta.setOpenAiLogResponses(this.logResponsesButton.getSelection());
    }

    public Label getApiKeyLabel() {
        return this.apiKeyLabel;
    }

    public TextVar getApiKeyInput() {
        return this.apiKeyInput;
    }

    public Label getModelNameLabel() {
        return this.modelNameLabel;
    }

    public TextVar getModelNameInput() {
        return this.modelNameInput;
    }

    public Label getTemperatureLabel() {
        return this.temperatureLabel;
    }

    public TextVar getTemperatureInput() {
        return this.temperatureInput;
    }

    public Label getBaseUrlLabel() {
        return this.baseUrlLabel;
    }

    public TextVar getBaseUrlInput() {
        return this.baseUrlInput;
    }

    public Label getOrganizationIdLabel() {
        return this.organizationIdLabel;
    }

    public TextVar getOrganizationIdInput() {
        return this.organizationIdInput;
    }

    public Label getTopPLabel() {
        return this.topPLabel;
    }

    public TextVar getTopPInput() {
        return this.topPInput;
    }

    public Label getMaxTokensLabel() {
        return this.maxTokensLabel;
    }

    public TextVar getMaxTokensInput() {
        return this.maxTokensInput;
    }

    public Label getPresencePenaltyLabel() {
        return this.presencePenaltyLabel;
    }

    public TextVar getPresencePenaltyInput() {
        return this.presencePenaltyInput;
    }

    public Label getFrequencyPenaltyLabel() {
        return this.frequencyPenaltyLabel;
    }

    public TextVar getFrequencyPenaltyInput() {
        return this.frequencyPenaltyInput;
    }

    public Label getResponseFormatLabel() {
        return this.responseFormatLabel;
    }

    public TextVar getResponseFormatInput() {
        return this.responseFormatInput;
    }

    public Label getSeedLabel() {
        return this.seedLabel;
    }

    public TextVar getSeedInput() {
        return this.seedInput;
    }

    public Label getUserLabel() {
        return this.userLabel;
    }

    public TextVar getUserInput() {
        return this.userInput;
    }

    public Label getTimeoutLabel() {
        return this.timeoutLabel;
    }

    public TextVar getTimeoutInput() {
        return this.timeoutInput;
    }

    public Label getMaxRetriesLabel() {
        return this.maxRetriesLabel;
    }

    public TextVar getMaxRetriesInput() {
        return this.maxRetriesInput;
    }

    public Button getUseProxyButton() {
        return this.useProxyButton;
    }

    public Label getProxyHostLabel() {
        return this.proxyHostLabel;
    }

    public TextVar getProxyHostInput() {
        return this.proxyHostInput;
    }

    public Label getProxyPortLabel() {
        return this.proxyPortLabel;
    }

    public TextVar getProxyPortInput() {
        return this.proxyPortInput;
    }

    public Button getLogRequestsButton() {
        return this.logRequestsButton;
    }

    public Button getLogResponsesButton() {
        return this.logResponsesButton;
    }
}

