/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class ObjectLockListEntry {
    public static final int LOCK_SCOPE_JOB = 0;
    public static final int LOCK_SCOPE_THREAD = 1;
    public static final int LOCK_SCOPE_LOCK_SPACE = 2;
    public static final String LOCK_STATE_NONE = "*NONE";
    public static final String LOCK_STATE_SHARED_READ = "*SHRRD";
    public static final String LOCK_STATE_SHARED_UPDATE = "*SHRUPD";
    public static final String LOCK_STATE_SHARED_NO_UPDATE = "*SHRNUP";
    public static final String LOCK_STATE_EXCLUSIVE_ALLOW_READ = "*EXCLRD";
    public static final String LOCK_STATE_EXCLUSIVE_NO_READ = "*EXCL";
    public static final int LOCK_STATUS_LOCK_HELD = 1;
    public static final int LOCK_STATUS_JOB_THREAD_WAITING_SYNC = 2;
    public static final int LOCK_STATUS_LOCK_REQUEST_OUTSTANDING_ASYNC = 3;
    public static final int LOCK_TYPE_OBJECT = 1;
    public static final int LOCK_TYPE_MEMBER_CONTROL_BLOCK = 2;
    public static final int LOCK_TYPE_ACCESS_PATH = 3;
    public static final int LOCK_TYPE_DATA_WITHIN_MEMBER = 4;
    public static final int LOCK_SHARE_FILE_NOT_SHARED = 0;
    public static final int LOCK_SHARE_FILE_SHARED = 1;
    public static final String JOB_NAME_MACHINE = "MACHINE";
    public static final String JOB_NAME_LOCK_SPACE = "*LCKSPC";
    public static final String VALUE_CANNOT_BE_DETERMINED = "*N";
    private String jobName_;
    private String jobUsername_;
    private String jobNumber_;
    private String lockState_;
    private int lockStatus_;
    private int lockType_;
    private String share_;
    private String lockScope_;
    private long threadID_;

    ObjectLockListEntry(String jobName, String jobUserName, String jobNumber, String lockState, int lockStatus, int lockType, String memberName, String share, String lockScope, long threadID) {
        this.jobName_ = jobName;
        this.jobUsername_ = jobUserName;
        this.jobNumber_ = jobNumber;
        this.lockState_ = lockState;
        this.lockStatus_ = lockStatus;
        this.lockType_ = lockType;
        this.share_ = share;
        this.lockScope_ = lockScope;
        this.threadID_ = threadID;
    }

    public String getJobName() {
        return this.jobName_;
    }

    public String getJobUserName() {
        return this.jobUsername_;
    }

    public String getJobNumber() {
        return this.jobNumber_;
    }

    public String getLockState() {
        if (!(this.lockState_.equals(LOCK_STATE_NONE) || this.lockState_.equals(LOCK_STATE_SHARED_READ) || this.lockState_.equals(LOCK_STATE_SHARED_UPDATE) || this.lockState_.equals(LOCK_STATE_SHARED_NO_UPDATE) || this.lockState_.equals(LOCK_STATE_EXCLUSIVE_ALLOW_READ) || this.lockState_.equals(LOCK_STATE_EXCLUSIVE_NO_READ))) {
            Trace.log(2, "Invalid lock state: " + this.lockState_);
            throw new InternalErrorException(6, this.lockState_, null);
        }
        return this.lockState_;
    }

    public int getLockStatus() {
        if (this.lockStatus_ != 1 && this.lockStatus_ != 2 && this.lockStatus_ != 3) {
            Trace.log(2, "Invalid lock status:", this.lockStatus_);
            throw new InternalErrorException(6, this.lockStatus_);
        }
        return this.lockStatus_;
    }

    public int getLockType() {
        if (this.lockType_ != 1 && this.lockType_ != 2 && this.lockType_ != 3 && this.lockType_ != 4) {
            Trace.log(2, "Invalid lock type:", this.lockType_);
            throw new InternalErrorException(6, this.lockType_);
        }
        return this.lockType_;
    }

    public int getShare() {
        int intShare;
        try {
            intShare = Integer.parseInt(this.share_);
        }
        catch (NumberFormatException e) {
            Trace.log(2, "Invalid number conversion for (" + this.share_ + ")");
            throw new InternalErrorException(6, (Throwable)e);
        }
        if (intShare != 0 && intShare != 1) {
            Trace.log(2, "Invalid lock share:", intShare);
            throw new InternalErrorException(6, intShare);
        }
        return intShare;
    }

    public int getLockScope() {
        int intLockScope;
        try {
            intLockScope = Integer.parseInt(this.lockScope_);
        }
        catch (NumberFormatException e) {
            Trace.log(2, "Invalid number conversion for (" + this.lockScope_ + ")");
            throw new InternalErrorException(6, (Throwable)e);
        }
        if (intLockScope != 0 && intLockScope != 1 && intLockScope != 2) {
            Trace.log(2, "Invalid lock scope:", intLockScope);
            throw new InternalErrorException(6, intLockScope);
        }
        return intLockScope;
    }

    public long getThreadID() {
        return this.threadID_;
    }

    public String toString() {
        return "[" + this.getJobName() + "/" + this.getJobUserName() + "/" + this.getJobNumber() + "/0x" + Long.toHexString(this.getThreadID()).toUpperCase() + "]";
    }
}

