/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.resource;

import java.util.ListIterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Private
public class PlacementConstraintTransformations {

    public static class SpecializedConstraintTransformer
    extends AbstractTransformer {
        public SpecializedConstraintTransformer(PlacementConstraint constraint) {
            super(constraint);
        }

        @Override
        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.SingleConstraint constraint) {
            PlacementConstraint.SingleConstraint transformedConstraint = constraint;
            if (constraint.getMinCardinality() == 1 && constraint.getMaxCardinality() == Integer.MAX_VALUE) {
                transformedConstraint = new PlacementConstraint.TargetConstraint(PlacementConstraint.TargetConstraint.TargetOperator.IN, constraint.getScope(), constraint.getTargetExpressions());
            } else if (constraint.getMinCardinality() == 0 && constraint.getMaxCardinality() == 0) {
                transformedConstraint = new PlacementConstraint.TargetConstraint(PlacementConstraint.TargetConstraint.TargetOperator.NOT_IN, constraint.getScope(), constraint.getTargetExpressions());
            }
            return transformedConstraint;
        }
    }

    public static class SingleConstraintTransformer
    extends AbstractTransformer {
        public SingleConstraintTransformer(PlacementConstraint constraint) {
            super(constraint);
        }

        @Override
        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.TargetConstraint constraint) {
            PlacementConstraint.SingleConstraint newConstraint;
            if (constraint.getOp() == PlacementConstraint.TargetConstraint.TargetOperator.IN) {
                newConstraint = new PlacementConstraint.SingleConstraint(constraint.getScope(), 1, Integer.MAX_VALUE, constraint.getTargetExpressions());
            } else if (constraint.getOp() == PlacementConstraint.TargetConstraint.TargetOperator.NOT_IN) {
                newConstraint = new PlacementConstraint.SingleConstraint(constraint.getScope(), 0, 0, constraint.getTargetExpressions());
            } else {
                throw new YarnRuntimeException("Encountered unexpected type of constraint target operator: " + constraint.getOp());
            }
            return newConstraint;
        }

        @Override
        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.CardinalityConstraint constraint) {
            return new PlacementConstraint.SingleConstraint(constraint.getScope(), constraint.getMinCardinality(), constraint.getMaxCardinality(), new PlacementConstraint.TargetExpression[]{new PlacementConstraint.TargetExpression(PlacementConstraint.TargetExpression.TargetType.ALLOCATION_TAG, null, constraint.getAllocationTags())});
        }
    }

    public static class AbstractTransformer
    implements PlacementConstraint.Visitor<PlacementConstraint.AbstractConstraint> {
        private PlacementConstraint placementConstraint;

        public AbstractTransformer(PlacementConstraint placementConstraint) {
            this.placementConstraint = placementConstraint;
        }

        public PlacementConstraint transform() {
            PlacementConstraint.AbstractConstraint constraintExpr = this.placementConstraint.getConstraintExpr();
            constraintExpr = (PlacementConstraint.AbstractConstraint)constraintExpr.accept((PlacementConstraint.Visitor)this);
            return new PlacementConstraint(constraintExpr);
        }

        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.SingleConstraint constraint) {
            return constraint;
        }

        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.TargetExpression expression) {
            return null;
        }

        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.TargetConstraint constraint) {
            return constraint;
        }

        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.CardinalityConstraint constraint) {
            return constraint;
        }

        private PlacementConstraint.AbstractConstraint visitAndOr(PlacementConstraint.CompositeConstraint<PlacementConstraint.AbstractConstraint> constraint) {
            ListIterator<PlacementConstraint.AbstractConstraint> iter = constraint.getChildren().listIterator();
            while (iter.hasNext()) {
                PlacementConstraint.AbstractConstraint child = (PlacementConstraint.AbstractConstraint)iter.next();
                child = (PlacementConstraint.AbstractConstraint)child.accept((PlacementConstraint.Visitor)this);
                iter.set(child);
            }
            return constraint;
        }

        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.And constraint) {
            return this.visitAndOr((PlacementConstraint.CompositeConstraint<PlacementConstraint.AbstractConstraint>)constraint);
        }

        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.Or constraint) {
            return this.visitAndOr((PlacementConstraint.CompositeConstraint<PlacementConstraint.AbstractConstraint>)constraint);
        }

        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.DelayedOr constraint) {
            constraint.getChildren().forEach(child -> child.setConstraint((PlacementConstraint.AbstractConstraint)child.getConstraint().accept((PlacementConstraint.Visitor)this)));
            return constraint;
        }

        public PlacementConstraint.AbstractConstraint visit(PlacementConstraint.TimedPlacementConstraint constraint) {
            return null;
        }
    }
}

