/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.engines.dataflow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.runners.dataflow.options.DataflowPipelineWorkerPoolOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.engines.BeamPipelineRunConfiguration;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.metadata.RunnerType;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

@GuiPlugin
public class BeamDataFlowPipelineRunConfiguration
extends BeamPipelineRunConfiguration
implements IBeamPipelineEngineRunConfiguration,
IVariables,
Cloneable {
    public static final String EXPERIMENT_APACHE_HOP_PIPELINE = "apache_hop_pipeline";
    @GuiWidgetElement(order="20000-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsProjectID.ToolTip", label="i18n::BeamEnginesDataflow.OptionsProjectID.Label")
    @HopMetadataProperty
    private String gcpProjectId;
    @GuiWidgetElement(order="20005-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsServiceAccount.ToolTip", label="i18n::BeamEnginesDataflow.OptionsServiceAccount.Label")
    @HopMetadataProperty
    private String gcpServiceAccount;
    @GuiWidgetElement(order="20010-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsAppName.ToolTip", label="i18n::BeamEnginesDataflow.OptionsAppName.Label")
    @HopMetadataProperty
    private String gcpAppName;
    @GuiWidgetElement(order="20020-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.FOLDER, toolTip="i18n::BeamEnginesDataflow.OptionsStagingLocation.ToolTip", label="i18n::BeamEnginesDataflow.OptionsStagingLocation.Label")
    @HopMetadataProperty
    private String gcpStagingLocation;
    @GuiWidgetElement(order="20030-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsNumberOfWorkers.ToolTip", label="i18n::BeamEnginesDataflow.OptionsNumberOfWorkers.Label")
    @HopMetadataProperty
    private String gcpInitialNumberOfWorkers;
    @GuiWidgetElement(order="20040-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesDataflow.OptionsMaxNumberOfWorkers.Label", toolTip="i18n::BeamEnginesDataflow.OptionsMaxNumberOfWorkers.ToolTip")
    @HopMetadataProperty
    private String gcpMaximumNumberOfWorkers;
    @GuiWidgetElement(order="20050-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsAutoScalingAlgorithm.ToolTip", label="i18n::BeamEnginesDataflow.OptionsAutoScalingAlgorithm.Label")
    @HopMetadataProperty
    private String gcpAutoScalingAlgorithm;
    @GuiWidgetElement(order="20060-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsWorkerMachineType.ToolTip", label="i18n::BeamEnginesDataflow.OptionsWorkerMachineType.Label")
    @HopMetadataProperty
    private String gcpWorkerMachineType;
    @GuiWidgetElement(order="20070-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsWorkerDiskType.ToolTip", label="i18n::BeamEnginesDataflow.OptionsWorkerDiskType.Label")
    @HopMetadataProperty
    private String gcpWorkerDiskType;
    @GuiWidgetElement(order="20080-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsDiskSize.ToolTip", label="i18n::BeamEnginesDataflow.OptionsDiskSize.Label")
    @HopMetadataProperty
    private String gcpDiskSizeGb;
    @GuiWidgetElement(order="20090-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsRegion.ToolTip", label="i18n::BeamEnginesDataflow.OptionsRegion.Label")
    @HopMetadataProperty
    private String gcpRegion;
    @GuiWidgetElement(order="20100-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, toolTip="i18n::BeamEnginesDataflow.OptionsZone.ToolTip", label="i18n::BeamEnginesDataflow.OptionsZone.Label")
    @HopMetadataProperty
    private String gcpZone;
    @GuiWidgetElement(order="20110-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesDataflow.OptionsNetwork.Label", toolTip="i18n::BeamEnginesDataflow.OptionsNetwork.ToolTip")
    @HopMetadataProperty
    private String gcpNetwork;
    @GuiWidgetElement(order="20120-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesDataflow.OptionsSubNetwork.Label", toolTip="i18n::BeamEnginesDataflow.OptionsSubNetwork.ToolTip")
    @HopMetadataProperty
    private String gcpSubnetwork;
    @GuiWidgetElement(order="20130-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.CHECKBOX, label="i18n::BeamEnginesDataflow.OptionsPublicIP.Label", toolTip="i18n::BeamEnginesDataflow.OptionsPublicIP.ToolTip")
    @HopMetadataProperty
    private boolean gcpUsingPublicIps;
    @GuiWidgetElement(order="20140-dataflow-options", parentId="PipelineRunConfiguration-PluginSpecific-Options", type=GuiElementType.TEXT, label="i18n::BeamEnginesDataflow.OptionsServiceOptions.Label", toolTip="i18n::BeamEnginesDataflow.OptionsServiceOptions.ToolTip")
    @HopMetadataProperty
    private String gcpDataflowServiceOptions;

    public BeamDataFlowPipelineRunConfiguration() {
        this.gcpAppName = "Hop";
        this.gcpUsingPublicIps = true;
    }

    public BeamDataFlowPipelineRunConfiguration(BeamDataFlowPipelineRunConfiguration config) {
        super(config);
        this.gcpProjectId = config.gcpProjectId;
        this.gcpServiceAccount = config.gcpServiceAccount;
        this.gcpAppName = config.gcpAppName;
        this.gcpStagingLocation = config.gcpStagingLocation;
        this.gcpInitialNumberOfWorkers = config.gcpInitialNumberOfWorkers;
        this.gcpMaximumNumberOfWorkers = config.gcpMaximumNumberOfWorkers;
        this.gcpAutoScalingAlgorithm = config.gcpAutoScalingAlgorithm;
        this.gcpWorkerMachineType = config.gcpWorkerMachineType;
        this.gcpWorkerDiskType = config.gcpWorkerDiskType;
        this.gcpDiskSizeGb = config.gcpDiskSizeGb;
        this.gcpRegion = config.gcpRegion;
        this.gcpZone = config.gcpZone;
        this.gcpNetwork = config.gcpNetwork;
        this.gcpSubnetwork = config.gcpSubnetwork;
        this.gcpUsingPublicIps = config.gcpUsingPublicIps;
        this.gcpDataflowServiceOptions = config.gcpDataflowServiceOptions;
    }

    public BeamDataFlowPipelineRunConfiguration clone() {
        return new BeamDataFlowPipelineRunConfiguration(this);
    }

    public RunnerType getRunnerType() {
        return RunnerType.DataFlow;
    }

    public PipelineOptions getPipelineOptions() throws HopException {
        int diskSize;
        int numWorkers;
        DataflowPipelineOptions options = (DataflowPipelineOptions)PipelineOptionsFactory.as(DataflowPipelineOptions.class);
        options.setProject(this.resolve(this.getGcpProjectId()));
        options.setAppName(this.resolve(this.getGcpAppName()));
        options.setStagingLocation(this.resolve(this.getGcpStagingLocation()));
        if (StringUtils.isNotEmpty((String)this.getGcpServiceAccount())) {
            options.setServiceAccount(this.resolve(this.getGcpServiceAccount()));
        }
        if (StringUtils.isNotEmpty((String)this.getGcpInitialNumberOfWorkers()) && (numWorkers = Const.toInt((String)this.resolve(this.getGcpInitialNumberOfWorkers()), (int)-1)) >= 0) {
            options.setNumWorkers(numWorkers);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpMaximumNumberOfWorkers()) && (numWorkers = Const.toInt((String)this.resolve(this.getGcpMaximumNumberOfWorkers()), (int)-1)) >= 0) {
            options.setMaxNumWorkers(numWorkers);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpWorkerMachineType())) {
            String machineType = this.resolve(this.getGcpWorkerMachineType());
            options.setWorkerMachineType(machineType);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpWorkerDiskType())) {
            String diskType = this.resolve(this.getGcpWorkerDiskType());
            options.setWorkerDiskType(diskType);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpDiskSizeGb()) && (diskSize = Const.toInt((String)this.resolve(this.getGcpDiskSizeGb()), (int)-1)) >= 0) {
            options.setDiskSizeGb(diskSize);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpZone())) {
            String zone = this.resolve(this.getGcpZone());
            options.setWorkerZone(zone);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpRegion())) {
            String region = this.resolve(this.getGcpRegion());
            options.setRegion(region);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpAutoScalingAlgorithm())) {
            String algorithmCode = this.resolve(this.getGcpAutoScalingAlgorithm());
            try {
                DataflowPipelineWorkerPoolOptions.AutoscalingAlgorithmType algorithm = DataflowPipelineWorkerPoolOptions.AutoscalingAlgorithmType.valueOf((String)algorithmCode);
                options.setAutoscalingAlgorithm(algorithm);
            }
            catch (Exception e) {
                throw new HopException("Unknown autoscaling algorithm for GCP DataFlow: " + algorithmCode, (Throwable)e);
            }
        }
        if (StringUtils.isNotEmpty((String)this.getGcpNetwork())) {
            String network = this.resolve(this.getGcpNetwork());
            options.setNetwork(network);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpSubnetwork())) {
            String subnetwork = this.resolve(this.getGcpSubnetwork());
            options.setSubnetwork(subnetwork);
        }
        if (StringUtils.isNotEmpty((String)this.getGcpDataflowServiceOptions())) {
            String serviceOptionsString = this.resolve(this.getGcpDataflowServiceOptions());
            List<String> serviceOptions = Arrays.asList(serviceOptionsString.split(","));
            options.setDataflowServiceOptions(serviceOptions);
        }
        options.setUsePublicIps(Boolean.valueOf(this.isGcpUsingPublicIps()));
        ArrayList<String> experiments = options.getExperiments();
        experiments = experiments == null ? new ArrayList<String>() : new ArrayList(experiments);
        experiments.add(EXPERIMENT_APACHE_HOP_PIPELINE);
        options.setExperiments(experiments);
        if (StringUtils.isNotEmpty((String)this.getFatJar())) {
            options.setFilesToStage(Collections.singletonList(this.resolve(this.fatJar)));
        }
        return options;
    }

    public boolean isRunningAsynchronous() {
        return true;
    }

    public String getGcpProjectId() {
        return this.gcpProjectId;
    }

    public void setGcpProjectId(String gcpProjectId) {
        this.gcpProjectId = gcpProjectId;
    }

    public String getGcpServiceAccount() {
        return this.gcpServiceAccount;
    }

    public void setGcpServiceAccount(String gcpServiceAccount) {
        this.gcpServiceAccount = gcpServiceAccount;
    }

    public String getGcpAppName() {
        return this.gcpAppName;
    }

    public void setGcpAppName(String gcpAppName) {
        this.gcpAppName = gcpAppName;
    }

    public String getGcpStagingLocation() {
        return this.gcpStagingLocation;
    }

    public void setGcpStagingLocation(String gcpStagingLocation) {
        this.gcpStagingLocation = gcpStagingLocation;
    }

    public String getGcpInitialNumberOfWorkers() {
        return this.gcpInitialNumberOfWorkers;
    }

    public void setGcpInitialNumberOfWorkers(String gcpInitialNumberOfWorkers) {
        this.gcpInitialNumberOfWorkers = gcpInitialNumberOfWorkers;
    }

    public String getGcpMaximumNumberOfWorkers() {
        return this.gcpMaximumNumberOfWorkers;
    }

    public void setGcpMaximumNumberOfWorkers(String gcpMaximumNumberOfWorkers) {
        this.gcpMaximumNumberOfWorkers = gcpMaximumNumberOfWorkers;
    }

    public String getGcpAutoScalingAlgorithm() {
        return this.gcpAutoScalingAlgorithm;
    }

    public void setGcpAutoScalingAlgorithm(String gcpAutoScalingAlgorithm) {
        this.gcpAutoScalingAlgorithm = gcpAutoScalingAlgorithm;
    }

    public String getGcpWorkerMachineType() {
        return this.gcpWorkerMachineType;
    }

    public void setGcpWorkerMachineType(String gcpWorkerMachineType) {
        this.gcpWorkerMachineType = gcpWorkerMachineType;
    }

    public String getGcpWorkerDiskType() {
        return this.gcpWorkerDiskType;
    }

    public void setGcpWorkerDiskType(String gcpWorkerDiskType) {
        this.gcpWorkerDiskType = gcpWorkerDiskType;
    }

    public String getGcpDiskSizeGb() {
        return this.gcpDiskSizeGb;
    }

    public void setGcpDiskSizeGb(String gcpDiskSizeGb) {
        this.gcpDiskSizeGb = gcpDiskSizeGb;
    }

    public String getGcpRegion() {
        return this.gcpRegion;
    }

    public void setGcpRegion(String gcpRegion) {
        this.gcpRegion = gcpRegion;
    }

    public String getGcpZone() {
        return this.gcpZone;
    }

    public void setGcpZone(String gcpZone) {
        this.gcpZone = gcpZone;
    }

    public String getGcpNetwork() {
        return this.gcpNetwork;
    }

    public void setGcpNetwork(String gcpNetwork) {
        this.gcpNetwork = gcpNetwork;
    }

    public String getGcpSubnetwork() {
        return this.gcpSubnetwork;
    }

    public void setGcpSubnetwork(String gcpSubnetwork) {
        this.gcpSubnetwork = gcpSubnetwork;
    }

    public boolean isGcpUsingPublicIps() {
        return this.gcpUsingPublicIps;
    }

    public void setGcpUsingPublicIps(boolean gcpUsingPublicIps) {
        this.gcpUsingPublicIps = gcpUsingPublicIps;
    }

    public String getGcpDataflowServiceOptions() {
        return this.gcpDataflowServiceOptions;
    }

    public void setGcpDataflowServiceOptions(String gcpDataflowServiceOptions) {
        this.gcpDataflowServiceOptions = gcpDataflowServiceOptions;
    }
}

