/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.Callable;
import org.apache.cassandra.concurrent.DebuggableTask;
import org.apache.cassandra.concurrent.FutureTask;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.utils.Closeable;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.WithResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionFailure {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionFailure.class);

    public static void handle(Throwable t) {
        try {
            if (t instanceof CompactionInterruptedException) {
                logger.info(t.getMessage());
                if (t.getSuppressed() != null && t.getSuppressed().length > 0) {
                    logger.warn("Interruption of compaction encountered exceptions:", t);
                } else {
                    logger.trace("Full interruption stack trace:", t);
                }
            } else {
                Thread thread = Thread.currentThread();
                Thread.UncaughtExceptionHandler handler = thread.getUncaughtExceptionHandler();
                if (handler == null) {
                    handler = JVMStabilityInspector::uncaughtException;
                }
                handler.uncaughtException(thread, t);
            }
        }
        catch (Throwable shouldNeverHappen) {
            logger.error("Unexpected error while handling unexpected error", shouldNeverHappen);
        }
    }

    static Runnable propagating(Runnable wrap) {
        return wrap instanceof FutureTask ? wrap : ExecutionFailure.propagating(WithResources.none(), wrap);
    }

    static Runnable propagating(WithResources withResources, Runnable wrap) {
        return ExecutionFailure.enforceOptions(withResources, wrap, true);
    }

    static Runnable suppressing(Runnable wrap) {
        return wrap instanceof FutureTask ? wrap : ExecutionFailure.suppressing(WithResources.none(), wrap);
    }

    static Runnable suppressing(WithResources withResources, Runnable wrap) {
        return ExecutionFailure.enforceOptions(withResources, wrap, false);
    }

    static DebuggableTask.RunnableDebuggableTask suppressingDebuggable(WithResources withResources, DebuggableTask.RunnableDebuggableTask debuggable) {
        return ExecutionFailure.enforceOptionsDebuggable(withResources, debuggable, false);
    }

    private static Runnable enforceOptions(final WithResources withResources, final Runnable wrap, final boolean propagate) {
        return new Runnable(){

            @Override
            public void run() {
                block14: {
                    try (Closeable close = withResources.get();){
                        wrap.run();
                    }
                    catch (Throwable t) {
                        ExecutionFailure.handle(t);
                        if (!propagate) break block14;
                        throw t;
                    }
                }
            }

            public String toString() {
                return wrap.toString();
            }
        };
    }

    private static DebuggableTask.RunnableDebuggableTask enforceOptionsDebuggable(final WithResources withResources, final DebuggableTask.RunnableDebuggableTask debuggable, final boolean propagate) {
        return new DebuggableTask.RunnableDebuggableTask(){

            @Override
            public void run() {
                block14: {
                    try (Closeable close = withResources.get();){
                        debuggable.run();
                    }
                    catch (Throwable t) {
                        ExecutionFailure.handle(t);
                        if (!propagate) break block14;
                        throw t;
                    }
                }
            }

            public String toString() {
                return debuggable.toString();
            }

            @Override
            public long creationTimeNanos() {
                return debuggable.creationTimeNanos();
            }

            @Override
            public long startTimeNanos() {
                return debuggable.startTimeNanos();
            }

            @Override
            public String description() {
                return debuggable.description();
            }
        };
    }

    static <V> Callable<V> propagating(Callable<V> wrap) {
        return ExecutionFailure.enforceOptions(WithResources.none(), wrap);
    }

    static <V> Callable<V> enforceOptions(final WithResources withResources, final Callable<V> wrap) {
        return new Callable<V>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public V call() throws Exception {
                try (Closeable close = withResources.get();){
                    Object v = wrap.call();
                    return v;
                }
                catch (Throwable t) {
                    ExecutionFailure.handle(t);
                    throw t;
                }
            }

            public String toString() {
                return wrap.toString();
            }
        };
    }
}

