/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.http.protocol;

import com.clickhouse.client.internal.org.apache.hc.core5.annotation.Internal;
import com.clickhouse.client.internal.org.apache.hc.core5.http.EndpointDetails;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpRequest;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpResponse;
import com.clickhouse.client.internal.org.apache.hc.core5.http.HttpVersion;
import com.clickhouse.client.internal.org.apache.hc.core5.http.ProtocolVersion;
import com.clickhouse.client.internal.org.apache.hc.core5.http.protocol.HttpContext;
import com.clickhouse.client.internal.org.apache.hc.core5.util.Args;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSession;

public class HttpCoreContext
implements HttpContext {
    @Deprecated
    public static final String CONNECTION_ENDPOINT = "http.connection-endpoint";
    @Deprecated
    public static final String SSL_SESSION = "http.ssl-session";
    @Deprecated
    public static final String HTTP_REQUEST = "http.request";
    @Deprecated
    public static final String HTTP_RESPONSE = "http.response";
    private final HttpContext parentContext;
    private Map<String, Object> map;
    private ProtocolVersion version;
    private HttpRequest request;
    private HttpResponse response;
    private EndpointDetails endpointDetails;
    private SSLSession sslSession;

    public static HttpCoreContext create() {
        return new HttpCoreContext();
    }

    @Deprecated
    public static HttpCoreContext adapt(HttpContext context) {
        if (context == null) {
            return new HttpCoreContext();
        }
        if (context instanceof HttpCoreContext) {
            return (HttpCoreContext)context;
        }
        return new HttpCoreContext(context);
    }

    public static HttpCoreContext cast(HttpContext context) {
        if (context == null) {
            return null;
        }
        return context instanceof HttpCoreContext ? (HttpCoreContext)context : new Delegate(context);
    }

    public static HttpCoreContext castOrCreate(HttpContext context) {
        return context != null ? HttpCoreContext.cast(context) : HttpCoreContext.create();
    }

    public HttpCoreContext(HttpContext parentContext) {
        this.parentContext = parentContext;
    }

    public HttpCoreContext() {
        this.parentContext = null;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpVersion.HTTP_1_1;
    }

    @Override
    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public Object getAttribute(String id) {
        Object o;
        Object object = o = this.map != null ? this.map.get(id) : null;
        if (o == null && this.parentContext != null) {
            o = this.parentContext.getAttribute(id);
        }
        return o;
    }

    @Override
    public Object setAttribute(String id, Object obj) {
        if (this.map == null) {
            this.map = new HashMap<String, Object>();
        }
        return this.map.put(id, obj);
    }

    @Override
    public Object removeAttribute(String id) {
        return this.map != null ? this.map.remove(id) : null;
    }

    public <T> T getAttribute(String id, Class<T> clazz) {
        Args.notNull(clazz, "Attribute class");
        Object obj = this.getAttribute(id);
        return obj != null ? (T)clazz.cast(obj) : null;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    @Internal
    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    @Internal
    public void setResponse(HttpResponse response) {
        this.response = response;
    }

    public EndpointDetails getEndpointDetails() {
        return this.endpointDetails;
    }

    @Internal
    public void setEndpointDetails(EndpointDetails endpointDetails) {
        this.endpointDetails = endpointDetails;
    }

    public SSLSession getSSLSession() {
        return this.sslSession;
    }

    @Internal
    public void setSSLSession(SSLSession sslSession) {
        this.sslSession = sslSession;
    }

    public String toString() {
        return "HttpCoreContext{version=" + this.version + ", request=" + this.request + ", response=" + this.response + ", endpointDetails=" + this.endpointDetails + ", sslSession=" + this.sslSession + '}';
    }

    @Internal
    static class Delegate
    extends HttpCoreContext {
        private final HttpContext httpContext;

        Delegate(HttpContext httpContext) {
            super(null);
            this.httpContext = httpContext;
        }

        <T> T getAttr(String id, Class<T> clazz) {
            Object obj = this.httpContext.getAttribute(id);
            if (obj == null) {
                return null;
            }
            return clazz.cast(obj);
        }

        @Override
        public HttpRequest getRequest() {
            return this.getAttr(HttpCoreContext.HTTP_REQUEST, HttpRequest.class);
        }

        @Override
        public void setRequest(HttpRequest request) {
            this.httpContext.setAttribute(HttpCoreContext.HTTP_REQUEST, request);
        }

        @Override
        public HttpResponse getResponse() {
            return this.getAttr(HttpCoreContext.HTTP_RESPONSE, HttpResponse.class);
        }

        @Override
        public void setResponse(HttpResponse response) {
            this.httpContext.setAttribute(HttpCoreContext.HTTP_RESPONSE, response);
        }

        @Override
        public EndpointDetails getEndpointDetails() {
            return this.getAttr(HttpCoreContext.CONNECTION_ENDPOINT, EndpointDetails.class);
        }

        @Override
        public void setEndpointDetails(EndpointDetails endpointDetails) {
            this.httpContext.setAttribute(HttpCoreContext.CONNECTION_ENDPOINT, endpointDetails);
        }

        @Override
        public SSLSession getSSLSession() {
            return this.getAttr(HttpCoreContext.SSL_SESSION, SSLSession.class);
        }

        @Override
        public void setSSLSession(SSLSession sslSession) {
            this.httpContext.setAttribute(HttpCoreContext.SSL_SESSION, sslSession);
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return this.httpContext.getProtocolVersion();
        }

        @Override
        public void setProtocolVersion(ProtocolVersion version) {
            this.httpContext.setProtocolVersion(version);
        }

        @Override
        public Object getAttribute(String id) {
            return this.httpContext.getAttribute(id);
        }

        @Override
        public Object setAttribute(String id, Object obj) {
            return this.httpContext.setAttribute(id, obj);
        }

        @Override
        public Object removeAttribute(String id) {
            return this.httpContext.removeAttribute(id);
        }

        @Override
        public <T> T getAttribute(String id, Class<T> clazz) {
            return this.getAttr(id, clazz);
        }

        @Override
        public String toString() {
            return this.httpContext.toString();
        }
    }
}

