/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.serde;

import com.clickhouse.client.api.data_formats.RowBinaryFormatSerializer;
import com.clickhouse.client.api.data_formats.internal.SerializerUtils;
import com.clickhouse.client.api.metadata.ColumnToMethodMatchingStrategy;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.serde.POJOFieldDeserializer;
import com.clickhouse.client.api.serde.POJOFieldSerializer;
import com.clickhouse.data.ClickHouseColumn;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POJOSerDe {
    private static final Logger LOG = LoggerFactory.getLogger(POJOSerDe.class);
    private final ColumnToMethodMatchingStrategy columnToMethodMatchingStrategy;
    private final Map<Class<?>, Map<String, Map<String, POJOFieldSerializer>>> serializers;
    private final Map<Class<?>, Map<String, Map<String, POJOFieldDeserializer>>> deserializers;

    public POJOSerDe(ColumnToMethodMatchingStrategy matchingStrategy) {
        this.columnToMethodMatchingStrategy = matchingStrategy;
        this.serializers = new ConcurrentHashMap();
        this.deserializers = new ConcurrentHashMap();
    }

    public void registerClass(Class<?> clazz, TableSchema schema) {
        String schemaKey;
        ColumnToMethodMatchingStrategy matchingStrategy = this.columnToMethodMatchingStrategy;
        HashMap<String, Object> classGetters = new HashMap<String, Object>();
        HashMap<String, Object> classSetters = new HashMap<String, Object>();
        for (Method method : clazz.getMethods()) {
            String methodName;
            if (matchingStrategy.isGetter(method.getName())) {
                methodName = matchingStrategy.normalizeMethodName(method.getName());
                classGetters.put(methodName, method);
                continue;
            }
            if (!matchingStrategy.isSetter(method.getName())) continue;
            methodName = matchingStrategy.normalizeMethodName(method.getName());
            classSetters.put(methodName, method);
        }
        HashMap<String, POJOFieldSerializer> schemaSerializers = new HashMap<String, POJOFieldSerializer>();
        ConcurrentHashMap<String, POJOFieldDeserializer> schemaDeserializers = new ConcurrentHashMap<String, POJOFieldDeserializer>();
        boolean defaultsSupport = schema.hasDefaults();
        for (ClickHouseColumn column : schema.getColumns()) {
            String propertyName = this.columnToMethodMatchingStrategy.normalizeColumnName(column.getColumnName());
            Method getterMethod = (Method)classGetters.get(propertyName);
            if (getterMethod != null) {
                schemaSerializers.put(column.getColumnName(), (obj, stream) -> {
                    Object value = getterMethod.invoke(obj, new Object[0]);
                    if (RowBinaryFormatSerializer.writeValuePreamble(stream, defaultsSupport, column, value)) {
                        SerializerUtils.serializeData(stream, value, column);
                    }
                });
            } else {
                LOG.warn("No getter method found for column: {}", (Object)propertyName);
            }
            Method setterMethod = (Method)classSetters.get(propertyName);
            if (setterMethod != null) {
                schemaDeserializers.put(column.getColumnName(), SerializerUtils.compilePOJOSetter(setterMethod, column));
                continue;
            }
            LOG.warn("No setter method found for column: {}", (Object)propertyName);
        }
        Map classSerializers = this.serializers.computeIfAbsent(clazz, k -> new HashMap());
        Map classDeserializers = this.deserializers.computeIfAbsent(clazz, k -> new HashMap());
        if (schema.getTableName() != null && schema.getQuery() == null) {
            schemaKey = schema.getTableName();
        } else if (schema.getQuery() != null && schema.getTableName() == null) {
            schemaKey = schema.getQuery();
        } else {
            throw new IllegalArgumentException("Table schema has both query and table name set. Only one is allowed.");
        }
        classSerializers.put(schemaKey, schemaSerializers);
        classDeserializers.put(schemaKey, schemaDeserializers);
    }

    public Map<String, POJOFieldSerializer> getFieldSerializers(Class<?> clazz, TableSchema schema) {
        return this.serializers.getOrDefault(clazz, Collections.emptyMap()).getOrDefault(schema.getTableName() == null ? schema.getQuery() : schema.getTableName(), Collections.emptyMap());
    }

    public Map<String, POJOFieldDeserializer> getFieldDeserializers(Class<?> clazz, TableSchema schema) {
        return this.deserializers.getOrDefault(clazz, Collections.emptyMap()).getOrDefault(schema.getTableName() == null ? schema.getQuery() : schema.getTableName(), Collections.emptyMap());
    }
}

