/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.file.types.svg;

import org.apache.hop.core.SwtUniversalImageSvg;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.svg.SvgCache;
import org.apache.hop.core.svg.SvgCacheEntry;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.svg.SvgImage;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.svg.SvgExplorerFileType;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Document;

public class SvgExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler
implements IExplorerFileTypeHandler {
    public SvgExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    private static void paintControl(PaintEvent event, ExplorerFile explorerFile, Canvas canvas) {
        Rectangle area = canvas.getBounds();
        try {
            SvgCacheEntry entry = SvgCache.loadSvg((SvgFile)new SvgFile(explorerFile.getFilename(), SvgExplorerFileType.class.getClassLoader()));
            SwtUniversalImageSvg svg = new SwtUniversalImageSvg(new SvgImage((Document)entry.getSvgDocument()), true);
            float factorX = (float)area.width / entry.getWidth();
            float factorY = (float)area.height / entry.getHeight();
            float minFactor = Math.min(factorX, factorY);
            int imageWidth = (int)(entry.getWidth() * minFactor);
            int imageHeight = (int)(entry.getHeight() * minFactor);
            Image image = svg.getAsBitmapForSize((Device)canvas.getDisplay(), imageWidth, imageHeight);
            event.gc.drawImage(image, 0, 0);
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error rendering SVG", (Throwable)e);
        }
    }

    @Override
    public void renderFile(Composite composite) {
        Canvas wCanvas = new Canvas(composite, 0);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(0, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.top = new FormAttachment(0, 0);
        fdCanvas.bottom = new FormAttachment(100, 0);
        wCanvas.setLayoutData((Object)fdCanvas);
        wCanvas.addPaintListener(e -> SvgExplorerFileTypeHandler.paintControl(e, this.explorerFile, wCanvas));
    }
}

